/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.wcdb.winq;

import com.tencent.wcdb.base.CppObject;
import com.tencent.wcdb.base.Value;
import com.tencent.wcdb.winq.Expression;
import com.tencent.wcdb.winq.ExpressionConvertible;
import com.tencent.wcdb.winq.Identifier;
import com.tencent.wcdb.winq.MultiTypeArray;
import com.tencent.wcdb.winq.StatementSelect;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExpressionOperable
extends Identifier
implements ExpressionConvertible {
    @NotNull
    public Expression isNull() {
        return this.nullOperate(false);
    }

    @NotNull
    public Expression notNull() {
        return this.nullOperate(true);
    }

    @NotNull
    public Expression or(@Nullable ExpressionConvertible operand) {
        return this.binaryOperate(operand, 19, false);
    }

    @NotNull
    public Expression and(@Nullable ExpressionConvertible operand) {
        return this.binaryOperate(operand, 18, false);
    }

    @NotNull
    public Expression multiply(@Nullable ExpressionConvertible operand) {
        return this.binaryOperate(operand, 2, false);
    }

    @NotNull
    public Expression multiply(byte operand) {
        return this.binaryOperate(operand, 2, false);
    }

    @NotNull
    public Expression multiply(short operand) {
        return this.binaryOperate(operand, 2, false);
    }

    @NotNull
    public Expression multiply(int operand) {
        return this.binaryOperate(operand, 2, false);
    }

    @NotNull
    public Expression multiply(long operand) {
        return this.binaryOperate(operand, 2, false);
    }

    @NotNull
    public Expression multiply(float operand) {
        return this.binaryOperate(operand, 2, false);
    }

    @NotNull
    public Expression multiply(double operand) {
        return this.binaryOperate(operand, 2, false);
    }

    @NotNull
    public Expression divide(@NotNull ExpressionConvertible operand) {
        return this.binaryOperate(operand, 3, false);
    }

    @NotNull
    public Expression divide(byte operand) {
        return this.binaryOperate(operand, 3, false);
    }

    @NotNull
    public Expression divide(short operand) {
        return this.binaryOperate(operand, 3, false);
    }

    @NotNull
    public Expression divide(int operand) {
        return this.binaryOperate(operand, 3, false);
    }

    @NotNull
    public Expression divide(long operand) {
        return this.binaryOperate(operand, 3, false);
    }

    @NotNull
    public Expression divide(float operand) {
        return this.binaryOperate(operand, 3, false);
    }

    @NotNull
    public Expression divide(double operand) {
        return this.binaryOperate(operand, 3, false);
    }

    @NotNull
    public Expression mod(@NotNull ExpressionConvertible operand) {
        return this.binaryOperate(operand, 4, false);
    }

    @NotNull
    public Expression mod(byte operand) {
        return this.binaryOperate(operand, 4, false);
    }

    @NotNull
    public Expression mod(short operand) {
        return this.binaryOperate(operand, 4, false);
    }

    @NotNull
    public Expression mod(int operand) {
        return this.binaryOperate(operand, 4, false);
    }

    @NotNull
    public Expression mod(long operand) {
        return this.binaryOperate(operand, 4, false);
    }

    @NotNull
    public Expression mod(float operand) {
        return this.binaryOperate(operand, 4, false);
    }

    @NotNull
    public Expression mod(double operand) {
        return this.binaryOperate(operand, 4, false);
    }

    @NotNull
    public Expression add(@Nullable ExpressionConvertible operand) {
        return this.binaryOperate(operand, 5, false);
    }

    @NotNull
    public Expression add(byte operand) {
        return this.binaryOperate(operand, 5, false);
    }

    @NotNull
    public Expression add(short operand) {
        return this.binaryOperate(operand, 5, false);
    }

    @NotNull
    public Expression add(int operand) {
        return this.binaryOperate(operand, 5, false);
    }

    @NotNull
    public Expression add(long operand) {
        return this.binaryOperate(operand, 5, false);
    }

    @NotNull
    public Expression add(float operand) {
        return this.binaryOperate(operand, 5, false);
    }

    @NotNull
    public Expression add(double operand) {
        return this.binaryOperate(operand, 5, false);
    }

    @NotNull
    public Expression minus(@Nullable ExpressionConvertible operand) {
        return this.binaryOperate(operand, 6, false);
    }

    @NotNull
    public Expression minus(byte operand) {
        return this.binaryOperate(operand, 6, false);
    }

    @NotNull
    public Expression minus(short operand) {
        return this.binaryOperate(operand, 6, false);
    }

    @NotNull
    public Expression minus(int operand) {
        return this.binaryOperate(operand, 6, false);
    }

    @NotNull
    public Expression minus(long operand) {
        return this.binaryOperate(operand, 6, false);
    }

    @NotNull
    public Expression minus(float operand) {
        return this.binaryOperate(operand, 6, false);
    }

    @NotNull
    public Expression minus(double operand) {
        return this.binaryOperate(operand, 6, false);
    }

    @NotNull
    public Expression leftShift(@Nullable ExpressionConvertible operand) {
        return this.binaryOperate(operand, 7, false);
    }

    @NotNull
    public Expression leftShift(byte operand) {
        return this.binaryOperate(operand, 7, false);
    }

    @NotNull
    public Expression leftShift(short operand) {
        return this.binaryOperate(operand, 7, false);
    }

    @NotNull
    public Expression leftShift(int operand) {
        return this.binaryOperate(operand, 7, false);
    }

    @NotNull
    public Expression leftShift(long operand) {
        return this.binaryOperate(operand, 7, false);
    }

    @NotNull
    public Expression rightShift(@Nullable ExpressionConvertible operand) {
        return this.binaryOperate(operand, 8, false);
    }

    @NotNull
    public Expression rightShift(byte operand) {
        return this.binaryOperate(operand, 8, false);
    }

    @NotNull
    public Expression rightShift(short operand) {
        return this.binaryOperate(operand, 8, false);
    }

    @NotNull
    public Expression rightShift(int operand) {
        return this.binaryOperate(operand, 8, false);
    }

    @NotNull
    public Expression rightShift(long operand) {
        return this.binaryOperate(operand, 8, false);
    }

    @NotNull
    public Expression bitAnd(@Nullable ExpressionConvertible operand) {
        return this.binaryOperate(operand, 9, false);
    }

    @NotNull
    public Expression bitAnd(byte operand) {
        return this.binaryOperate(operand, 9, false);
    }

    @NotNull
    public Expression bitAnd(short operand) {
        return this.binaryOperate(operand, 9, false);
    }

    @NotNull
    public Expression bitAnd(int operand) {
        return this.binaryOperate(operand, 9, false);
    }

    @NotNull
    public Expression bitAnd(long operand) {
        return this.binaryOperate(operand, 9, false);
    }

    @NotNull
    public Expression bitOr(@Nullable ExpressionConvertible operand) {
        return this.binaryOperate(operand, 10, false);
    }

    @NotNull
    public Expression bitOr(byte operand) {
        return this.binaryOperate(operand, 10, false);
    }

    @NotNull
    public Expression bitOr(short operand) {
        return this.binaryOperate(operand, 10, false);
    }

    @NotNull
    public Expression bitOr(int operand) {
        return this.binaryOperate(operand, 10, false);
    }

    @NotNull
    public Expression bitOr(long operand) {
        return this.binaryOperate(operand, 10, false);
    }

    @NotNull
    public Expression lt(@Nullable ExpressionConvertible operand) {
        return this.binaryOperate(operand, 11, false);
    }

    @NotNull
    public Expression lt(byte operand) {
        return this.binaryOperate(operand, 11, false);
    }

    @NotNull
    public Expression lt(short operand) {
        return this.binaryOperate(operand, 11, false);
    }

    @NotNull
    public Expression lt(int operand) {
        return this.binaryOperate(operand, 11, false);
    }

    @NotNull
    public Expression lt(long operand) {
        return this.binaryOperate(operand, 11, false);
    }

    @NotNull
    public Expression lt(double operand) {
        return this.binaryOperate(operand, 11, false);
    }

    @NotNull
    public Expression lt(@Nullable String operand) {
        return this.binaryOperate(operand, 11, false);
    }

    @NotNull
    public Expression le(@Nullable ExpressionConvertible operand) {
        return this.binaryOperate(operand, 12, false);
    }

    @NotNull
    public Expression le(byte operand) {
        return this.binaryOperate(operand, 12, false);
    }

    @NotNull
    public Expression le(short operand) {
        return this.binaryOperate(operand, 12, false);
    }

    @NotNull
    public Expression le(int operand) {
        return this.binaryOperate(operand, 12, false);
    }

    @NotNull
    public Expression le(long operand) {
        return this.binaryOperate(operand, 12, false);
    }

    @NotNull
    public Expression le(float operand) {
        return this.binaryOperate(operand, 12, false);
    }

    @NotNull
    public Expression le(double operand) {
        return this.binaryOperate(operand, 12, false);
    }

    @NotNull
    public Expression le(@Nullable String operand) {
        return this.binaryOperate(operand, 12, false);
    }

    @NotNull
    public Expression gt(@Nullable ExpressionConvertible operand) {
        return this.binaryOperate(operand, 13, false);
    }

    @NotNull
    public Expression gt(byte operand) {
        return this.binaryOperate(operand, 13, false);
    }

    @NotNull
    public Expression gt(short operand) {
        return this.binaryOperate(operand, 13, false);
    }

    @NotNull
    public Expression gt(int operand) {
        return this.binaryOperate(operand, 13, false);
    }

    @NotNull
    public Expression gt(long operand) {
        return this.binaryOperate(operand, 13, false);
    }

    @NotNull
    public Expression gt(float operand) {
        return this.binaryOperate(operand, 13, false);
    }

    @NotNull
    public Expression gt(double operand) {
        return this.binaryOperate(operand, 13, false);
    }

    @NotNull
    public Expression gt(@Nullable String operand) {
        return this.binaryOperate(operand, 13, false);
    }

    @NotNull
    public Expression ge(@Nullable ExpressionConvertible operand) {
        return this.binaryOperate(operand, 14, false);
    }

    @NotNull
    public Expression ge(byte operand) {
        return this.binaryOperate(operand, 14, false);
    }

    @NotNull
    public Expression ge(short operand) {
        return this.binaryOperate(operand, 14, false);
    }

    @NotNull
    public Expression ge(int operand) {
        return this.binaryOperate(operand, 14, false);
    }

    @NotNull
    public Expression ge(long operand) {
        return this.binaryOperate(operand, 14, false);
    }

    @NotNull
    public Expression ge(float operand) {
        return this.binaryOperate(operand, 14, false);
    }

    @NotNull
    public Expression ge(double operand) {
        return this.binaryOperate(operand, 14, false);
    }

    @NotNull
    public Expression ge(@Nullable String operand) {
        return this.binaryOperate(operand, 14, false);
    }

    @NotNull
    public Expression eq(@Nullable ExpressionConvertible operand) {
        return this.binaryOperate(operand, 15, false);
    }

    @NotNull
    public Expression eq(boolean operand) {
        return this.binaryOperate(operand, 15, false);
    }

    @NotNull
    public Expression eq(byte operand) {
        return this.binaryOperate(operand, 15, false);
    }

    @NotNull
    public Expression eq(short operand) {
        return this.binaryOperate(operand, 15, false);
    }

    @NotNull
    public Expression eq(int operand) {
        return this.binaryOperate(operand, 15, false);
    }

    @NotNull
    public Expression eq(long operand) {
        return this.binaryOperate(operand, 15, false);
    }

    @NotNull
    public Expression eq(float operand) {
        return this.binaryOperate(operand, 15, false);
    }

    @NotNull
    public Expression eq(double operand) {
        return this.binaryOperate(operand, 15, false);
    }

    @NotNull
    public Expression eq(@Nullable String operand) {
        return this.binaryOperate(operand, 15, false);
    }

    @NotNull
    public Expression notEq(@Nullable ExpressionConvertible operand) {
        return this.binaryOperate(operand, 16, false);
    }

    @NotNull
    public Expression notEq(boolean operand) {
        return this.binaryOperate(operand, 16, false);
    }

    @NotNull
    public Expression notEq(byte operand) {
        return this.binaryOperate(operand, 16, false);
    }

    @NotNull
    public Expression notEq(short operand) {
        return this.binaryOperate(operand, 16, false);
    }

    @NotNull
    public Expression notEq(int operand) {
        return this.binaryOperate(operand, 16, false);
    }

    @NotNull
    public Expression notEq(long operand) {
        return this.binaryOperate(operand, 16, false);
    }

    @NotNull
    public Expression notEq(float operand) {
        return this.binaryOperate(operand, 16, false);
    }

    @NotNull
    public Expression notEq(double operand) {
        return this.binaryOperate(operand, 16, false);
    }

    @NotNull
    public Expression notEq(@Nullable String operand) {
        return this.binaryOperate(operand, 16, false);
    }

    @NotNull
    public Expression concat(byte operand) {
        return this.binaryOperate(operand, 1, false);
    }

    @NotNull
    public Expression concat(short operand) {
        return this.binaryOperate(operand, 1, false);
    }

    @NotNull
    public Expression concat(int operand) {
        return this.binaryOperate(operand, 1, false);
    }

    @NotNull
    public Expression concat(long operand) {
        return this.binaryOperate(operand, 1, false);
    }

    @NotNull
    public Expression concat(float operand) {
        return this.binaryOperate(operand, 1, false);
    }

    @NotNull
    public Expression concat(double operand) {
        return this.binaryOperate(operand, 1, false);
    }

    @NotNull
    public Expression concat(@Nullable String operand) {
        return this.binaryOperate(operand, 1, false);
    }

    @NotNull
    public Expression concat(@Nullable ExpressionConvertible operand) {
        return this.binaryOperate(operand, 1, false);
    }

    @NotNull
    public Expression between(@Nullable ExpressionConvertible begin, @Nullable ExpressionConvertible end) {
        return ExpressionOperable.createExpression(ExpressionOperable.betweenOperate(Identifier.getCppType(this), CppObject.get(this), Identifier.getCppType(begin), CppObject.get(begin), 0.0, null, Identifier.getCppType(end), CppObject.get(end), 0.0, null, false));
    }

    @NotNull
    public Expression between(@Nullable ExpressionConvertible begin, long end) {
        return ExpressionOperable.createExpression(ExpressionOperable.betweenOperate(Identifier.getCppType(this), CppObject.get(this), Identifier.getCppType(begin), CppObject.get(begin), 0.0, null, 3, end, 0.0, null, false));
    }

    @NotNull
    public Expression between(@Nullable ExpressionConvertible begin, double end) {
        return ExpressionOperable.createExpression(ExpressionOperable.betweenOperate(Identifier.getCppType(this), CppObject.get(this), Identifier.getCppType(begin), CppObject.get(begin), 0.0, null, 5, 0L, end, null, false));
    }

    @NotNull
    public Expression between(@Nullable ExpressionConvertible begin, String end) {
        return ExpressionOperable.createExpression(ExpressionOperable.betweenOperate(Identifier.getCppType(this), CppObject.get(this), Identifier.getCppType(begin), CppObject.get(begin), 0.0, null, 6, 0L, 0.0, end, false));
    }

    @NotNull
    public Expression between(long begin, @Nullable ExpressionConvertible end) {
        return ExpressionOperable.createExpression(ExpressionOperable.betweenOperate(Identifier.getCppType(this), CppObject.get(this), 3, begin, 0.0, null, Identifier.getCppType(end), CppObject.get(end), 0.0, null, false));
    }

    @NotNull
    public Expression between(long begin, long end) {
        return ExpressionOperable.createExpression(ExpressionOperable.betweenOperate(Identifier.getCppType(this), CppObject.get(this), 3, begin, 0.0, null, 3, end, 0.0, null, false));
    }

    @NotNull
    public Expression between(long begin, double end) {
        return ExpressionOperable.createExpression(ExpressionOperable.betweenOperate(Identifier.getCppType(this), CppObject.get(this), 3, begin, 0.0, null, 5, 0L, end, null, false));
    }

    @NotNull
    public Expression between(long begin, @Nullable String end) {
        return ExpressionOperable.createExpression(ExpressionOperable.betweenOperate(Identifier.getCppType(this), CppObject.get(this), 3, begin, 0.0, null, 6, 0L, 0.0, end, false));
    }

    @NotNull
    public Expression between(double begin, @Nullable ExpressionConvertible end) {
        return ExpressionOperable.createExpression(ExpressionOperable.betweenOperate(Identifier.getCppType(this), CppObject.get(this), 5, 0L, begin, null, Identifier.getCppType(end), CppObject.get(end), 0.0, null, false));
    }

    @NotNull
    public Expression between(double begin, long end) {
        return ExpressionOperable.createExpression(ExpressionOperable.betweenOperate(Identifier.getCppType(this), CppObject.get(this), 5, 0L, begin, null, 3, end, 0.0, null, false));
    }

    @NotNull
    public Expression between(double begin, double end) {
        return ExpressionOperable.createExpression(ExpressionOperable.betweenOperate(Identifier.getCppType(this), CppObject.get(this), 5, 0L, begin, null, 5, 0L, end, null, false));
    }

    @NotNull
    public Expression between(double begin, @Nullable String end) {
        return ExpressionOperable.createExpression(ExpressionOperable.betweenOperate(Identifier.getCppType(this), CppObject.get(this), 5, 0L, begin, null, 6, 0L, 0.0, end, false));
    }

    @NotNull
    public Expression between(@Nullable String begin, @Nullable ExpressionConvertible end) {
        return ExpressionOperable.createExpression(ExpressionOperable.betweenOperate(Identifier.getCppType(this), CppObject.get(this), 6, 0L, 0.0, begin, Identifier.getCppType(end), CppObject.get(end), 0.0, null, false));
    }

    @NotNull
    public Expression between(@Nullable String begin, long end) {
        return ExpressionOperable.createExpression(ExpressionOperable.betweenOperate(Identifier.getCppType(this), CppObject.get(this), 6, 0L, 0.0, begin, 3, end, 0.0, null, false));
    }

    @NotNull
    public Expression between(@Nullable String begin, double end) {
        return ExpressionOperable.createExpression(ExpressionOperable.betweenOperate(Identifier.getCppType(this), CppObject.get(this), 6, 0L, 0.0, begin, 5, 0L, end, null, false));
    }

    @NotNull
    public Expression between(@Nullable String begin, String end) {
        return ExpressionOperable.createExpression(ExpressionOperable.betweenOperate(Identifier.getCppType(this), CppObject.get(this), 6, 0L, 0.0, begin, 6, 0L, 0.0, end, false));
    }

    @NotNull
    public Expression notBetween(@Nullable ExpressionConvertible begin, @Nullable ExpressionConvertible end) {
        return ExpressionOperable.createExpression(ExpressionOperable.betweenOperate(Identifier.getCppType(this), CppObject.get(this), Identifier.getCppType(begin), CppObject.get(begin), 0.0, null, Identifier.getCppType(end), CppObject.get(end), 0.0, null, true));
    }

    @NotNull
    public Expression notBetween(@Nullable ExpressionConvertible begin, long end) {
        return ExpressionOperable.createExpression(ExpressionOperable.betweenOperate(Identifier.getCppType(this), CppObject.get(this), Identifier.getCppType(begin), CppObject.get(begin), 0.0, null, 3, end, 0.0, null, true));
    }

    @NotNull
    public Expression notBetween(@Nullable ExpressionConvertible begin, double end) {
        return ExpressionOperable.createExpression(ExpressionOperable.betweenOperate(Identifier.getCppType(this), CppObject.get(this), Identifier.getCppType(begin), CppObject.get(begin), 0.0, null, 5, 0L, end, null, true));
    }

    @NotNull
    public Expression notBetween(@Nullable ExpressionConvertible begin, @Nullable String end) {
        return ExpressionOperable.createExpression(ExpressionOperable.betweenOperate(Identifier.getCppType(this), CppObject.get(this), Identifier.getCppType(begin), CppObject.get(begin), 0.0, null, 6, 0L, 0.0, end, true));
    }

    @NotNull
    public Expression notBetween(long begin, @Nullable ExpressionConvertible end) {
        return ExpressionOperable.createExpression(ExpressionOperable.betweenOperate(Identifier.getCppType(this), CppObject.get(this), 3, begin, 0.0, null, Identifier.getCppType(end), CppObject.get(end), 0.0, null, true));
    }

    @NotNull
    public Expression notBetween(long begin, long end) {
        return ExpressionOperable.createExpression(ExpressionOperable.betweenOperate(Identifier.getCppType(this), CppObject.get(this), 3, begin, 0.0, null, 3, end, 0.0, null, true));
    }

    @NotNull
    public Expression notBetween(long begin, double end) {
        return ExpressionOperable.createExpression(ExpressionOperable.betweenOperate(Identifier.getCppType(this), CppObject.get(this), 3, begin, 0.0, null, 5, 0L, end, null, true));
    }

    @NotNull
    public Expression notBetween(long begin, @Nullable String end) {
        return ExpressionOperable.createExpression(ExpressionOperable.betweenOperate(Identifier.getCppType(this), CppObject.get(this), 3, begin, 0.0, null, 6, 0L, 0.0, end, true));
    }

    @NotNull
    public Expression notBetween(double begin, @Nullable ExpressionConvertible end) {
        return ExpressionOperable.createExpression(ExpressionOperable.betweenOperate(Identifier.getCppType(this), CppObject.get(this), 5, 0L, begin, null, Identifier.getCppType(end), CppObject.get(end), 0.0, null, true));
    }

    @NotNull
    public Expression notBetween(double begin, long end) {
        return ExpressionOperable.createExpression(ExpressionOperable.betweenOperate(Identifier.getCppType(this), CppObject.get(this), 5, 0L, begin, null, 3, end, 0.0, null, true));
    }

    @NotNull
    public Expression notBetween(double begin, double end) {
        return ExpressionOperable.createExpression(ExpressionOperable.betweenOperate(Identifier.getCppType(this), CppObject.get(this), 5, 0L, begin, null, 5, 0L, end, null, true));
    }

    @NotNull
    public Expression notBetween(double begin, @Nullable String end) {
        return ExpressionOperable.createExpression(ExpressionOperable.betweenOperate(Identifier.getCppType(this), CppObject.get(this), 5, 0L, begin, null, 6, 0L, 0.0, end, true));
    }

    @NotNull
    public Expression notBetween(@Nullable String begin, @Nullable ExpressionConvertible end) {
        return ExpressionOperable.createExpression(ExpressionOperable.betweenOperate(Identifier.getCppType(this), CppObject.get(this), 6, 0L, 0.0, begin, Identifier.getCppType(end), CppObject.get(end), 0.0, null, true));
    }

    @NotNull
    public Expression notBetween(@Nullable String begin, long end) {
        return ExpressionOperable.createExpression(ExpressionOperable.betweenOperate(Identifier.getCppType(this), CppObject.get(this), 6, 0L, 0.0, begin, 3, end, 0.0, null, true));
    }

    @NotNull
    public Expression notBetween(@Nullable String begin, double end) {
        return ExpressionOperable.createExpression(ExpressionOperable.betweenOperate(Identifier.getCppType(this), CppObject.get(this), 6, 0L, 0.0, begin, 5, 0L, end, null, true));
    }

    @NotNull
    public Expression notBetween(@Nullable String begin, @Nullable String end) {
        return ExpressionOperable.createExpression(ExpressionOperable.betweenOperate(Identifier.getCppType(this), CppObject.get(this), 6, 0L, 0.0, begin, 6, 0L, 0.0, end, true));
    }

    @NotNull
    public Expression in(short ... operands) {
        long[] values = new long[operands.length];
        for (int i = 0; i < operands.length; ++i) {
            values[i] = operands[i];
        }
        return this.in(values, false);
    }

    @NotNull
    public Expression in(@NotNull Short[] operands) {
        long[] values = new long[operands.length];
        for (int i = 0; i < operands.length; ++i) {
            values[i] = operands[i].shortValue();
        }
        return this.in(values, false);
    }

    @NotNull
    public Expression in(int ... operands) {
        long[] values = new long[operands.length];
        for (int i = 0; i < operands.length; ++i) {
            values[i] = operands[i];
        }
        return this.in(values, false);
    }

    @NotNull
    public Expression in(@NotNull Integer[] operands) {
        long[] values = new long[operands.length];
        for (int i = 0; i < operands.length; ++i) {
            values[i] = operands[i].intValue();
        }
        return this.in(values, false);
    }

    @NotNull
    public Expression in(long ... operands) {
        return this.in(operands, false);
    }

    @NotNull
    public Expression in(@NotNull Long[] operands) {
        return this.in((Object[])operands, false);
    }

    @NotNull
    public Expression in(float ... operands) {
        double[] values = new double[operands.length];
        for (int i = 0; i < operands.length; ++i) {
            values[i] = operands[i];
        }
        return this.in(values, false);
    }

    @NotNull
    public Expression in(@NotNull Float[] operands) {
        double[] values = new double[operands.length];
        for (int i = 0; i < operands.length; ++i) {
            values[i] = operands[i].floatValue();
        }
        return this.in(values, false);
    }

    @NotNull
    public Expression in(double ... operands) {
        return this.in(operands, false);
    }

    @NotNull
    public Expression in(@NotNull Double[] operands) {
        return this.in((Object[])operands, false);
    }

    @NotNull
    public Expression in(String ... operands) {
        return this.in(operands, false);
    }

    @NotNull
    public Expression in(Value ... operands) {
        return this.in((Object[])operands, false);
    }

    @NotNull
    public <T> Expression in(@NotNull Set<T> operands) {
        return this.in(operands.toArray(), false);
    }

    @NotNull
    public <T> Expression in(@NotNull List<T> operands) {
        return this.in(operands.toArray(), false);
    }

    @NotNull
    public Expression notIn(short ... operands) {
        long[] values = new long[operands.length];
        for (int i = 0; i < operands.length; ++i) {
            values[i] = operands[i];
        }
        return this.in(values, true);
    }

    @NotNull
    public Expression notIn(@NotNull Short[] operands) {
        long[] values = new long[operands.length];
        for (int i = 0; i < operands.length; ++i) {
            values[i] = operands[i].shortValue();
        }
        return this.in(values, true);
    }

    @NotNull
    public Expression notIn(int ... operands) {
        long[] values = new long[operands.length];
        for (int i = 0; i < operands.length; ++i) {
            values[i] = operands[i];
        }
        return this.in(values, true);
    }

    @NotNull
    public Expression notIn(@NotNull Integer[] operands) {
        long[] values = new long[operands.length];
        for (int i = 0; i < operands.length; ++i) {
            values[i] = operands[i].intValue();
        }
        return this.in(values, true);
    }

    @NotNull
    public Expression notIn(long ... operands) {
        return this.in(operands, true);
    }

    @NotNull
    public Expression notIn(@NotNull Long[] operands) {
        return this.in((Object[])operands, true);
    }

    @NotNull
    public Expression notIn(float ... operands) {
        double[] values = new double[operands.length];
        for (int i = 0; i < operands.length; ++i) {
            values[i] = operands[i];
        }
        return this.in(values, true);
    }

    @NotNull
    public Expression notIn(@NotNull Float[] operands) {
        double[] values = new double[operands.length];
        for (int i = 0; i < operands.length; ++i) {
            values[i] = operands[i].floatValue();
        }
        return this.in(values, true);
    }

    @NotNull
    public Expression notIn(double ... operands) {
        return this.in(operands, true);
    }

    @NotNull
    public Expression notIn(@NotNull Double[] operands) {
        return this.in((Object[])operands, true);
    }

    @NotNull
    public Expression notIn(String ... operands) {
        return this.in(operands, true);
    }

    @NotNull
    public Expression notIn(Value ... operands) {
        return this.in((Object[])operands, true);
    }

    @NotNull
    public <T> Expression notIn(@NotNull Set<T> operands) {
        return this.in(operands.toArray(), true);
    }

    @NotNull
    public <T> Expression notIn(@NotNull List<T> operands) {
        return this.in(operands.toArray(), true);
    }

    @NotNull
    public Expression inTable(@NotNull String table) {
        return this.inTable(table, false);
    }

    @NotNull
    public Expression notInTable(@NotNull String table) {
        return this.inTable(table, true);
    }

    @NotNull
    public Expression inFunction(@NotNull String table) {
        return this.inFunction(table, false);
    }

    @NotNull
    public Expression notInFunction(@NotNull String table) {
        return this.inFunction(table, true);
    }

    @NotNull
    public Expression in(@NotNull StatementSelect select) {
        return this.in(select, false);
    }

    @NotNull
    public Expression notIn(@NotNull StatementSelect select) {
        return this.in(select, true);
    }

    @NotNull
    public Expression collate(@NotNull String collation) {
        return ExpressionOperable.createExpression(ExpressionOperable.collate(Identifier.getCppType(this), CppObject.get(this), collation));
    }

    @NotNull
    public Expression substr(short start, short length) {
        return Expression.function("SUBSTR").argument(this).argument(start).argument(length);
    }

    @NotNull
    public Expression substr(int start, int length) {
        return Expression.function("SUBSTR").argument(this).argument(start).argument(length);
    }

    @NotNull
    public Expression substr(long start, long length) {
        return Expression.function("SUBSTR").argument(this).argument(start).argument(length);
    }

    @NotNull
    public Expression like(@NotNull String content) {
        return this.binaryOperate(content, 20, false);
    }

    @NotNull
    public Expression notLike(@NotNull String content) {
        return this.binaryOperate(content, 20, true);
    }

    @NotNull
    public Expression glob(@NotNull String content) {
        return this.binaryOperate(content, 21, false);
    }

    @NotNull
    public Expression notGlob(@NotNull String content) {
        return this.binaryOperate(content, 21, true);
    }

    @NotNull
    public Expression match(@NotNull String content) {
        return this.binaryOperate(content, 23, false);
    }

    @NotNull
    public Expression notMatch(@NotNull String content) {
        return this.binaryOperate(content, 23, true);
    }

    @NotNull
    public Expression regexp(@NotNull String content) {
        return this.binaryOperate(content, 22, false);
    }

    @NotNull
    public Expression notRegexp(@NotNull String content) {
        return this.binaryOperate(content, 22, true);
    }

    @NotNull
    public Expression is(boolean operand) {
        return this.binaryOperate(operand, 17, false);
    }

    @NotNull
    public Expression is(byte operand) {
        return this.binaryOperate(operand, 17, false);
    }

    @NotNull
    public Expression is(short operand) {
        return this.binaryOperate(operand, 17, false);
    }

    @NotNull
    public Expression is(int operand) {
        return this.binaryOperate(operand, 17, false);
    }

    @NotNull
    public Expression is(long operand) {
        return this.binaryOperate(operand, 17, false);
    }

    @NotNull
    public Expression is(float operand) {
        return this.binaryOperate(operand, 17, false);
    }

    @NotNull
    public Expression is(double operand) {
        return this.binaryOperate(operand, 17, false);
    }

    @NotNull
    public Expression is(@Nullable String operand) {
        return this.binaryOperate(operand, 17, false);
    }

    @NotNull
    public Expression is(@Nullable ExpressionConvertible operand) {
        return this.binaryOperate(operand, 17, false);
    }

    @NotNull
    public Expression isNot(boolean operand) {
        return this.binaryOperate(operand, 17, true);
    }

    @NotNull
    public Expression isNot(byte operand) {
        return this.binaryOperate(operand, 17, true);
    }

    @NotNull
    public Expression isNot(short operand) {
        return this.binaryOperate(operand, 17, true);
    }

    @NotNull
    public Expression isNot(int operand) {
        return this.binaryOperate(operand, 17, true);
    }

    @NotNull
    public Expression isNot(long operand) {
        return this.binaryOperate(operand, 17, true);
    }

    @NotNull
    public Expression isNot(float operand) {
        return this.binaryOperate(operand, 17, true);
    }

    @NotNull
    public Expression isNot(double operand) {
        return this.binaryOperate(operand, 17, true);
    }

    @NotNull
    public Expression isNot(@Nullable String operand) {
        return this.binaryOperate(operand, 17, true);
    }

    @NotNull
    public Expression isNot(@Nullable ExpressionConvertible operand) {
        return this.binaryOperate(operand, 17, true);
    }

    @NotNull
    public Expression avg() {
        return Expression.function("AVG").argument(this);
    }

    @NotNull
    public Expression count() {
        return Expression.function("COUNT").argument(this);
    }

    @NotNull
    public Expression groupConcat() {
        return Expression.function("GROUP_CONCAT").argument(this);
    }

    @NotNull
    public Expression groupConcat(String sperator) {
        return Expression.function("GROUP_CONCAT").argument(this).argument(sperator);
    }

    @NotNull
    public Expression max() {
        return Expression.function("MAX").argument(this);
    }

    @NotNull
    public Expression min() {
        return Expression.function("MIN").argument(this);
    }

    @NotNull
    public Expression sum() {
        return Expression.function("SUM").argument(this);
    }

    @NotNull
    public Expression total() {
        return Expression.function("TOTAL").argument(this);
    }

    @NotNull
    public Expression abs() {
        return Expression.function("ABS").argument(this);
    }

    @NotNull
    public Expression hex() {
        return Expression.function("HEX").argument(this);
    }

    @NotNull
    public Expression length() {
        return Expression.function("LENGTH").argument(this);
    }

    @NotNull
    public Expression lower() {
        return Expression.function("LOWER").argument(this);
    }

    @NotNull
    public Expression upper() {
        return Expression.function("UPPER").argument(this);
    }

    @NotNull
    public Expression round() {
        return Expression.function("ROUND").argument(this);
    }

    @NotNull
    public Expression matchInfo() {
        return Expression.function("matchInfo").argument(this);
    }

    @NotNull
    public Expression offsets() {
        return Expression.function("offsets").argument(this);
    }

    @NotNull
    public Expression snippet() {
        return Expression.function("snippet").argument(this);
    }

    @NotNull
    public Expression bm25() {
        return Expression.function("bm25").argument(this);
    }

    @NotNull
    public Expression highlight() {
        return Expression.function("highlight").argument(this);
    }

    @NotNull
    public Expression substringMatchInfo() {
        return Expression.function("substring_match_info").argument(this);
    }

    protected static Expression createExpression(long cppObj) {
        Expression ret = new Expression();
        ret.cppObj = cppObj;
        return ret;
    }

    private Expression nullOperate(boolean isNot) {
        Expression ret = new Expression();
        ret.cppObj = ExpressionOperable.nullOperate(Identifier.getCppType(this), CppObject.get(this), isNot);
        return ret;
    }

    private static native long nullOperate(int var0, long var1, boolean var3);

    private Expression binaryOperate(ExpressionConvertible operand, int type, boolean isNot) {
        return ExpressionOperable.createExpression(ExpressionOperable.binaryOperate(Identifier.getCppType(this), CppObject.get(this), Identifier.getCppType(operand), CppObject.get(operand), 0.0, null, type, isNot));
    }

    private Expression binaryOperate(boolean operand, int type, boolean isNot) {
        return ExpressionOperable.createExpression(ExpressionOperable.binaryOperate(Identifier.getCppType(this), CppObject.get(this), 2, operand ? 1L : 0L, 0.0, null, type, isNot));
    }

    private Expression binaryOperate(long operand, int type, boolean isNot) {
        return ExpressionOperable.createExpression(ExpressionOperable.binaryOperate(Identifier.getCppType(this), CppObject.get(this), 3, operand, 0.0, null, type, isNot));
    }

    private Expression binaryOperate(double operand, int type, boolean isNot) {
        return ExpressionOperable.createExpression(ExpressionOperable.binaryOperate(Identifier.getCppType(this), CppObject.get(this), 5, 0L, operand, null, type, isNot));
    }

    private Expression binaryOperate(String operand, int type, boolean isNot) {
        return ExpressionOperable.createExpression(ExpressionOperable.binaryOperate(Identifier.getCppType(this), CppObject.get(this), 6, 0L, 0.0, operand, type, isNot));
    }

    private static native long binaryOperate(int var0, long var1, int var3, long var4, double var6, String var8, int var9, boolean var10);

    private static native long betweenOperate(int var0, long var1, int var3, long var4, double var6, String var8, int var9, long var10, double var12, String var14, boolean var15);

    private Expression in(long[] operands, boolean isNot) {
        return ExpressionOperable.createExpression(ExpressionOperable.in(Identifier.getCppType(this), CppObject.get(this), 3, operands, null, null, isNot));
    }

    private Expression in(int type, long[] operands, boolean isNot) {
        return ExpressionOperable.createExpression(ExpressionOperable.in(Identifier.getCppType(this), CppObject.get(this), type, operands, null, null, isNot));
    }

    private Expression in(double[] operands, boolean isNot) {
        return ExpressionOperable.createExpression(ExpressionOperable.in(Identifier.getCppType(this), CppObject.get(this), 5, null, operands, null, isNot));
    }

    private Expression in(String[] operands, boolean isNot) {
        return ExpressionOperable.createExpression(ExpressionOperable.in(Identifier.getCppType(this), CppObject.get(this), 6, null, null, operands, isNot));
    }

    private static native long in(int var0, long var1, int var3, long[] var4, double[] var5, String[] var6, boolean var7);

    private Expression in(Object[] operands, boolean isNot) {
        if (operands == null || operands.length == 0) {
            return this.in((long[])null, isNot);
        }
        int dataType = MultiTypeArray.getObjectType(operands[0]);
        if (dataType == 10) {
            long[] cppObjs = new long[operands.length];
            for (int i = 0; i < operands.length; ++i) {
                cppObjs[i] = CppObject.get((Identifier)operands[i]);
            }
            return this.in(Identifier.getCppType((Identifier)operands[0]), cppObjs, isNot);
        }
        if (dataType == 11) {
            switch (((Value)operands[0]).getType()) {
                case Integer: {
                    long[] intArray = new long[operands.length];
                    for (int i = 0; i < operands.length; ++i) {
                        intArray[i] = ((Value)operands[i]).getLong();
                    }
                    return this.in(intArray, isNot);
                }
                case Float: {
                    double[] doubleArray = new double[operands.length];
                    for (int i = 0; i < operands.length; ++i) {
                        doubleArray[i] = ((Value)operands[i]).getDouble();
                    }
                    return this.in(doubleArray, isNot);
                }
                case Text: {
                    String[] textArray = new String[operands.length];
                    for (int i = 0; i < operands.length; ++i) {
                        textArray[i] = ((Value)operands[i]).getText();
                    }
                    return this.in(textArray, isNot);
                }
            }
            if (operands instanceof String[]) {
                return this.in((String[])operands, isNot);
            }
            String[] stringArray = new String[operands.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = (String)operands[i];
            }
            return this.in(stringArray, isNot);
        }
        if (dataType == 9) {
            if (operands instanceof String[]) {
                return this.in((String[])operands, isNot);
            }
            String[] stringArray = new String[operands.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = (String)operands[i];
            }
            return this.in(stringArray, isNot);
        }
        if (dataType < 7) {
            long[] values = new long[operands.length];
            block19: for (int i = 0; i < operands.length; ++i) {
                switch (dataType) {
                    case 0: {
                        values[i] = 0L;
                        continue block19;
                    }
                    case 1: {
                        values[i] = (Boolean)operands[i] != false ? 1L : 0L;
                        continue block19;
                    }
                    case 2: {
                        values[i] = ((Character)operands[i]).charValue();
                        continue block19;
                    }
                    case 4: {
                        values[i] = ((Short)operands[i]).shortValue();
                        continue block19;
                    }
                    case 5: {
                        values[i] = ((Integer)operands[i]).intValue();
                        continue block19;
                    }
                    case 6: {
                        values[i] = (Long)operands[i];
                    }
                }
            }
            return this.in(values, isNot);
        }
        if (dataType != 12) {
            double[] values = new double[operands.length];
            for (int i = 0; i < operands.length; ++i) {
                values[i] = dataType == 7 ? (double)((Float)operands[i]).floatValue() : (Double)operands[i];
            }
            return this.in(values, isNot);
        }
        return this.in((long[])null);
    }

    private Expression inTable(String table, boolean isNot) {
        return ExpressionOperable.createExpression(ExpressionOperable.inTable(Identifier.getCppType(this), CppObject.get(this), table, isNot));
    }

    private static native long inTable(int var0, long var1, String var3, boolean var4);

    private Expression inFunction(String func, boolean isNot) {
        return ExpressionOperable.createExpression(ExpressionOperable.inFunction(Identifier.getCppType(this), CppObject.get(this), func, isNot));
    }

    private static native long inFunction(int var0, long var1, String var3, boolean var4);

    private Expression in(StatementSelect select, boolean isNot) {
        return ExpressionOperable.createExpression(ExpressionOperable.inSelect(Identifier.getCppType(this), CppObject.get(this), CppObject.get(select), isNot));
    }

    private static native long inSelect(int var0, long var1, long var3, boolean var5);

    private static native long collate(int var0, long var1, String var3);

    private static class BinaryOperatorType {
        static final int Concatenate = 1;
        static final int Multiply = 2;
        static final int Divide = 3;
        static final int Modulo = 4;
        static final int Plus = 5;
        static final int Minus = 6;
        static final int LeftShift = 7;
        static final int RightShift = 8;
        static final int BitwiseAnd = 9;
        static final int BitwiseOr = 10;
        static final int Less = 11;
        static final int LessOrEqual = 12;
        static final int Greater = 13;
        static final int GreaterOrEqual = 14;
        static final int Equal = 15;
        static final int NotEqual = 16;
        static final int Is = 17;
        static final int And = 18;
        static final int Or = 19;
        static final int Like = 20;
        static final int GLOB = 21;
        static final int RegExp = 22;
        static final int Match = 23;

        private BinaryOperatorType() {
        }
    }
}

