/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloudapi.cls.android.producer.common;

import com.tencentcloudapi.cls.android.CLSLog;
import com.tencentcloudapi.cls.android.producer.common.LogThread;
import com.tencentcloudapi.cls.android.producer.common.ProducerBatch;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;

public class BatchHandler
extends LogThread {
    private final BlockingQueue<ProducerBatch> batches;
    private final AtomicInteger batchCount;
    private final Semaphore memoryController;
    private volatile boolean closed;

    public BatchHandler(String name, boolean daemon, BlockingQueue<ProducerBatch> batches, AtomicInteger batchCount, Semaphore memoryController) {
        super(name, daemon);
        this.batches = batches;
        this.batchCount = batchCount;
        this.memoryController = memoryController;
        this.closed = false;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() {
        this.closed = true;
        this.interrupt();
    }

    @Override
    public void run() {
        this.loopHandleBatches();
        this.handleRemainingBatches();
    }

    private void loopHandleBatches() {
        while (!this.closed) {
            try {
                ProducerBatch b = this.batches.take();
                this.handle(b);
            }
            catch (InterruptedException e) {
                CLSLog.w("producer", "The batch handler has been interrupted");
            }
        }
    }

    private void handleRemainingBatches() {
        ArrayList remainingBatches = new ArrayList();
        this.batches.drainTo(remainingBatches);
        for (ProducerBatch b : remainingBatches) {
            this.handle(b);
        }
    }

    private void handle(ProducerBatch batch) {
        try {
            batch.fireCallbacksAndSetFutures();
        }
        catch (Throwable t) {
            CLSLog.e("producer", CLSLog.format("Failed to handle batch, e=%s", new Object[]{t.getMessage()}));
        }
        finally {
            this.batchCount.decrementAndGet();
            this.memoryController.release(batch.getCurBatchSizeInBytes());
        }
    }
}

