/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloudapi.cls.android.producer.common;

import com.tencentcloudapi.cls.android.producer.AsyncProducerConfig;
import com.tencentcloudapi.cls.android.producer.common.LogException;
import com.tencentcloudapi.cls.android.producer.http.client.Sender;
import com.tencentcloudapi.cls.android.producer.http.comm.HttpMethod;
import com.tencentcloudapi.cls.android.producer.request.SearchLogRequest;
import com.tencentcloudapi.cls.android.producer.response.SearchLogResponse;
import com.tencentcloudapi.cls.android.producer.util.QcloudClsSignature;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;

public class LogSearch {
    public static SearchLogResponse searchLogs(AsyncProducerConfig producerConfig, SearchLogRequest request) throws LogException {
        SearchLogResponse response;
        String signature;
        HashMap<String, String> headParameter = new HashMap<String, String>(2);
        headParameter.put("Content-Type", "application/json");
        headParameter.put("Host", producerConfig.getHostName());
        try {
            signature = QcloudClsSignature.buildSignature(producerConfig.getSecretId(), producerConfig.getSecretKey(), HttpMethod.GET.toString(), "/searchlog", new HashMap<String, String>(0), headParameter, 300000L);
        }
        catch (UnsupportedEncodingException e) {
            throw new LogException("EncodingException", e.getMessage());
        }
        headParameter.put("Authorization", signature);
        if (!producerConfig.getSecretToken().isEmpty()) {
            headParameter.put("X-Cls-Token", producerConfig.getSecretToken());
        }
        headParameter.put("android-sdk-version", "1.0.5");
        String endPointUrl = producerConfig.getHttpType() + producerConfig.getHostName() + "/searchlog";
        try {
            response = Sender.doGet(request, endPointUrl, headParameter);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new LogException("SendFailed", e.getMessage());
        }
        return response;
    }
}

