/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloudapi.cls.android.producer.common;

import com.tencentcloudapi.cls.android.CLSLog;
import com.tencentcloudapi.cls.android.producer.AsyncProducerConfig;
import com.tencentcloudapi.cls.android.producer.common.ExpiredBatches;
import com.tencentcloudapi.cls.android.producer.common.LogAccumulator;
import com.tencentcloudapi.cls.android.producer.common.LogThread;
import com.tencentcloudapi.cls.android.producer.common.ProducerBatch;
import com.tencentcloudapi.cls.android.producer.common.RetryQueue;
import com.tencentcloudapi.cls.android.producer.common.SendProducerBatchTask;
import com.tencentcloudapi.cls.android.producer.common.SendThreadPool;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class TimerSendBatchTask
extends LogThread {
    private final AsyncProducerConfig producerConfig;
    private final LogAccumulator accumulator;
    private final RetryQueue retryQueue;
    private final BlockingQueue<ProducerBatch> successQueue;
    private final BlockingQueue<ProducerBatch> failureQueue;
    private final SendThreadPool sendThreadPool;
    private final AtomicInteger batchCount;
    private volatile boolean closed;

    public TimerSendBatchTask(String name, boolean daemon, AsyncProducerConfig producerConfig, LogAccumulator accumulator, RetryQueue retryQueue, BlockingQueue<ProducerBatch> successQueue, BlockingQueue<ProducerBatch> failureQueue, SendThreadPool sendThreadPool, AtomicInteger batchCount) {
        super(name, daemon);
        this.producerConfig = producerConfig;
        this.accumulator = accumulator;
        this.retryQueue = retryQueue;
        this.successQueue = successQueue;
        this.failureQueue = failureQueue;
        this.sendThreadPool = sendThreadPool;
        this.batchCount = batchCount;
        this.closed = false;
    }

    public void close() {
        this.closed = true;
        this.interrupt();
    }

    @Override
    public void run() {
        this.loopCheckSendBatches();
        List<ProducerBatch> incompleteBatches = this.incompleteBatches();
        this.submitIncompleteBatches(incompleteBatches);
    }

    private void loopCheckSendBatches() {
        while (!this.closed) {
            try {
                this.doSendBatches();
            }
            catch (Exception e) {
                CLSLog.e("producer", CLSLog.format("Uncaught exception in timer batch send task, e=%s", new Object[]{e.getMessage()}));
            }
        }
    }

    private void doSendBatches() {
        ExpiredBatches expiredBatches = this.accumulator.expiredBatches();
        for (ProducerBatch b : expiredBatches.getBatches()) {
            this.sendThreadPool.submit(this.createSendProducerBatchTask(b));
        }
        List<ProducerBatch> expiredRetryBatches = this.retryQueue.expiredBatches(expiredBatches.getRemainingMs());
        for (ProducerBatch b : expiredRetryBatches) {
            this.sendThreadPool.submit(this.createSendProducerBatchTask(b));
        }
    }

    private SendProducerBatchTask createSendProducerBatchTask(ProducerBatch batch) {
        return new SendProducerBatchTask(batch, this.producerConfig, this.retryQueue, this.successQueue, this.failureQueue, this.batchCount);
    }

    private List<ProducerBatch> incompleteBatches() {
        List<ProducerBatch> incompleteBatches = this.accumulator.remainingBatches();
        incompleteBatches.addAll(this.retryQueue.remainingBatches());
        return incompleteBatches;
    }

    private void submitIncompleteBatches(List<ProducerBatch> incompleteBatches) {
        for (ProducerBatch b : incompleteBatches) {
            this.sendThreadPool.submit(this.createSendProducerBatchTask(b));
        }
    }
}

