/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloudapi.cls.android.producer.http.client;

import com.tencentcloudapi.cls.android.producer.common.Constants;
import com.tencentcloudapi.cls.android.producer.http.comm.RequestMessage;
import com.tencentcloudapi.cls.android.producer.http.utils.HttpUtil;
import com.tencentcloudapi.cls.android.producer.request.SearchLogRequest;
import com.tencentcloudapi.cls.android.producer.response.PutLogsResponse;
import com.tencentcloudapi.cls.android.producer.response.SearchLogResponse;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Sender {
    public static SearchLogResponse doGet(SearchLogRequest request, String httpUrl, Map<String, String> headers) throws Exception {
        String result = null;
        HttpURLConnection httpURLConnection = null;
        InputStream is = null;
        BufferedReader br = null;
        Set<String> keySet = request.GetAllParams().keySet();
        Iterator<String> iterator = keySet.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            String key = iterator.next();
            String value = request.GetAllParams().get(key);
            if (stringBuffer.toString().equals("")) {
                stringBuffer.append("?");
            } else {
                stringBuffer.append("&");
            }
            stringBuffer.append(key);
            stringBuffer.append("=");
            stringBuffer.append((Object)value);
        }
        httpUrl = httpUrl + stringBuffer.toString();
        URL url = new URL(httpUrl);
        httpURLConnection = (HttpURLConnection)url.openConnection();
        httpURLConnection.setRequestMethod("GET");
        for (Map.Entry entry : headers.entrySet()) {
            httpURLConnection.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
        }
        httpURLConnection.connect();
        if (httpURLConnection.getResponseCode() == 200) {
            String string;
            is = httpURLConnection.getInputStream();
            br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            StringBuffer resBuffer = new StringBuffer();
            Object var12_13 = null;
            while ((string = br.readLine()) != null) {
                resBuffer.append(string);
                resBuffer.append("\r\n");
            }
            result = resBuffer.toString();
        }
        if (br != null) {
            br.close();
        }
        if (is != null) {
            is.close();
        }
        SearchLogResponse resp = new SearchLogResponse(httpURLConnection.getHeaderFields());
        resp.SetHttpStatusCode(httpURLConnection.getResponseCode());
        resp.SetResult(result);
        httpURLConnection.disconnect();
        return resp;
    }

    public static PutLogsResponse doPost(RequestMessage requestMessage) throws Exception {
        URL url = new URL(Sender.buildUri(requestMessage));
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod(requestMessage.getMethod().toString());
        connection.setConnectTimeout(Constants.HTTP_CONNECT_TIME_OUT);
        connection.setReadTimeout(Constants.HTTP_SEND_TIME_OUT);
        connection.setDoOutput(true);
        connection.setDoInput(true);
        for (Map.Entry<String, String> entry : requestMessage.getHeaders().entrySet()) {
            connection.setRequestProperty(entry.getKey(), entry.getValue());
        }
        OutputStream outputStream = connection.getOutputStream();
        outputStream.write(requestMessage.getContent());
        PutLogsResponse resp = new PutLogsResponse(connection.getHeaderFields());
        resp.SetHttpStatusCode(connection.getResponseCode());
        outputStream.close();
        return resp;
    }

    private static String buildUri(RequestMessage requestMessage) {
        String paramString;
        String delimiter = "/";
        String uri = requestMessage.getEndpoint().toString();
        if (!(uri.endsWith("/") || requestMessage.getResourcePath() != null && requestMessage.getResourcePath().startsWith("/"))) {
            uri = uri + "/";
        }
        if (requestMessage.getResourcePath() != null) {
            uri = uri + requestMessage.getResourcePath();
        }
        if ((paramString = HttpUtil.paramToQueryString(requestMessage.getParameters(), "UTF-8")) != null) {
            uri = uri + "?" + paramString;
        }
        return uri;
    }
}

