/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloudapi.cls.android.producer.util;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import com.tencentcloudapi.cls.android.producer.util.NetworkUtils;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public final class Utils {
    private Utils() {
    }

    public static long dateToTimestamp(Date date) {
        return date.getTime() / 1000L;
    }

    public static Date timestampToDate(long timestamp) {
        return new Date(timestamp * 1000L);
    }

    public static String getOrEmpty(Map<String, String> map, String key) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        return "";
    }

    public static String safeToString(Object object) {
        return object == null ? null : object.toString();
    }

    private static long parseLongWithoutSuffix(String s) {
        return Long.parseLong(s.substring(0, s.length() - 1).trim());
    }

    public static long parseDuration(String s) {
        if (s == null || s.isEmpty()) {
            throw new IllegalArgumentException("Duration could not be empty: " + s);
        }
        if (s.endsWith("s")) {
            return Utils.parseLongWithoutSuffix(s);
        }
        if (s.endsWith("m")) {
            return 60L * Utils.parseLongWithoutSuffix(s);
        }
        if (s.endsWith("h")) {
            return 3600L * Utils.parseLongWithoutSuffix(s);
        }
        if (s.endsWith("d")) {
            return 86400L * Utils.parseLongWithoutSuffix(s);
        }
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException ex) {
            throw new NumberFormatException("'" + s + "' is not a valid duration. Should be numeric value followed by a unit, i.e. 20s. Valid units are s, m, h and d.");
        }
    }

    public static String generateProducerHash(int instanceId) {
        String ip = NetworkUtils.getLocalMachineIP();
        if (ip == null) {
            ip = "127.0.0.1";
        }
        String name = "cls-producer" + String.valueOf(new Date().getTime());
        String input = ip + "-" + name + "-" + instanceId;
        return Hashing.farmHashFingerprint64().hashString((CharSequence)input, Charsets.US_ASCII).toString();
    }

    public static String generatePackageId(String producerHash, AtomicLong batchId) {
        return (producerHash + "-" + Long.toHexString(batchId.getAndIncrement())).toUpperCase();
    }

    public static void assertParameterNotNull(Object param, String paramName) {
        if (param == null) {
            throw new NullPointerException(paramName + " is null");
        }
    }

    public static void assertStringNotNullOrEmpty(String param, String paramName) {
        Utils.assertParameterNotNull(param, paramName);
        if (param.isEmpty()) {
            throw new IllegalArgumentException(paramName + " is empty");
        }
    }
}

