/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloudapi.cls.android.scheme;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import com.tencentcloudapi.cls.android.CLSConfig;
import com.tencentcloudapi.cls.android.scheme.AppUtils;
import com.tencentcloudapi.cls.android.scheme.DeviceUtils;
import com.tencentcloudapi.cls.android.scheme.RootUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public class Scheme {
    public String app_id;
    public String app_name;
    public String app_version;
    public String sdk_version;
    public String sdk_type;
    public String channel;
    public String channel_name;
    public String user_nick;
    public String user_id;
    public String long_login_nick;
    public String long_login_user_id;
    public String logon_type;
    public String utdid;
    public String imei;
    public String imsi;
    public String imeisi;
    public String idfa;
    public String brand;
    public String device_model;
    public String resolution;
    public String os;
    public String os_version;
    public String carrier;
    public String access;
    public String access_subtype;
    public String network_type;
    public String school;
    public String root;
    public String reserve1;
    public String reserve2;
    public String reserve3;
    public String reserve4;
    public String reserve5;
    public String reserve6;
    public String reserves;
    public String local_time;
    public String local_timestamp;
    public String local_time_fixed;
    public String local_timestamp_fixed;
    public String reach_time;
    public String reach_time_stamp;
    public String page;
    public String event_id;
    public String event_type;
    public String arg1;
    public String arg2;
    public String arg3;
    public String args;
    public String is_active;
    public String start_count;
    public String run_time;
    public String active_uvmid;
    public String active_user_nick;
    public String page_stay_time;
    public String client_ip;
    public String country;
    public String province;
    public String city;
    public String district;
    public Map<String, String> ext;

    public Map<String, String> toMap() {
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        Scheme.putIfNotNull(fields, "app_id", this.app_id);
        Scheme.putIfNotNull(fields, "app_name", this.app_name);
        Scheme.putIfNotNull(fields, "app_version", this.app_version);
        Scheme.putIfNotNull(fields, "sdk_version", this.sdk_version);
        Scheme.putIfNotNull(fields, "sdk_type", this.sdk_type);
        Scheme.putIfNotNull(fields, "channel", this.channel);
        Scheme.putIfNotNull(fields, "channel_name", this.channel_name);
        Scheme.putIfNotNull(fields, "user_nick", this.user_nick);
        Scheme.putIfNotNull(fields, "long_login_nick", this.long_login_nick);
        Scheme.putIfNotNull(fields, "logon_type", this.logon_type);
        Scheme.putIfNotNull(fields, "user_id", this.user_id);
        Scheme.putIfNotNull(fields, "long_login_user_id", this.long_login_user_id);
        Scheme.putIfNotNull(fields, "utdid", this.utdid);
        Scheme.putIfNotNull(fields, "imei", this.imei);
        Scheme.putIfNotNull(fields, "imsi", this.imsi);
        Scheme.putIfNotNull(fields, "imeisi", this.imeisi);
        Scheme.putIfNotNull(fields, "idfa", this.idfa);
        Scheme.putIfNotNull(fields, "brand", this.brand);
        Scheme.putIfNotNull(fields, "device_model", this.device_model);
        Scheme.putIfNotNull(fields, "resolution", this.resolution);
        Scheme.putIfNotNull(fields, "os", this.os);
        Scheme.putIfNotNull(fields, "os_version", this.os_version);
        Scheme.putIfNotNull(fields, "carrier", this.carrier);
        Scheme.putIfNotNull(fields, "access", this.access);
        Scheme.putIfNotNull(fields, "access_subtype", this.access_subtype);
        Scheme.putIfNotNull(fields, "network_type", this.network_type);
        Scheme.putIfNotNull(fields, "school", this.school);
        Scheme.putIfNotNull(fields, "root", this.root);
        Scheme.putIfNotNull(fields, "reserve1", this.reserve1);
        Scheme.putIfNotNull(fields, "reserve2", this.reserve2);
        Scheme.putIfNotNull(fields, "reserve3", this.reserve3);
        Scheme.putIfNotNull(fields, "reserve4", this.reserve4);
        Scheme.putIfNotNull(fields, "reserve5", this.reserve5);
        Scheme.putIfNotNull(fields, "reserve6", this.reserve6);
        Scheme.putIfNotNull(fields, "reserves", this.reserves);
        Scheme.putIfNotNull(fields, "local_time", this.local_time);
        Scheme.putIfNotNull(fields, "local_timestamp", this.local_timestamp);
        Scheme.putIfNotNull(fields, "local_time_fixed", this.local_time_fixed);
        Scheme.putIfNotNull(fields, "local_timestamp_fixed", this.local_timestamp_fixed);
        Scheme.putIfNotNull(fields, "reach_time", this.reach_time);
        Scheme.putIfNotNull(fields, "reach_time_stamp", this.reach_time_stamp);
        Scheme.putIfNotNull(fields, "page", this.page);
        Scheme.putIfNotNull(fields, "event_id", this.event_id);
        Scheme.putIfNotNull(fields, "event_type", this.event_type);
        Scheme.putIfNotNull(fields, "arg1", this.arg1);
        Scheme.putIfNotNull(fields, "arg2", this.arg2);
        Scheme.putIfNotNull(fields, "arg3", this.arg3);
        Scheme.putIfNotNull(fields, "args", this.args);
        Scheme.putIfNotNull(fields, "is_active", this.is_active);
        Scheme.putIfNotNull(fields, "start_count", this.start_count);
        Scheme.putIfNotNull(fields, "run_time", this.run_time);
        Scheme.putIfNotNull(fields, "active_uvmid", this.active_uvmid);
        Scheme.putIfNotNull(fields, "active_user_nick", this.active_user_nick);
        Scheme.putIfNotNull(fields, "page_stay_time", this.page_stay_time);
        Scheme.putIfNotNull(fields, "client_ip", this.client_ip);
        Scheme.putIfNotNull(fields, "country", this.country);
        Scheme.putIfNotNull(fields, "province", this.country);
        Scheme.putIfNotNull(fields, "city", this.city);
        Scheme.putIfNotNull(fields, "district", this.district);
        if (null != this.ext && !this.ext.isEmpty()) {
            for (Map.Entry<String, String> entry : this.ext.entrySet()) {
                Scheme.put(fields, entry.getKey(), entry.getValue());
            }
        }
        return fields;
    }

    public static String returnDashIfNull(String value) {
        if (TextUtils.isEmpty((CharSequence)value)) {
            return "-";
        }
        return value;
    }

    private static void putIfNotNull(Map<String, String> maps, String key, String value) {
        if (TextUtils.isEmpty((CharSequence)value)) {
            return;
        }
        maps.put(key, value);
    }

    private static void putWithDashIfNull(Map<String, String> maps, String key, String value) {
        maps.put(key, Scheme.returnDashIfNull(value));
    }

    private static void put(Map<String, String> maps, String key, String value) {
        if (null == key) {
            key = "null";
        }
        if (null == value) {
            value = "null";
        }
        maps.put(key, value);
    }

    public static Scheme createDefaultScheme(Context context) {
        Scheme scheme = new Scheme();
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS", Locale.getDefault());
        scheme.local_timestamp = String.valueOf(date.getTime());
        scheme.local_time = dateFormat.format(date);
        scheme.app_name = Scheme.returnDashIfNull(AppUtils.getAppName(context));
        scheme.app_version = Scheme.returnDashIfNull(AppUtils.getAppVersion(context));
        scheme.utdid = Scheme.returnDashIfNull(DeviceUtils.getUtdid(context));
        scheme.imei = Scheme.returnDashIfNull(DeviceUtils.getImei(context));
        scheme.imsi = Scheme.returnDashIfNull(DeviceUtils.getImsi(context));
        scheme.brand = Scheme.returnDashIfNull(Build.BRAND);
        scheme.device_model = Scheme.returnDashIfNull(Build.MODEL);
        scheme.os = "Android";
        scheme.os_version = Scheme.returnDashIfNull(Build.VERSION.RELEASE);
        scheme.carrier = Scheme.returnDashIfNull(DeviceUtils.getCarrier(context));
        scheme.access = Scheme.returnDashIfNull(DeviceUtils.getAccessName(context));
        scheme.access_subtype = Scheme.returnDashIfNull(DeviceUtils.getAccessSubTypeName(context));
        scheme.root = Scheme.returnDashIfNull(RootUtil.isDeviceRooted() + "");
        scheme.resolution = Scheme.returnDashIfNull(DeviceUtils.getResolution(context));
        return scheme;
    }

    public static Scheme createDefaultScheme(CLSConfig config) {
        Scheme scheme = Scheme.createDefaultScheme(config.context);
        scheme.app_id = String.format("%s@Android", config.pluginAppId);
        scheme.channel = Scheme.returnDashIfNull(config.channel);
        scheme.channel_name = Scheme.returnDashIfNull(config.channelName);
        scheme.user_nick = Scheme.returnDashIfNull(config.userNick);
        scheme.long_login_nick = Scheme.returnDashIfNull(config.longLoginNick);
        scheme.user_id = Scheme.returnDashIfNull(config.userId);
        scheme.long_login_user_id = Scheme.returnDashIfNull(config.longLoginUserId);
        scheme.logon_type = Scheme.returnDashIfNull(config.loginType);
        scheme.ext = config.getExt();
        return scheme;
    }
}

