/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloudapi.cls.android.utdid;

import android.content.Context;
import android.text.TextUtils;
import android.util.Base64;
import com.tencentcloudapi.cls.android.utdid.Generator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.UUID;

public final class Utdid {
    private Utdid() {
    }

    public static Utdid getInstance() {
        return Holder.INSTANCE;
    }

    public static String getImei(Context context) {
        return Generator.getImei(context);
    }

    public static String getImsi(Context context) {
        return Generator.getImsi(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getUtdid(Context context) {
        String utdid = Storage.getInstance().getUtdid(context);
        if (!TextUtils.isEmpty((CharSequence)utdid)) {
            return utdid;
        }
        try {
            Lock.lock(context);
            utdid = UUID.randomUUID().toString();
            String[] parts = utdid.split("-");
            utdid = parts[0] + parts[1] + parts[2];
            utdid = Base64.encodeToString((byte[])utdid.getBytes("UTF-8"), (int)0);
            Storage.getInstance().setUtdid(context, utdid);
        }
        catch (Throwable t) {
            utdid = "ffffffffffffffffffffffff";
        }
        finally {
            Lock.unlock();
        }
        return utdid;
    }

    private static class Lock {
        private static File lockFile = null;
        private static FileChannel channel = null;
        private static FileLock lock = null;

        private Lock() {
        }

        static synchronized void lock(Context context) {
            if (null == lockFile) {
                lockFile = Storage.getInstance().getFile(context);
            }
            if (!lockFile.exists()) {
                try {
                    lockFile.createNewFile();
                }
                catch (IOException e) {
                    return;
                }
            }
            if (null == channel) {
                try {
                    channel = new RandomAccessFile(lockFile, "rw").getChannel();
                }
                catch (FileNotFoundException e) {
                    return;
                }
            }
            try {
                lock = channel.lock();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        static synchronized void unlock() {
            if (null != lock) {
                try {
                    lock.release();
                }
                catch (IOException iOException) {
                }
                finally {
                    lock = null;
                }
            }
            if (null != channel) {
                try {
                    channel.close();
                }
                catch (IOException iOException) {
                }
                finally {
                    channel = null;
                }
            }
        }
    }

    private static class Storage {
        final String FILE_PATH = "/cls_android/files";

        private Storage() {
        }

        static Storage getInstance() {
            return Holder.INSTANCE;
        }

        void setUtdid(Context context, String utdid) {
            File file = this.getFile(context);
            try {
                FileOutputStream fos = new FileOutputStream(file);
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                writer.write(utdid);
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        String getUtdid(Context context) {
            File file = this.getFile(context);
            if (!file.exists()) {
                return "";
            }
            try {
                FileInputStream fis = new FileInputStream(file);
                BufferedReader reader = new BufferedReader(new InputStreamReader(fis));
                String line = reader.readLine();
                reader.close();
                line = this.validUtdid(line);
                return line;
            }
            catch (IOException e) {
                e.printStackTrace();
                return "";
            }
        }

        private String validUtdid(String utidid) {
            if (TextUtils.isEmpty((CharSequence)utidid)) {
                return "ffffffffffffffffffffffff";
            }
            if (utidid.endsWith("\n")) {
                return utidid.substring(0, utidid.length() - 1);
            }
            return utidid;
        }

        File getFile(Context context) {
            File file = context.getFilesDir();
            if (!(file = new File(file, "/cls_android/files")).exists()) {
                file.mkdirs();
            }
            return new File(file, "unique");
        }

        private static class Holder {
            static final Storage INSTANCE = new Storage();

            private Holder() {
            }
        }
    }

    private static class Holder {
        static final Utdid INSTANCE = new Utdid();

        private Holder() {
        }
    }
}

