/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.advisor.v20200721.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeTaskStrategyRisksResponse extends AbstractModel {

    /**
    * According to this configuration, match the corresponding fields of the risky instance list (Risks), for example:
{"Response":{"RequestId":"111","RiskFieldsDesc":[{"Field":"InstanceId","FieldName":"ID","FieldType":"string","FieldDict":{} },{"Field":"InstanceName","FieldName":"Name","FieldType":"string","FieldDict":{}},{"Field":"InstanceState","FieldName":"Status ","FieldType":"string","FieldDict":{"LAUNCH_FAILED":"Creation failed","PENDING":"Creating","REBOOTING":"Re- starting","RUNNING":"Running","SHUTDOWN":"Stop waiting to be terminated","STARTING":"Starting","STOPPED":"Shut down","STOPPING":"Shutting down"," TERMINATING":"Terminating"}},{"Field":"Zone","FieldName":"Available zone","FieldType":"string","FieldDict":{}},{"Field":" PrivateIPAddresses","FieldName":"Private IP addresses","FieldType":"stringSlice","FieldDict":{}},{"Field":"PublicIPAddresses","FieldName":"Public IP addresses","Field Type":"stringSlice","FieldDict":{}},{"Field":"Region","FieldName":"Region","FieldType":"string","FieldDict":{}},{" Field":"Tags","FieldName":"Tags","FieldType":"tags","FieldDict":{}}],"RiskTotalCount":3,"Risks":"[{\"InstanceId\" :\"ins-xxx1\",\"InstanceName\":\"xxx1\",\"InstanceState\":\"RUNNING\",\"PrivateIPAddresses\":[\"1.17.64.2\"],\ " PublicIPAddresses\":null,\"Region\":\"ap-shanghai\",\"Tags\":null,\"Zone\":\"ap-shanghai-2\"},{\"InstanceId\ ":\"ins-xxx2\",\"InstanceName\":\"xxx2\",\"InstanceState\":\"RUNNING\",\"PrivateIPAddresses\":[\"1.17.64.11\"], \"PublicIPAddresses\":null,\"Region\":\"ap-shanghai\",\"Tags\":null,\"Zone\":\"ap-shanghai-2\"}]"," StrategyId":9}}
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("RiskFieldsDesc")
    @Expose
    private RiskFieldsDesc [] RiskFieldsDesc;

    /**
    * Assessment item ID
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("StrategyId")
    @Expose
    private Long StrategyId;

    /**
    * Number of risky instances
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("RiskTotalCount")
    @Expose
    private Long RiskTotalCount;

    /**
    * Risky instance details list. Require json decode.
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("Risks")
    @Expose
    private String Risks;

    /**
    * Number of inspection resources
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("ResourceCount")
    @Expose
    private Long ResourceCount;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get According to this configuration, match the corresponding fields of the risky instance list (Risks), for example:
{"Response":{"RequestId":"111","RiskFieldsDesc":[{"Field":"InstanceId","FieldName":"ID","FieldType":"string","FieldDict":{} },{"Field":"InstanceName","FieldName":"Name","FieldType":"string","FieldDict":{}},{"Field":"InstanceState","FieldName":"Status ","FieldType":"string","FieldDict":{"LAUNCH_FAILED":"Creation failed","PENDING":"Creating","REBOOTING":"Re- starting","RUNNING":"Running","SHUTDOWN":"Stop waiting to be terminated","STARTING":"Starting","STOPPED":"Shut down","STOPPING":"Shutting down"," TERMINATING":"Terminating"}},{"Field":"Zone","FieldName":"Available zone","FieldType":"string","FieldDict":{}},{"Field":" PrivateIPAddresses","FieldName":"Private IP addresses","FieldType":"stringSlice","FieldDict":{}},{"Field":"PublicIPAddresses","FieldName":"Public IP addresses","Field Type":"stringSlice","FieldDict":{}},{"Field":"Region","FieldName":"Region","FieldType":"string","FieldDict":{}},{" Field":"Tags","FieldName":"Tags","FieldType":"tags","FieldDict":{}}],"RiskTotalCount":3,"Risks":"[{\"InstanceId\" :\"ins-xxx1\",\"InstanceName\":\"xxx1\",\"InstanceState\":\"RUNNING\",\"PrivateIPAddresses\":[\"1.17.64.2\"],\ " PublicIPAddresses\":null,\"Region\":\"ap-shanghai\",\"Tags\":null,\"Zone\":\"ap-shanghai-2\"},{\"InstanceId\ ":\"ins-xxx2\",\"InstanceName\":\"xxx2\",\"InstanceState\":\"RUNNING\",\"PrivateIPAddresses\":[\"1.17.64.11\"], \"PublicIPAddresses\":null,\"Region\":\"ap-shanghai\",\"Tags\":null,\"Zone\":\"ap-shanghai-2\"}]"," StrategyId":9}}
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return RiskFieldsDesc According to this configuration, match the corresponding fields of the risky instance list (Risks), for example:
{"Response":{"RequestId":"111","RiskFieldsDesc":[{"Field":"InstanceId","FieldName":"ID","FieldType":"string","FieldDict":{} },{"Field":"InstanceName","FieldName":"Name","FieldType":"string","FieldDict":{}},{"Field":"InstanceState","FieldName":"Status ","FieldType":"string","FieldDict":{"LAUNCH_FAILED":"Creation failed","PENDING":"Creating","REBOOTING":"Re- starting","RUNNING":"Running","SHUTDOWN":"Stop waiting to be terminated","STARTING":"Starting","STOPPED":"Shut down","STOPPING":"Shutting down"," TERMINATING":"Terminating"}},{"Field":"Zone","FieldName":"Available zone","FieldType":"string","FieldDict":{}},{"Field":" PrivateIPAddresses","FieldName":"Private IP addresses","FieldType":"stringSlice","FieldDict":{}},{"Field":"PublicIPAddresses","FieldName":"Public IP addresses","Field Type":"stringSlice","FieldDict":{}},{"Field":"Region","FieldName":"Region","FieldType":"string","FieldDict":{}},{" Field":"Tags","FieldName":"Tags","FieldType":"tags","FieldDict":{}}],"RiskTotalCount":3,"Risks":"[{\"InstanceId\" :\"ins-xxx1\",\"InstanceName\":\"xxx1\",\"InstanceState\":\"RUNNING\",\"PrivateIPAddresses\":[\"1.17.64.2\"],\ " PublicIPAddresses\":null,\"Region\":\"ap-shanghai\",\"Tags\":null,\"Zone\":\"ap-shanghai-2\"},{\"InstanceId\ ":\"ins-xxx2\",\"InstanceName\":\"xxx2\",\"InstanceState\":\"RUNNING\",\"PrivateIPAddresses\":[\"1.17.64.11\"], \"PublicIPAddresses\":null,\"Region\":\"ap-shanghai\",\"Tags\":null,\"Zone\":\"ap-shanghai-2\"}]"," StrategyId":9}}
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public RiskFieldsDesc [] getRiskFieldsDesc() {
        return this.RiskFieldsDesc;
    }

    /**
     * Set According to this configuration, match the corresponding fields of the risky instance list (Risks), for example:
{"Response":{"RequestId":"111","RiskFieldsDesc":[{"Field":"InstanceId","FieldName":"ID","FieldType":"string","FieldDict":{} },{"Field":"InstanceName","FieldName":"Name","FieldType":"string","FieldDict":{}},{"Field":"InstanceState","FieldName":"Status ","FieldType":"string","FieldDict":{"LAUNCH_FAILED":"Creation failed","PENDING":"Creating","REBOOTING":"Re- starting","RUNNING":"Running","SHUTDOWN":"Stop waiting to be terminated","STARTING":"Starting","STOPPED":"Shut down","STOPPING":"Shutting down"," TERMINATING":"Terminating"}},{"Field":"Zone","FieldName":"Available zone","FieldType":"string","FieldDict":{}},{"Field":" PrivateIPAddresses","FieldName":"Private IP addresses","FieldType":"stringSlice","FieldDict":{}},{"Field":"PublicIPAddresses","FieldName":"Public IP addresses","Field Type":"stringSlice","FieldDict":{}},{"Field":"Region","FieldName":"Region","FieldType":"string","FieldDict":{}},{" Field":"Tags","FieldName":"Tags","FieldType":"tags","FieldDict":{}}],"RiskTotalCount":3,"Risks":"[{\"InstanceId\" :\"ins-xxx1\",\"InstanceName\":\"xxx1\",\"InstanceState\":\"RUNNING\",\"PrivateIPAddresses\":[\"1.17.64.2\"],\ " PublicIPAddresses\":null,\"Region\":\"ap-shanghai\",\"Tags\":null,\"Zone\":\"ap-shanghai-2\"},{\"InstanceId\ ":\"ins-xxx2\",\"InstanceName\":\"xxx2\",\"InstanceState\":\"RUNNING\",\"PrivateIPAddresses\":[\"1.17.64.11\"], \"PublicIPAddresses\":null,\"Region\":\"ap-shanghai\",\"Tags\":null,\"Zone\":\"ap-shanghai-2\"}]"," StrategyId":9}}
Note: This field may return null, indicating that no valid values can be obtained.
     * @param RiskFieldsDesc According to this configuration, match the corresponding fields of the risky instance list (Risks), for example:
{"Response":{"RequestId":"111","RiskFieldsDesc":[{"Field":"InstanceId","FieldName":"ID","FieldType":"string","FieldDict":{} },{"Field":"InstanceName","FieldName":"Name","FieldType":"string","FieldDict":{}},{"Field":"InstanceState","FieldName":"Status ","FieldType":"string","FieldDict":{"LAUNCH_FAILED":"Creation failed","PENDING":"Creating","REBOOTING":"Re- starting","RUNNING":"Running","SHUTDOWN":"Stop waiting to be terminated","STARTING":"Starting","STOPPED":"Shut down","STOPPING":"Shutting down"," TERMINATING":"Terminating"}},{"Field":"Zone","FieldName":"Available zone","FieldType":"string","FieldDict":{}},{"Field":" PrivateIPAddresses","FieldName":"Private IP addresses","FieldType":"stringSlice","FieldDict":{}},{"Field":"PublicIPAddresses","FieldName":"Public IP addresses","Field Type":"stringSlice","FieldDict":{}},{"Field":"Region","FieldName":"Region","FieldType":"string","FieldDict":{}},{" Field":"Tags","FieldName":"Tags","FieldType":"tags","FieldDict":{}}],"RiskTotalCount":3,"Risks":"[{\"InstanceId\" :\"ins-xxx1\",\"InstanceName\":\"xxx1\",\"InstanceState\":\"RUNNING\",\"PrivateIPAddresses\":[\"1.17.64.2\"],\ " PublicIPAddresses\":null,\"Region\":\"ap-shanghai\",\"Tags\":null,\"Zone\":\"ap-shanghai-2\"},{\"InstanceId\ ":\"ins-xxx2\",\"InstanceName\":\"xxx2\",\"InstanceState\":\"RUNNING\",\"PrivateIPAddresses\":[\"1.17.64.11\"], \"PublicIPAddresses\":null,\"Region\":\"ap-shanghai\",\"Tags\":null,\"Zone\":\"ap-shanghai-2\"}]"," StrategyId":9}}
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setRiskFieldsDesc(RiskFieldsDesc [] RiskFieldsDesc) {
        this.RiskFieldsDesc = RiskFieldsDesc;
    }

    /**
     * Get Assessment item ID
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return StrategyId Assessment item ID
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Long getStrategyId() {
        return this.StrategyId;
    }

    /**
     * Set Assessment item ID
Note: This field may return null, indicating that no valid values can be obtained.
     * @param StrategyId Assessment item ID
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setStrategyId(Long StrategyId) {
        this.StrategyId = StrategyId;
    }

    /**
     * Get Number of risky instances
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return RiskTotalCount Number of risky instances
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Long getRiskTotalCount() {
        return this.RiskTotalCount;
    }

    /**
     * Set Number of risky instances
Note: This field may return null, indicating that no valid values can be obtained.
     * @param RiskTotalCount Number of risky instances
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setRiskTotalCount(Long RiskTotalCount) {
        this.RiskTotalCount = RiskTotalCount;
    }

    /**
     * Get Risky instance details list. Require json decode.
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return Risks Risky instance details list. Require json decode.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String getRisks() {
        return this.Risks;
    }

    /**
     * Set Risky instance details list. Require json decode.
Note: This field may return null, indicating that no valid values can be obtained.
     * @param Risks Risky instance details list. Require json decode.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setRisks(String Risks) {
        this.Risks = Risks;
    }

    /**
     * Get Number of inspection resources
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return ResourceCount Number of inspection resources
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Long getResourceCount() {
        return this.ResourceCount;
    }

    /**
     * Set Number of inspection resources
Note: This field may return null, indicating that no valid values can be obtained.
     * @param ResourceCount Number of inspection resources
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setResourceCount(Long ResourceCount) {
        this.ResourceCount = ResourceCount;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeTaskStrategyRisksResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeTaskStrategyRisksResponse(DescribeTaskStrategyRisksResponse source) {
        if (source.RiskFieldsDesc != null) {
            this.RiskFieldsDesc = new RiskFieldsDesc[source.RiskFieldsDesc.length];
            for (int i = 0; i < source.RiskFieldsDesc.length; i++) {
                this.RiskFieldsDesc[i] = new RiskFieldsDesc(source.RiskFieldsDesc[i]);
            }
        }
        if (source.StrategyId != null) {
            this.StrategyId = new Long(source.StrategyId);
        }
        if (source.RiskTotalCount != null) {
            this.RiskTotalCount = new Long(source.RiskTotalCount);
        }
        if (source.Risks != null) {
            this.Risks = new String(source.Risks);
        }
        if (source.ResourceCount != null) {
            this.ResourceCount = new Long(source.ResourceCount);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "RiskFieldsDesc.", this.RiskFieldsDesc);
        this.setParamSimple(map, prefix + "StrategyId", this.StrategyId);
        this.setParamSimple(map, prefix + "RiskTotalCount", this.RiskTotalCount);
        this.setParamSimple(map, prefix + "Risks", this.Risks);
        this.setParamSimple(map, prefix + "ResourceCount", this.ResourceCount);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

