/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.aiart.v20221229.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class ImageToImageResponse extends AbstractModel {

    /**
    * Different content is returned depending on the input parameter RspImgType.
If the value is base64, the Base64 code of the generated image is returned.
If the value is url, the URL of the generated image is returned. The URL is valid for 1 hour. Save it in time.
    */
    @SerializedName("ResultImage")
    @Expose
    private String ResultImage;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Different content is returned depending on the input parameter RspImgType.
If the value is base64, the Base64 code of the generated image is returned.
If the value is url, the URL of the generated image is returned. The URL is valid for 1 hour. Save it in time. 
     * @return ResultImage Different content is returned depending on the input parameter RspImgType.
If the value is base64, the Base64 code of the generated image is returned.
If the value is url, the URL of the generated image is returned. The URL is valid for 1 hour. Save it in time.
     */
    public String getResultImage() {
        return this.ResultImage;
    }

    /**
     * Set Different content is returned depending on the input parameter RspImgType.
If the value is base64, the Base64 code of the generated image is returned.
If the value is url, the URL of the generated image is returned. The URL is valid for 1 hour. Save it in time.
     * @param ResultImage Different content is returned depending on the input parameter RspImgType.
If the value is base64, the Base64 code of the generated image is returned.
If the value is url, the URL of the generated image is returned. The URL is valid for 1 hour. Save it in time.
     */
    public void setResultImage(String ResultImage) {
        this.ResultImage = ResultImage;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public ImageToImageResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public ImageToImageResponse(ImageToImageResponse source) {
        if (source.ResultImage != null) {
            this.ResultImage = new String(source.ResultImage);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "ResultImage", this.ResultImage);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

