/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.antiddos.v20200309.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeBasicDeviceStatusResponse extends AbstractModel {

    /**
    * Status of the specified Anti-DDoS resource. Valid values:
`1`: The IP is blocked.
`2`: The P is normal.
`3`: The IP is being attacked.
    */
    @SerializedName("Data")
    @Expose
    private KeyValue [] Data;

    /**
    * 
    */
    @SerializedName("CLBData")
    @Expose
    private KeyValue [] CLBData;

    /**
    * 
    */
    @SerializedName("CnameWafData")
    @Expose
    private KeyValue [] CnameWafData;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Status of the specified Anti-DDoS resource. Valid values:
`1`: The IP is blocked.
`2`: The P is normal.
`3`: The IP is being attacked. 
     * @return Data Status of the specified Anti-DDoS resource. Valid values:
`1`: The IP is blocked.
`2`: The P is normal.
`3`: The IP is being attacked.
     */
    public KeyValue [] getData() {
        return this.Data;
    }

    /**
     * Set Status of the specified Anti-DDoS resource. Valid values:
`1`: The IP is blocked.
`2`: The P is normal.
`3`: The IP is being attacked.
     * @param Data Status of the specified Anti-DDoS resource. Valid values:
`1`: The IP is blocked.
`2`: The P is normal.
`3`: The IP is being attacked.
     */
    public void setData(KeyValue [] Data) {
        this.Data = Data;
    }

    /**
     * Get  
     * @return CLBData 
     */
    public KeyValue [] getCLBData() {
        return this.CLBData;
    }

    /**
     * Set 
     * @param CLBData 
     */
    public void setCLBData(KeyValue [] CLBData) {
        this.CLBData = CLBData;
    }

    /**
     * Get  
     * @return CnameWafData 
     */
    public KeyValue [] getCnameWafData() {
        return this.CnameWafData;
    }

    /**
     * Set 
     * @param CnameWafData 
     */
    public void setCnameWafData(KeyValue [] CnameWafData) {
        this.CnameWafData = CnameWafData;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeBasicDeviceStatusResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeBasicDeviceStatusResponse(DescribeBasicDeviceStatusResponse source) {
        if (source.Data != null) {
            this.Data = new KeyValue[source.Data.length];
            for (int i = 0; i < source.Data.length; i++) {
                this.Data[i] = new KeyValue(source.Data[i]);
            }
        }
        if (source.CLBData != null) {
            this.CLBData = new KeyValue[source.CLBData.length];
            for (int i = 0; i < source.CLBData.length; i++) {
                this.CLBData[i] = new KeyValue(source.CLBData[i]);
            }
        }
        if (source.CnameWafData != null) {
            this.CnameWafData = new KeyValue[source.CnameWafData.length];
            for (int i = 0; i < source.CnameWafData.length; i++) {
                this.CnameWafData[i] = new KeyValue(source.CnameWafData[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "Data.", this.Data);
        this.setParamArrayObj(map, prefix + "CLBData.", this.CLBData);
        this.setParamArrayObj(map, prefix + "CnameWafData.", this.CnameWafData);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

