/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.antiddos.v20200309.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeListBlackWhiteIpListResponse extends AbstractModel {

    /**
    * Total number of lists
    */
    @SerializedName("Total")
    @Expose
    private Long Total;

    /**
    * IP blocklist/allowlist
    */
    @SerializedName("IpList")
    @Expose
    private BlackWhiteIpRelation [] IpList;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Total number of lists 
     * @return Total Total number of lists
     */
    public Long getTotal() {
        return this.Total;
    }

    /**
     * Set Total number of lists
     * @param Total Total number of lists
     */
    public void setTotal(Long Total) {
        this.Total = Total;
    }

    /**
     * Get IP blocklist/allowlist 
     * @return IpList IP blocklist/allowlist
     */
    public BlackWhiteIpRelation [] getIpList() {
        return this.IpList;
    }

    /**
     * Set IP blocklist/allowlist
     * @param IpList IP blocklist/allowlist
     */
    public void setIpList(BlackWhiteIpRelation [] IpList) {
        this.IpList = IpList;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeListBlackWhiteIpListResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeListBlackWhiteIpListResponse(DescribeListBlackWhiteIpListResponse source) {
        if (source.Total != null) {
            this.Total = new Long(source.Total);
        }
        if (source.IpList != null) {
            this.IpList = new BlackWhiteIpRelation[source.IpList.length];
            for (int i = 0; i < source.IpList.length; i++) {
                this.IpList[i] = new BlackWhiteIpRelation(source.IpList[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Total", this.Total);
        this.setParamArrayObj(map, prefix + "IpList.", this.IpList);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

