/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.apigateway.v20180808.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DeleteServiceRequest extends AbstractModel {

    /**
    * Unique ID of the service to be deleted.
    */
    @SerializedName("ServiceId")
    @Expose
    private String ServiceId;

    /**
    * A parameter used to set to skip the deletion precondition verification (only supported for services on dedicated instances).
    */
    @SerializedName("SkipVerification")
    @Expose
    private Long SkipVerification;

    /**
     * Get Unique ID of the service to be deleted. 
     * @return ServiceId Unique ID of the service to be deleted.
     */
    public String getServiceId() {
        return this.ServiceId;
    }

    /**
     * Set Unique ID of the service to be deleted.
     * @param ServiceId Unique ID of the service to be deleted.
     */
    public void setServiceId(String ServiceId) {
        this.ServiceId = ServiceId;
    }

    /**
     * Get A parameter used to set to skip the deletion precondition verification (only supported for services on dedicated instances). 
     * @return SkipVerification A parameter used to set to skip the deletion precondition verification (only supported for services on dedicated instances).
     */
    public Long getSkipVerification() {
        return this.SkipVerification;
    }

    /**
     * Set A parameter used to set to skip the deletion precondition verification (only supported for services on dedicated instances).
     * @param SkipVerification A parameter used to set to skip the deletion precondition verification (only supported for services on dedicated instances).
     */
    public void setSkipVerification(Long SkipVerification) {
        this.SkipVerification = SkipVerification;
    }

    public DeleteServiceRequest() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DeleteServiceRequest(DeleteServiceRequest source) {
        if (source.ServiceId != null) {
            this.ServiceId = new String(source.ServiceId);
        }
        if (source.SkipVerification != null) {
            this.SkipVerification = new Long(source.SkipVerification);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "ServiceId", this.ServiceId);
        this.setParamSimple(map, prefix + "SkipVerification", this.SkipVerification);

    }
}

