/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.bi.v20220105.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class CreateEmbedTokenResponse extends AbstractModel {

    /**
    * Custom error information object.
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("ErrorInfo")
    @Expose
    private ErrorInfo ErrorInfo;

    /**
    * Additional information.
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("Extra")
    @Expose
    private String Extra;

    /**
    * Data.
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("Data")
    @Expose
    private EmbedTokenInfo Data;

    /**
    * Result description.
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("Msg")
    @Expose
    private String Msg;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Custom error information object.
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return ErrorInfo Custom error information object.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public ErrorInfo getErrorInfo() {
        return this.ErrorInfo;
    }

    /**
     * Set Custom error information object.
Note: This field may return null, indicating that no valid values can be obtained.
     * @param ErrorInfo Custom error information object.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setErrorInfo(ErrorInfo ErrorInfo) {
        this.ErrorInfo = ErrorInfo;
    }

    /**
     * Get Additional information.
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return Extra Additional information.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String getExtra() {
        return this.Extra;
    }

    /**
     * Set Additional information.
Note: This field may return null, indicating that no valid values can be obtained.
     * @param Extra Additional information.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setExtra(String Extra) {
        this.Extra = Extra;
    }

    /**
     * Get Data.
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return Data Data.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public EmbedTokenInfo getData() {
        return this.Data;
    }

    /**
     * Set Data.
Note: This field may return null, indicating that no valid values can be obtained.
     * @param Data Data.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setData(EmbedTokenInfo Data) {
        this.Data = Data;
    }

    /**
     * Get Result description.
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return Msg Result description.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String getMsg() {
        return this.Msg;
    }

    /**
     * Set Result description.
Note: This field may return null, indicating that no valid values can be obtained.
     * @param Msg Result description.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setMsg(String Msg) {
        this.Msg = Msg;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public CreateEmbedTokenResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public CreateEmbedTokenResponse(CreateEmbedTokenResponse source) {
        if (source.ErrorInfo != null) {
            this.ErrorInfo = new ErrorInfo(source.ErrorInfo);
        }
        if (source.Extra != null) {
            this.Extra = new String(source.Extra);
        }
        if (source.Data != null) {
            this.Data = new EmbedTokenInfo(source.Data);
        }
        if (source.Msg != null) {
            this.Msg = new String(source.Msg);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamObj(map, prefix + "ErrorInfo.", this.ErrorInfo);
        this.setParamSimple(map, prefix + "Extra", this.Extra);
        this.setParamObj(map, prefix + "Data.", this.Data);
        this.setParamSimple(map, prefix + "Msg", this.Msg);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

