/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.bi.v20220105.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class ModifyDatasourceCloudResponse extends AbstractModel {

    /**
    * Custom error information object.
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("ErrorInfo")
    @Expose
    private ErrorInfo ErrorInfo;

    /**
    * Success No.
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("Data")
    @Expose
    private String Data;

    /**
    * Additional information.
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("Extra")
    @Expose
    private String Extra;

    /**
    * Prompt.
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("Msg")
    @Expose
    private String Msg;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Custom error information object.
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return ErrorInfo Custom error information object.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public ErrorInfo getErrorInfo() {
        return this.ErrorInfo;
    }

    /**
     * Set Custom error information object.
Note: This field may return null, indicating that no valid values can be obtained.
     * @param ErrorInfo Custom error information object.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setErrorInfo(ErrorInfo ErrorInfo) {
        this.ErrorInfo = ErrorInfo;
    }

    /**
     * Get Success No.
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return Data Success No.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String getData() {
        return this.Data;
    }

    /**
     * Set Success No.
Note: This field may return null, indicating that no valid values can be obtained.
     * @param Data Success No.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setData(String Data) {
        this.Data = Data;
    }

    /**
     * Get Additional information.
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return Extra Additional information.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String getExtra() {
        return this.Extra;
    }

    /**
     * Set Additional information.
Note: This field may return null, indicating that no valid values can be obtained.
     * @param Extra Additional information.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setExtra(String Extra) {
        this.Extra = Extra;
    }

    /**
     * Get Prompt.
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return Msg Prompt.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String getMsg() {
        return this.Msg;
    }

    /**
     * Set Prompt.
Note: This field may return null, indicating that no valid values can be obtained.
     * @param Msg Prompt.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setMsg(String Msg) {
        this.Msg = Msg;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public ModifyDatasourceCloudResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public ModifyDatasourceCloudResponse(ModifyDatasourceCloudResponse source) {
        if (source.ErrorInfo != null) {
            this.ErrorInfo = new ErrorInfo(source.ErrorInfo);
        }
        if (source.Data != null) {
            this.Data = new String(source.Data);
        }
        if (source.Extra != null) {
            this.Extra = new String(source.Extra);
        }
        if (source.Msg != null) {
            this.Msg = new String(source.Msg);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamObj(map, prefix + "ErrorInfo.", this.ErrorInfo);
        this.setParamSimple(map, prefix + "Data", this.Data);
        this.setParamSimple(map, prefix + "Extra", this.Extra);
        this.setParamSimple(map, prefix + "Msg", this.Msg);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

