/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.billing.v20180709.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeAllocationRuleDetailResponse extends AbstractModel {

    /**
    * Sharing rule ID.
    */
    @SerializedName("Id")
    @Expose
    private Long Id;

    /**
    * Sharing rule ownership UIN.
    */
    @SerializedName("Uin")
    @Expose
    private String Uin;

    /**
    * Sharing rule name.
    */
    @SerializedName("Name")
    @Expose
    private String Name;

    /**
    * Specifies the public area policy type. the enumeration values are as follows:.
1 - custom sharing proportion. 
2 - proportional allocation. 
3 - allocation by proportion.
    */
    @SerializedName("Type")
    @Expose
    private Long Type;

    /**
    * Public sharing rule expression.
    */
    @SerializedName("RuleDetail")
    @Expose
    private AllocationRuleExpression RuleDetail;

    /**
    * Sharing proportion expression. returns when Type is 1 or 2.
    */
    @SerializedName("RatioDetail")
    @Expose
    private AllocationRationExpression [] RatioDetail;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Sharing rule ID. 
     * @return Id Sharing rule ID.
     */
    public Long getId() {
        return this.Id;
    }

    /**
     * Set Sharing rule ID.
     * @param Id Sharing rule ID.
     */
    public void setId(Long Id) {
        this.Id = Id;
    }

    /**
     * Get Sharing rule ownership UIN. 
     * @return Uin Sharing rule ownership UIN.
     */
    public String getUin() {
        return this.Uin;
    }

    /**
     * Set Sharing rule ownership UIN.
     * @param Uin Sharing rule ownership UIN.
     */
    public void setUin(String Uin) {
        this.Uin = Uin;
    }

    /**
     * Get Sharing rule name. 
     * @return Name Sharing rule name.
     */
    public String getName() {
        return this.Name;
    }

    /**
     * Set Sharing rule name.
     * @param Name Sharing rule name.
     */
    public void setName(String Name) {
        this.Name = Name;
    }

    /**
     * Get Specifies the public area policy type. the enumeration values are as follows:.
1 - custom sharing proportion. 
2 - proportional allocation. 
3 - allocation by proportion. 
     * @return Type Specifies the public area policy type. the enumeration values are as follows:.
1 - custom sharing proportion. 
2 - proportional allocation. 
3 - allocation by proportion.
     */
    public Long getType() {
        return this.Type;
    }

    /**
     * Set Specifies the public area policy type. the enumeration values are as follows:.
1 - custom sharing proportion. 
2 - proportional allocation. 
3 - allocation by proportion.
     * @param Type Specifies the public area policy type. the enumeration values are as follows:.
1 - custom sharing proportion. 
2 - proportional allocation. 
3 - allocation by proportion.
     */
    public void setType(Long Type) {
        this.Type = Type;
    }

    /**
     * Get Public sharing rule expression. 
     * @return RuleDetail Public sharing rule expression.
     */
    public AllocationRuleExpression getRuleDetail() {
        return this.RuleDetail;
    }

    /**
     * Set Public sharing rule expression.
     * @param RuleDetail Public sharing rule expression.
     */
    public void setRuleDetail(AllocationRuleExpression RuleDetail) {
        this.RuleDetail = RuleDetail;
    }

    /**
     * Get Sharing proportion expression. returns when Type is 1 or 2. 
     * @return RatioDetail Sharing proportion expression. returns when Type is 1 or 2.
     */
    public AllocationRationExpression [] getRatioDetail() {
        return this.RatioDetail;
    }

    /**
     * Set Sharing proportion expression. returns when Type is 1 or 2.
     * @param RatioDetail Sharing proportion expression. returns when Type is 1 or 2.
     */
    public void setRatioDetail(AllocationRationExpression [] RatioDetail) {
        this.RatioDetail = RatioDetail;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeAllocationRuleDetailResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeAllocationRuleDetailResponse(DescribeAllocationRuleDetailResponse source) {
        if (source.Id != null) {
            this.Id = new Long(source.Id);
        }
        if (source.Uin != null) {
            this.Uin = new String(source.Uin);
        }
        if (source.Name != null) {
            this.Name = new String(source.Name);
        }
        if (source.Type != null) {
            this.Type = new Long(source.Type);
        }
        if (source.RuleDetail != null) {
            this.RuleDetail = new AllocationRuleExpression(source.RuleDetail);
        }
        if (source.RatioDetail != null) {
            this.RatioDetail = new AllocationRationExpression[source.RatioDetail.length];
            for (int i = 0; i < source.RatioDetail.length; i++) {
                this.RatioDetail[i] = new AllocationRationExpression(source.RatioDetail[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Id", this.Id);
        this.setParamSimple(map, prefix + "Uin", this.Uin);
        this.setParamSimple(map, prefix + "Name", this.Name);
        this.setParamSimple(map, prefix + "Type", this.Type);
        this.setParamObj(map, prefix + "RuleDetail.", this.RuleDetail);
        this.setParamArrayObj(map, prefix + "RatioDetail.", this.RatioDetail);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

