/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.billing.v20180709.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeAllocationUnitDetailResponse extends AbstractModel {

    /**
    * ID of a cost allocation unit.
    */
    @SerializedName("Id")
    @Expose
    private Long Id;

    /**
    * Associated UIN of the cost allocation unit.
    */
    @SerializedName("Uin")
    @Expose
    private String Uin;

    /**
    * Specifies the name of a cost allocation unit.
    */
    @SerializedName("Name")
    @Expose
    private String Name;

    /**
    * Cost allocation unit parent node ID.
    */
    @SerializedName("ParentId")
    @Expose
    private Long ParentId;

    /**
    * Source organization name.
    */
    @SerializedName("SourceName")
    @Expose
    private String SourceName;

    /**
    * Source organization ID.
    */
    @SerializedName("SourceId")
    @Expose
    private String SourceId;

    /**
    * Specifies remark description.
    */
    @SerializedName("Remark")
    @Expose
    private String Remark;

    /**
    * Cost allocation unit identifier.
    */
    @SerializedName("TreeNodeUniqKey")
    @Expose
    private String TreeNodeUniqKey;

    /**
    * If a cost allocation unit is set with an collection rule, return the collection rule ID. if no collection rule is set, do not return.
    */
    @SerializedName("RuleId")
    @Expose
    private Long RuleId;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get ID of a cost allocation unit. 
     * @return Id ID of a cost allocation unit.
     */
    public Long getId() {
        return this.Id;
    }

    /**
     * Set ID of a cost allocation unit.
     * @param Id ID of a cost allocation unit.
     */
    public void setId(Long Id) {
        this.Id = Id;
    }

    /**
     * Get Associated UIN of the cost allocation unit. 
     * @return Uin Associated UIN of the cost allocation unit.
     */
    public String getUin() {
        return this.Uin;
    }

    /**
     * Set Associated UIN of the cost allocation unit.
     * @param Uin Associated UIN of the cost allocation unit.
     */
    public void setUin(String Uin) {
        this.Uin = Uin;
    }

    /**
     * Get Specifies the name of a cost allocation unit. 
     * @return Name Specifies the name of a cost allocation unit.
     */
    public String getName() {
        return this.Name;
    }

    /**
     * Set Specifies the name of a cost allocation unit.
     * @param Name Specifies the name of a cost allocation unit.
     */
    public void setName(String Name) {
        this.Name = Name;
    }

    /**
     * Get Cost allocation unit parent node ID. 
     * @return ParentId Cost allocation unit parent node ID.
     */
    public Long getParentId() {
        return this.ParentId;
    }

    /**
     * Set Cost allocation unit parent node ID.
     * @param ParentId Cost allocation unit parent node ID.
     */
    public void setParentId(Long ParentId) {
        this.ParentId = ParentId;
    }

    /**
     * Get Source organization name. 
     * @return SourceName Source organization name.
     */
    public String getSourceName() {
        return this.SourceName;
    }

    /**
     * Set Source organization name.
     * @param SourceName Source organization name.
     */
    public void setSourceName(String SourceName) {
        this.SourceName = SourceName;
    }

    /**
     * Get Source organization ID. 
     * @return SourceId Source organization ID.
     */
    public String getSourceId() {
        return this.SourceId;
    }

    /**
     * Set Source organization ID.
     * @param SourceId Source organization ID.
     */
    public void setSourceId(String SourceId) {
        this.SourceId = SourceId;
    }

    /**
     * Get Specifies remark description. 
     * @return Remark Specifies remark description.
     */
    public String getRemark() {
        return this.Remark;
    }

    /**
     * Set Specifies remark description.
     * @param Remark Specifies remark description.
     */
    public void setRemark(String Remark) {
        this.Remark = Remark;
    }

    /**
     * Get Cost allocation unit identifier. 
     * @return TreeNodeUniqKey Cost allocation unit identifier.
     */
    public String getTreeNodeUniqKey() {
        return this.TreeNodeUniqKey;
    }

    /**
     * Set Cost allocation unit identifier.
     * @param TreeNodeUniqKey Cost allocation unit identifier.
     */
    public void setTreeNodeUniqKey(String TreeNodeUniqKey) {
        this.TreeNodeUniqKey = TreeNodeUniqKey;
    }

    /**
     * Get If a cost allocation unit is set with an collection rule, return the collection rule ID. if no collection rule is set, do not return. 
     * @return RuleId If a cost allocation unit is set with an collection rule, return the collection rule ID. if no collection rule is set, do not return.
     */
    public Long getRuleId() {
        return this.RuleId;
    }

    /**
     * Set If a cost allocation unit is set with an collection rule, return the collection rule ID. if no collection rule is set, do not return.
     * @param RuleId If a cost allocation unit is set with an collection rule, return the collection rule ID. if no collection rule is set, do not return.
     */
    public void setRuleId(Long RuleId) {
        this.RuleId = RuleId;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeAllocationUnitDetailResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeAllocationUnitDetailResponse(DescribeAllocationUnitDetailResponse source) {
        if (source.Id != null) {
            this.Id = new Long(source.Id);
        }
        if (source.Uin != null) {
            this.Uin = new String(source.Uin);
        }
        if (source.Name != null) {
            this.Name = new String(source.Name);
        }
        if (source.ParentId != null) {
            this.ParentId = new Long(source.ParentId);
        }
        if (source.SourceName != null) {
            this.SourceName = new String(source.SourceName);
        }
        if (source.SourceId != null) {
            this.SourceId = new String(source.SourceId);
        }
        if (source.Remark != null) {
            this.Remark = new String(source.Remark);
        }
        if (source.TreeNodeUniqKey != null) {
            this.TreeNodeUniqKey = new String(source.TreeNodeUniqKey);
        }
        if (source.RuleId != null) {
            this.RuleId = new Long(source.RuleId);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Id", this.Id);
        this.setParamSimple(map, prefix + "Uin", this.Uin);
        this.setParamSimple(map, prefix + "Name", this.Name);
        this.setParamSimple(map, prefix + "ParentId", this.ParentId);
        this.setParamSimple(map, prefix + "SourceName", this.SourceName);
        this.setParamSimple(map, prefix + "SourceId", this.SourceId);
        this.setParamSimple(map, prefix + "Remark", this.Remark);
        this.setParamSimple(map, prefix + "TreeNodeUniqKey", this.TreeNodeUniqKey);
        this.setParamSimple(map, prefix + "RuleId", this.RuleId);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

