/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.billing.v20180709.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeBillDownloadUrlResponse extends AbstractModel {

    /**
    * Indicates whether the bill file is ready. Valid values: `0` (the file is being generated), `1` (the file has been generated).
    */
    @SerializedName("Ready")
    @Expose
    private Long Ready;

    /**
    * Billing file download link, valid for 1 day. Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("DownloadUrl")
    @Expose
    private String DownloadUrl;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Indicates whether the bill file is ready. Valid values: `0` (the file is being generated), `1` (the file has been generated). 
     * @return Ready Indicates whether the bill file is ready. Valid values: `0` (the file is being generated), `1` (the file has been generated).
     */
    public Long getReady() {
        return this.Ready;
    }

    /**
     * Set Indicates whether the bill file is ready. Valid values: `0` (the file is being generated), `1` (the file has been generated).
     * @param Ready Indicates whether the bill file is ready. Valid values: `0` (the file is being generated), `1` (the file has been generated).
     */
    public void setReady(Long Ready) {
        this.Ready = Ready;
    }

    /**
     * Get Billing file download link, valid for 1 day. Note: This field may return null, indicating that no valid values can be obtained. 
     * @return DownloadUrl Billing file download link, valid for 1 day. Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String getDownloadUrl() {
        return this.DownloadUrl;
    }

    /**
     * Set Billing file download link, valid for 1 day. Note: This field may return null, indicating that no valid values can be obtained.
     * @param DownloadUrl Billing file download link, valid for 1 day. Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setDownloadUrl(String DownloadUrl) {
        this.DownloadUrl = DownloadUrl;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeBillDownloadUrlResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeBillDownloadUrlResponse(DescribeBillDownloadUrlResponse source) {
        if (source.Ready != null) {
            this.Ready = new Long(source.Ready);
        }
        if (source.DownloadUrl != null) {
            this.DownloadUrl = new String(source.DownloadUrl);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Ready", this.Ready);
        this.setParamSimple(map, prefix + "DownloadUrl", this.DownloadUrl);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

