/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cam.v20190116.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class AddUserToGroupRequest extends AbstractModel {

    /**
    * The association between the user group ID and the sub-user UIN/UID.
    */
    @SerializedName("Info")
    @Expose
    private GroupIdOfUidInfo [] Info;

    /**
     * Get The association between the user group ID and the sub-user UIN/UID. 
     * @return Info The association between the user group ID and the sub-user UIN/UID.
     */
    public GroupIdOfUidInfo [] getInfo() {
        return this.Info;
    }

    /**
     * Set The association between the user group ID and the sub-user UIN/UID.
     * @param Info The association between the user group ID and the sub-user UIN/UID.
     */
    public void setInfo(GroupIdOfUidInfo [] Info) {
        this.Info = Info;
    }

    public AddUserToGroupRequest() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public AddUserToGroupRequest(AddUserToGroupRequest source) {
        if (source.Info != null) {
            this.Info = new GroupIdOfUidInfo[source.Info.length];
            for (int i = 0; i < source.Info.length; i++) {
                this.Info[i] = new GroupIdOfUidInfo(source.Info[i]);
            }
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "Info.", this.Info);

    }
}

