/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.captcha.v20190722.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeCaptchaResultResponse extends AbstractModel {

    /**
    * OK indicates verification passed.
7 captcha no match. the passed in Randstr is invalid. please check if the Randstr is consistent with the Randstr returned by the frontend.
The passed-in ticket has expired (the valid period of the ticket is 5 minutes). generate the ticket and Randstr again for validation.
The passed-in ticket is reused. generate the ticket and Randstr again for verification.
15 decrypt fail. the passed-in Ticket is invalid. please check if the Ticket is consistent with the Ticket returned by the frontend.
16 appid-ticket mismatch. the passed in CaptchaAppId is incorrect. please check if the CaptchaAppId is consistent with the CaptchaAppId passed in by the frontend, and ensure that the CaptchaAppId is obtained from the verification code console [verification management] -> [basic configuration].
21 diff invoice verification exception. possible reasons: (1) if the Ticket contains the trerror prefix, generally because the user has a poor network connection, resulting in the frontend's automatic disaster recovery and generation of a disaster recovery Ticket. the business side may skip or post-process as needed. (2) if the Ticket does not include the trerror prefix, it is because the security risk of the request was detected by the CAPTCHA-intl risk control system. the business side may intercept as needed.
100 appid-secretkey-ticket mismatch. parameter validation error. (1) please check whether the CaptchaAppId and AppSecretKey are correct. the CaptchaAppId and AppSecretKey need to be obtained from verification code console > verification management > basic configuration. (2) please check whether the passed-in ticket is generated by the passed-in CaptchaAppId.
    */
    @SerializedName("CaptchaCode")
    @Expose
    private Long CaptchaCode;

    /**
    * Status description and verification error message.
    */
    @SerializedName("CaptchaMsg")
    @Expose
    private String CaptchaMsg;

    /**
    * In invisible verification mode, this parameter returns the verification result.
EvilLevel=0 indicates that the request is not malicious.
The parameter EvilLevel = 100 indicates that the request is malicious.
    */
    @SerializedName("EvilLevel")
    @Expose
    private Long EvilLevel;

    /**
    * Frontend retrieval time of the captcha-intl, timestamp format.
    */
    @SerializedName("GetCaptchaTime")
    @Expose
    private Long GetCaptchaTime;

    /**
    * Blocking type
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("EvilBitmap")
    @Expose
    private Long EvilBitmap;

    /**
    * The time when the CAPTCHA is submitted.
    */
    @SerializedName("SubmitCaptchaTime")
    @Expose
    private Long SubmitCaptchaTime;

    /**
    * Device risk category.
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("DeviceRiskCategory")
    @Expose
    private String DeviceRiskCategory;

    /**
    * CAPTCHA-Intl score.
Note:The score ranges from 0 to 100 (e.g., 20, 70, 90).
A higher score indicates a greater probability that the interaction was initiated by a bot or represents a bot attack.
A lower score indicates a greater probability that the interaction was performed by a real human user.
    */
    @SerializedName("Score")
    @Expose
    private Long Score;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get OK indicates verification passed.
7 captcha no match. the passed in Randstr is invalid. please check if the Randstr is consistent with the Randstr returned by the frontend.
The passed-in ticket has expired (the valid period of the ticket is 5 minutes). generate the ticket and Randstr again for validation.
The passed-in ticket is reused. generate the ticket and Randstr again for verification.
15 decrypt fail. the passed-in Ticket is invalid. please check if the Ticket is consistent with the Ticket returned by the frontend.
16 appid-ticket mismatch. the passed in CaptchaAppId is incorrect. please check if the CaptchaAppId is consistent with the CaptchaAppId passed in by the frontend, and ensure that the CaptchaAppId is obtained from the verification code console [verification management] -> [basic configuration].
21 diff invoice verification exception. possible reasons: (1) if the Ticket contains the trerror prefix, generally because the user has a poor network connection, resulting in the frontend's automatic disaster recovery and generation of a disaster recovery Ticket. the business side may skip or post-process as needed. (2) if the Ticket does not include the trerror prefix, it is because the security risk of the request was detected by the CAPTCHA-intl risk control system. the business side may intercept as needed.
100 appid-secretkey-ticket mismatch. parameter validation error. (1) please check whether the CaptchaAppId and AppSecretKey are correct. the CaptchaAppId and AppSecretKey need to be obtained from verification code console > verification management > basic configuration. (2) please check whether the passed-in ticket is generated by the passed-in CaptchaAppId. 
     * @return CaptchaCode OK indicates verification passed.
7 captcha no match. the passed in Randstr is invalid. please check if the Randstr is consistent with the Randstr returned by the frontend.
The passed-in ticket has expired (the valid period of the ticket is 5 minutes). generate the ticket and Randstr again for validation.
The passed-in ticket is reused. generate the ticket and Randstr again for verification.
15 decrypt fail. the passed-in Ticket is invalid. please check if the Ticket is consistent with the Ticket returned by the frontend.
16 appid-ticket mismatch. the passed in CaptchaAppId is incorrect. please check if the CaptchaAppId is consistent with the CaptchaAppId passed in by the frontend, and ensure that the CaptchaAppId is obtained from the verification code console [verification management] -> [basic configuration].
21 diff invoice verification exception. possible reasons: (1) if the Ticket contains the trerror prefix, generally because the user has a poor network connection, resulting in the frontend's automatic disaster recovery and generation of a disaster recovery Ticket. the business side may skip or post-process as needed. (2) if the Ticket does not include the trerror prefix, it is because the security risk of the request was detected by the CAPTCHA-intl risk control system. the business side may intercept as needed.
100 appid-secretkey-ticket mismatch. parameter validation error. (1) please check whether the CaptchaAppId and AppSecretKey are correct. the CaptchaAppId and AppSecretKey need to be obtained from verification code console > verification management > basic configuration. (2) please check whether the passed-in ticket is generated by the passed-in CaptchaAppId.
     */
    public Long getCaptchaCode() {
        return this.CaptchaCode;
    }

    /**
     * Set OK indicates verification passed.
7 captcha no match. the passed in Randstr is invalid. please check if the Randstr is consistent with the Randstr returned by the frontend.
The passed-in ticket has expired (the valid period of the ticket is 5 minutes). generate the ticket and Randstr again for validation.
The passed-in ticket is reused. generate the ticket and Randstr again for verification.
15 decrypt fail. the passed-in Ticket is invalid. please check if the Ticket is consistent with the Ticket returned by the frontend.
16 appid-ticket mismatch. the passed in CaptchaAppId is incorrect. please check if the CaptchaAppId is consistent with the CaptchaAppId passed in by the frontend, and ensure that the CaptchaAppId is obtained from the verification code console [verification management] -> [basic configuration].
21 diff invoice verification exception. possible reasons: (1) if the Ticket contains the trerror prefix, generally because the user has a poor network connection, resulting in the frontend's automatic disaster recovery and generation of a disaster recovery Ticket. the business side may skip or post-process as needed. (2) if the Ticket does not include the trerror prefix, it is because the security risk of the request was detected by the CAPTCHA-intl risk control system. the business side may intercept as needed.
100 appid-secretkey-ticket mismatch. parameter validation error. (1) please check whether the CaptchaAppId and AppSecretKey are correct. the CaptchaAppId and AppSecretKey need to be obtained from verification code console > verification management > basic configuration. (2) please check whether the passed-in ticket is generated by the passed-in CaptchaAppId.
     * @param CaptchaCode OK indicates verification passed.
7 captcha no match. the passed in Randstr is invalid. please check if the Randstr is consistent with the Randstr returned by the frontend.
The passed-in ticket has expired (the valid period of the ticket is 5 minutes). generate the ticket and Randstr again for validation.
The passed-in ticket is reused. generate the ticket and Randstr again for verification.
15 decrypt fail. the passed-in Ticket is invalid. please check if the Ticket is consistent with the Ticket returned by the frontend.
16 appid-ticket mismatch. the passed in CaptchaAppId is incorrect. please check if the CaptchaAppId is consistent with the CaptchaAppId passed in by the frontend, and ensure that the CaptchaAppId is obtained from the verification code console [verification management] -> [basic configuration].
21 diff invoice verification exception. possible reasons: (1) if the Ticket contains the trerror prefix, generally because the user has a poor network connection, resulting in the frontend's automatic disaster recovery and generation of a disaster recovery Ticket. the business side may skip or post-process as needed. (2) if the Ticket does not include the trerror prefix, it is because the security risk of the request was detected by the CAPTCHA-intl risk control system. the business side may intercept as needed.
100 appid-secretkey-ticket mismatch. parameter validation error. (1) please check whether the CaptchaAppId and AppSecretKey are correct. the CaptchaAppId and AppSecretKey need to be obtained from verification code console > verification management > basic configuration. (2) please check whether the passed-in ticket is generated by the passed-in CaptchaAppId.
     */
    public void setCaptchaCode(Long CaptchaCode) {
        this.CaptchaCode = CaptchaCode;
    }

    /**
     * Get Status description and verification error message. 
     * @return CaptchaMsg Status description and verification error message.
     */
    public String getCaptchaMsg() {
        return this.CaptchaMsg;
    }

    /**
     * Set Status description and verification error message.
     * @param CaptchaMsg Status description and verification error message.
     */
    public void setCaptchaMsg(String CaptchaMsg) {
        this.CaptchaMsg = CaptchaMsg;
    }

    /**
     * Get In invisible verification mode, this parameter returns the verification result.
EvilLevel=0 indicates that the request is not malicious.
The parameter EvilLevel = 100 indicates that the request is malicious. 
     * @return EvilLevel In invisible verification mode, this parameter returns the verification result.
EvilLevel=0 indicates that the request is not malicious.
The parameter EvilLevel = 100 indicates that the request is malicious.
     */
    public Long getEvilLevel() {
        return this.EvilLevel;
    }

    /**
     * Set In invisible verification mode, this parameter returns the verification result.
EvilLevel=0 indicates that the request is not malicious.
The parameter EvilLevel = 100 indicates that the request is malicious.
     * @param EvilLevel In invisible verification mode, this parameter returns the verification result.
EvilLevel=0 indicates that the request is not malicious.
The parameter EvilLevel = 100 indicates that the request is malicious.
     */
    public void setEvilLevel(Long EvilLevel) {
        this.EvilLevel = EvilLevel;
    }

    /**
     * Get Frontend retrieval time of the captcha-intl, timestamp format. 
     * @return GetCaptchaTime Frontend retrieval time of the captcha-intl, timestamp format.
     */
    public Long getGetCaptchaTime() {
        return this.GetCaptchaTime;
    }

    /**
     * Set Frontend retrieval time of the captcha-intl, timestamp format.
     * @param GetCaptchaTime Frontend retrieval time of the captcha-intl, timestamp format.
     */
    public void setGetCaptchaTime(Long GetCaptchaTime) {
        this.GetCaptchaTime = GetCaptchaTime;
    }

    /**
     * Get Blocking type
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return EvilBitmap Blocking type
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Long getEvilBitmap() {
        return this.EvilBitmap;
    }

    /**
     * Set Blocking type
Note: This field may return null, indicating that no valid values can be obtained.
     * @param EvilBitmap Blocking type
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setEvilBitmap(Long EvilBitmap) {
        this.EvilBitmap = EvilBitmap;
    }

    /**
     * Get The time when the CAPTCHA is submitted. 
     * @return SubmitCaptchaTime The time when the CAPTCHA is submitted.
     */
    public Long getSubmitCaptchaTime() {
        return this.SubmitCaptchaTime;
    }

    /**
     * Set The time when the CAPTCHA is submitted.
     * @param SubmitCaptchaTime The time when the CAPTCHA is submitted.
     */
    public void setSubmitCaptchaTime(Long SubmitCaptchaTime) {
        this.SubmitCaptchaTime = SubmitCaptchaTime;
    }

    /**
     * Get Device risk category.
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return DeviceRiskCategory Device risk category.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String getDeviceRiskCategory() {
        return this.DeviceRiskCategory;
    }

    /**
     * Set Device risk category.
Note: This field may return null, indicating that no valid values can be obtained.
     * @param DeviceRiskCategory Device risk category.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setDeviceRiskCategory(String DeviceRiskCategory) {
        this.DeviceRiskCategory = DeviceRiskCategory;
    }

    /**
     * Get CAPTCHA-Intl score.
Note:The score ranges from 0 to 100 (e.g., 20, 70, 90).
A higher score indicates a greater probability that the interaction was initiated by a bot or represents a bot attack.
A lower score indicates a greater probability that the interaction was performed by a real human user. 
     * @return Score CAPTCHA-Intl score.
Note:The score ranges from 0 to 100 (e.g., 20, 70, 90).
A higher score indicates a greater probability that the interaction was initiated by a bot or represents a bot attack.
A lower score indicates a greater probability that the interaction was performed by a real human user.
     */
    public Long getScore() {
        return this.Score;
    }

    /**
     * Set CAPTCHA-Intl score.
Note:The score ranges from 0 to 100 (e.g., 20, 70, 90).
A higher score indicates a greater probability that the interaction was initiated by a bot or represents a bot attack.
A lower score indicates a greater probability that the interaction was performed by a real human user.
     * @param Score CAPTCHA-Intl score.
Note:The score ranges from 0 to 100 (e.g., 20, 70, 90).
A higher score indicates a greater probability that the interaction was initiated by a bot or represents a bot attack.
A lower score indicates a greater probability that the interaction was performed by a real human user.
     */
    public void setScore(Long Score) {
        this.Score = Score;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeCaptchaResultResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeCaptchaResultResponse(DescribeCaptchaResultResponse source) {
        if (source.CaptchaCode != null) {
            this.CaptchaCode = new Long(source.CaptchaCode);
        }
        if (source.CaptchaMsg != null) {
            this.CaptchaMsg = new String(source.CaptchaMsg);
        }
        if (source.EvilLevel != null) {
            this.EvilLevel = new Long(source.EvilLevel);
        }
        if (source.GetCaptchaTime != null) {
            this.GetCaptchaTime = new Long(source.GetCaptchaTime);
        }
        if (source.EvilBitmap != null) {
            this.EvilBitmap = new Long(source.EvilBitmap);
        }
        if (source.SubmitCaptchaTime != null) {
            this.SubmitCaptchaTime = new Long(source.SubmitCaptchaTime);
        }
        if (source.DeviceRiskCategory != null) {
            this.DeviceRiskCategory = new String(source.DeviceRiskCategory);
        }
        if (source.Score != null) {
            this.Score = new Long(source.Score);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "CaptchaCode", this.CaptchaCode);
        this.setParamSimple(map, prefix + "CaptchaMsg", this.CaptchaMsg);
        this.setParamSimple(map, prefix + "EvilLevel", this.EvilLevel);
        this.setParamSimple(map, prefix + "GetCaptchaTime", this.GetCaptchaTime);
        this.setParamSimple(map, prefix + "EvilBitmap", this.EvilBitmap);
        this.setParamSimple(map, prefix + "SubmitCaptchaTime", this.SubmitCaptchaTime);
        this.setParamSimple(map, prefix + "DeviceRiskCategory", this.DeviceRiskCategory);
        this.setParamSimple(map, prefix + "Score", this.Score);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

