/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.car.v20220110.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeApplicationListResponse extends AbstractModel {

    /**
    * Application list information.
    */
    @SerializedName("UserApplicationList")
    @Expose
    private UserApplicationInfo [] UserApplicationList;

    /**
    * Total number of applications.
    */
    @SerializedName("ApplicationTotal")
    @Expose
    private Long ApplicationTotal;

    /**
    * Mobile application list information.
    */
    @SerializedName("UserMobileApplicationList")
    @Expose
    private UserMobileApplicationInfo [] UserMobileApplicationList;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Application list information. 
     * @return UserApplicationList Application list information.
     */
    public UserApplicationInfo [] getUserApplicationList() {
        return this.UserApplicationList;
    }

    /**
     * Set Application list information.
     * @param UserApplicationList Application list information.
     */
    public void setUserApplicationList(UserApplicationInfo [] UserApplicationList) {
        this.UserApplicationList = UserApplicationList;
    }

    /**
     * Get Total number of applications. 
     * @return ApplicationTotal Total number of applications.
     */
    public Long getApplicationTotal() {
        return this.ApplicationTotal;
    }

    /**
     * Set Total number of applications.
     * @param ApplicationTotal Total number of applications.
     */
    public void setApplicationTotal(Long ApplicationTotal) {
        this.ApplicationTotal = ApplicationTotal;
    }

    /**
     * Get Mobile application list information. 
     * @return UserMobileApplicationList Mobile application list information.
     */
    public UserMobileApplicationInfo [] getUserMobileApplicationList() {
        return this.UserMobileApplicationList;
    }

    /**
     * Set Mobile application list information.
     * @param UserMobileApplicationList Mobile application list information.
     */
    public void setUserMobileApplicationList(UserMobileApplicationInfo [] UserMobileApplicationList) {
        this.UserMobileApplicationList = UserMobileApplicationList;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeApplicationListResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeApplicationListResponse(DescribeApplicationListResponse source) {
        if (source.UserApplicationList != null) {
            this.UserApplicationList = new UserApplicationInfo[source.UserApplicationList.length];
            for (int i = 0; i < source.UserApplicationList.length; i++) {
                this.UserApplicationList[i] = new UserApplicationInfo(source.UserApplicationList[i]);
            }
        }
        if (source.ApplicationTotal != null) {
            this.ApplicationTotal = new Long(source.ApplicationTotal);
        }
        if (source.UserMobileApplicationList != null) {
            this.UserMobileApplicationList = new UserMobileApplicationInfo[source.UserMobileApplicationList.length];
            for (int i = 0; i < source.UserMobileApplicationList.length; i++) {
                this.UserMobileApplicationList[i] = new UserMobileApplicationInfo(source.UserMobileApplicationList[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "UserApplicationList.", this.UserApplicationList);
        this.setParamSimple(map, prefix + "ApplicationTotal", this.ApplicationTotal);
        this.setParamArrayObj(map, prefix + "UserMobileApplicationList.", this.UserMobileApplicationList);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

