/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.car.v20220110.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeApplicationProjectAdvancedConfigResponse extends AbstractModel {

    /**
    * Application startup parameters.

Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("ApplicationParams")
    @Expose
    private String ApplicationParams;

    /**
    * Resolution, in the format of widthxheight, such as 1920x1080.Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("Resolution")
    @Expose
    private String Resolution;

    /**
    * Frame rate. Valid values: 0, 30, 60.Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("FPS")
    @Expose
    private Long FPS;

    /**
    * Minimum bitrate, in Mbps.Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("MinBitrate")
    @Expose
    private Long MinBitrate;

    /**
    * Maximum bitrate, in Mbps.Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("MaxBitrate")
    @Expose
    private Long MaxBitrate;

    /**
    * Waiting time for application pre-launch.Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("PreloadDuration")
    @Expose
    private String PreloadDuration;

    /**
    * Waiting time for reconnection.Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("ReconnectTimeout")
    @Expose
    private String ReconnectTimeout;

    /**
    * Upstream audio options.DisableMixIntoStreamPush: not mixing upstream audio in streaming.Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("UpstreamAudioOption")
    @Expose
    private String UpstreamAudioOption;

    /**
    * Video encoding configuration.Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("VideoEncodeConfig")
    @Expose
    private VideoEncodeConfig VideoEncodeConfig;

    /**
    * Upper limit of the XR application resolution.If the project concurrency type is L or L2, the upper limit is 5000; if the project concurrency type is XL2, the upper limit is 6000.Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("XRMaxWidth")
    @Expose
    private Long XRMaxWidth;

    /**
    * Background image information.Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("BackgroundImage")
    @Expose
    private BackgroundImage BackgroundImage;

    /**
    * Disabled code list.Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("DisableVideoCodecs")
    @Expose
    private String [] DisableVideoCodecs;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Application startup parameters.

Note: This field may return null, indicating that no valid values can be obtained. 
     * @return ApplicationParams Application startup parameters.

Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String getApplicationParams() {
        return this.ApplicationParams;
    }

    /**
     * Set Application startup parameters.

Note: This field may return null, indicating that no valid values can be obtained.
     * @param ApplicationParams Application startup parameters.

Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setApplicationParams(String ApplicationParams) {
        this.ApplicationParams = ApplicationParams;
    }

    /**
     * Get Resolution, in the format of widthxheight, such as 1920x1080.Note: This field may return null, indicating that no valid values can be obtained. 
     * @return Resolution Resolution, in the format of widthxheight, such as 1920x1080.Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String getResolution() {
        return this.Resolution;
    }

    /**
     * Set Resolution, in the format of widthxheight, such as 1920x1080.Note: This field may return null, indicating that no valid values can be obtained.
     * @param Resolution Resolution, in the format of widthxheight, such as 1920x1080.Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setResolution(String Resolution) {
        this.Resolution = Resolution;
    }

    /**
     * Get Frame rate. Valid values: 0, 30, 60.Note: This field may return null, indicating that no valid values can be obtained. 
     * @return FPS Frame rate. Valid values: 0, 30, 60.Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Long getFPS() {
        return this.FPS;
    }

    /**
     * Set Frame rate. Valid values: 0, 30, 60.Note: This field may return null, indicating that no valid values can be obtained.
     * @param FPS Frame rate. Valid values: 0, 30, 60.Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setFPS(Long FPS) {
        this.FPS = FPS;
    }

    /**
     * Get Minimum bitrate, in Mbps.Note: This field may return null, indicating that no valid values can be obtained. 
     * @return MinBitrate Minimum bitrate, in Mbps.Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Long getMinBitrate() {
        return this.MinBitrate;
    }

    /**
     * Set Minimum bitrate, in Mbps.Note: This field may return null, indicating that no valid values can be obtained.
     * @param MinBitrate Minimum bitrate, in Mbps.Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setMinBitrate(Long MinBitrate) {
        this.MinBitrate = MinBitrate;
    }

    /**
     * Get Maximum bitrate, in Mbps.Note: This field may return null, indicating that no valid values can be obtained. 
     * @return MaxBitrate Maximum bitrate, in Mbps.Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Long getMaxBitrate() {
        return this.MaxBitrate;
    }

    /**
     * Set Maximum bitrate, in Mbps.Note: This field may return null, indicating that no valid values can be obtained.
     * @param MaxBitrate Maximum bitrate, in Mbps.Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setMaxBitrate(Long MaxBitrate) {
        this.MaxBitrate = MaxBitrate;
    }

    /**
     * Get Waiting time for application pre-launch.Note: This field may return null, indicating that no valid values can be obtained. 
     * @return PreloadDuration Waiting time for application pre-launch.Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String getPreloadDuration() {
        return this.PreloadDuration;
    }

    /**
     * Set Waiting time for application pre-launch.Note: This field may return null, indicating that no valid values can be obtained.
     * @param PreloadDuration Waiting time for application pre-launch.Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setPreloadDuration(String PreloadDuration) {
        this.PreloadDuration = PreloadDuration;
    }

    /**
     * Get Waiting time for reconnection.Note: This field may return null, indicating that no valid values can be obtained. 
     * @return ReconnectTimeout Waiting time for reconnection.Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String getReconnectTimeout() {
        return this.ReconnectTimeout;
    }

    /**
     * Set Waiting time for reconnection.Note: This field may return null, indicating that no valid values can be obtained.
     * @param ReconnectTimeout Waiting time for reconnection.Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setReconnectTimeout(String ReconnectTimeout) {
        this.ReconnectTimeout = ReconnectTimeout;
    }

    /**
     * Get Upstream audio options.DisableMixIntoStreamPush: not mixing upstream audio in streaming.Note: This field may return null, indicating that no valid values can be obtained. 
     * @return UpstreamAudioOption Upstream audio options.DisableMixIntoStreamPush: not mixing upstream audio in streaming.Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String getUpstreamAudioOption() {
        return this.UpstreamAudioOption;
    }

    /**
     * Set Upstream audio options.DisableMixIntoStreamPush: not mixing upstream audio in streaming.Note: This field may return null, indicating that no valid values can be obtained.
     * @param UpstreamAudioOption Upstream audio options.DisableMixIntoStreamPush: not mixing upstream audio in streaming.Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setUpstreamAudioOption(String UpstreamAudioOption) {
        this.UpstreamAudioOption = UpstreamAudioOption;
    }

    /**
     * Get Video encoding configuration.Note: This field may return null, indicating that no valid values can be obtained. 
     * @return VideoEncodeConfig Video encoding configuration.Note: This field may return null, indicating that no valid values can be obtained.
     */
    public VideoEncodeConfig getVideoEncodeConfig() {
        return this.VideoEncodeConfig;
    }

    /**
     * Set Video encoding configuration.Note: This field may return null, indicating that no valid values can be obtained.
     * @param VideoEncodeConfig Video encoding configuration.Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setVideoEncodeConfig(VideoEncodeConfig VideoEncodeConfig) {
        this.VideoEncodeConfig = VideoEncodeConfig;
    }

    /**
     * Get Upper limit of the XR application resolution.If the project concurrency type is L or L2, the upper limit is 5000; if the project concurrency type is XL2, the upper limit is 6000.Note: This field may return null, indicating that no valid values can be obtained. 
     * @return XRMaxWidth Upper limit of the XR application resolution.If the project concurrency type is L or L2, the upper limit is 5000; if the project concurrency type is XL2, the upper limit is 6000.Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Long getXRMaxWidth() {
        return this.XRMaxWidth;
    }

    /**
     * Set Upper limit of the XR application resolution.If the project concurrency type is L or L2, the upper limit is 5000; if the project concurrency type is XL2, the upper limit is 6000.Note: This field may return null, indicating that no valid values can be obtained.
     * @param XRMaxWidth Upper limit of the XR application resolution.If the project concurrency type is L or L2, the upper limit is 5000; if the project concurrency type is XL2, the upper limit is 6000.Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setXRMaxWidth(Long XRMaxWidth) {
        this.XRMaxWidth = XRMaxWidth;
    }

    /**
     * Get Background image information.Note: This field may return null, indicating that no valid values can be obtained. 
     * @return BackgroundImage Background image information.Note: This field may return null, indicating that no valid values can be obtained.
     */
    public BackgroundImage getBackgroundImage() {
        return this.BackgroundImage;
    }

    /**
     * Set Background image information.Note: This field may return null, indicating that no valid values can be obtained.
     * @param BackgroundImage Background image information.Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setBackgroundImage(BackgroundImage BackgroundImage) {
        this.BackgroundImage = BackgroundImage;
    }

    /**
     * Get Disabled code list.Note: This field may return null, indicating that no valid values can be obtained. 
     * @return DisableVideoCodecs Disabled code list.Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String [] getDisableVideoCodecs() {
        return this.DisableVideoCodecs;
    }

    /**
     * Set Disabled code list.Note: This field may return null, indicating that no valid values can be obtained.
     * @param DisableVideoCodecs Disabled code list.Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setDisableVideoCodecs(String [] DisableVideoCodecs) {
        this.DisableVideoCodecs = DisableVideoCodecs;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeApplicationProjectAdvancedConfigResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeApplicationProjectAdvancedConfigResponse(DescribeApplicationProjectAdvancedConfigResponse source) {
        if (source.ApplicationParams != null) {
            this.ApplicationParams = new String(source.ApplicationParams);
        }
        if (source.Resolution != null) {
            this.Resolution = new String(source.Resolution);
        }
        if (source.FPS != null) {
            this.FPS = new Long(source.FPS);
        }
        if (source.MinBitrate != null) {
            this.MinBitrate = new Long(source.MinBitrate);
        }
        if (source.MaxBitrate != null) {
            this.MaxBitrate = new Long(source.MaxBitrate);
        }
        if (source.PreloadDuration != null) {
            this.PreloadDuration = new String(source.PreloadDuration);
        }
        if (source.ReconnectTimeout != null) {
            this.ReconnectTimeout = new String(source.ReconnectTimeout);
        }
        if (source.UpstreamAudioOption != null) {
            this.UpstreamAudioOption = new String(source.UpstreamAudioOption);
        }
        if (source.VideoEncodeConfig != null) {
            this.VideoEncodeConfig = new VideoEncodeConfig(source.VideoEncodeConfig);
        }
        if (source.XRMaxWidth != null) {
            this.XRMaxWidth = new Long(source.XRMaxWidth);
        }
        if (source.BackgroundImage != null) {
            this.BackgroundImage = new BackgroundImage(source.BackgroundImage);
        }
        if (source.DisableVideoCodecs != null) {
            this.DisableVideoCodecs = new String[source.DisableVideoCodecs.length];
            for (int i = 0; i < source.DisableVideoCodecs.length; i++) {
                this.DisableVideoCodecs[i] = new String(source.DisableVideoCodecs[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "ApplicationParams", this.ApplicationParams);
        this.setParamSimple(map, prefix + "Resolution", this.Resolution);
        this.setParamSimple(map, prefix + "FPS", this.FPS);
        this.setParamSimple(map, prefix + "MinBitrate", this.MinBitrate);
        this.setParamSimple(map, prefix + "MaxBitrate", this.MaxBitrate);
        this.setParamSimple(map, prefix + "PreloadDuration", this.PreloadDuration);
        this.setParamSimple(map, prefix + "ReconnectTimeout", this.ReconnectTimeout);
        this.setParamSimple(map, prefix + "UpstreamAudioOption", this.UpstreamAudioOption);
        this.setParamObj(map, prefix + "VideoEncodeConfig.", this.VideoEncodeConfig);
        this.setParamSimple(map, prefix + "XRMaxWidth", this.XRMaxWidth);
        this.setParamObj(map, prefix + "BackgroundImage.", this.BackgroundImage);
        this.setParamArraySimple(map, prefix + "DisableVideoCodecs.", this.DisableVideoCodecs);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

