/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.car.v20220110.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeConcurrentSummaryResponse extends AbstractModel {

    /**
    * Total number of prepaid (monthly subscription) concurrencies.
    */
    @SerializedName("PrepaidConcurrentTotal")
    @Expose
    private Long PrepaidConcurrentTotal;

    /**
    * Remaining duration of an hourly package.
    */
    @SerializedName("HourlyRemainDuration")
    @Expose
    private String HourlyRemainDuration;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Total number of prepaid (monthly subscription) concurrencies. 
     * @return PrepaidConcurrentTotal Total number of prepaid (monthly subscription) concurrencies.
     */
    public Long getPrepaidConcurrentTotal() {
        return this.PrepaidConcurrentTotal;
    }

    /**
     * Set Total number of prepaid (monthly subscription) concurrencies.
     * @param PrepaidConcurrentTotal Total number of prepaid (monthly subscription) concurrencies.
     */
    public void setPrepaidConcurrentTotal(Long PrepaidConcurrentTotal) {
        this.PrepaidConcurrentTotal = PrepaidConcurrentTotal;
    }

    /**
     * Get Remaining duration of an hourly package. 
     * @return HourlyRemainDuration Remaining duration of an hourly package.
     */
    public String getHourlyRemainDuration() {
        return this.HourlyRemainDuration;
    }

    /**
     * Set Remaining duration of an hourly package.
     * @param HourlyRemainDuration Remaining duration of an hourly package.
     */
    public void setHourlyRemainDuration(String HourlyRemainDuration) {
        this.HourlyRemainDuration = HourlyRemainDuration;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeConcurrentSummaryResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeConcurrentSummaryResponse(DescribeConcurrentSummaryResponse source) {
        if (source.PrepaidConcurrentTotal != null) {
            this.PrepaidConcurrentTotal = new Long(source.PrepaidConcurrentTotal);
        }
        if (source.HourlyRemainDuration != null) {
            this.HourlyRemainDuration = new String(source.HourlyRemainDuration);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "PrepaidConcurrentTotal", this.PrepaidConcurrentTotal);
        this.setParamSimple(map, prefix + "HourlyRemainDuration", this.HourlyRemainDuration);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

