/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.ccc.v20200210.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeAgentCruiseDialingCampaignResponse extends AbstractModel {

    /**
    * Task name.
    */
    @SerializedName("Name")
    @Expose
    private String Name;

    /**
    * Agent account.
    */
    @SerializedName("Agent")
    @Expose
    private String Agent;

    /**
    * Single-Round concurrent call volume 1-20.
    */
    @SerializedName("ConcurrencyNumber")
    @Expose
    private Long ConcurrencyNumber;

    /**
    * Task start time. unix timestamp. the task will automatically start after this time.
    */
    @SerializedName("StartTime")
    @Expose
    private Long StartTime;

    /**
    * Task termination time. unix timestamp. the task will automatically terminate after this time.
    */
    @SerializedName("EndTime")
    @Expose
    private Long EndTime;

    /**
    * Being called sequence: 0 for random 1 for in order.
    */
    @SerializedName("CallOrder")
    @Expose
    private Long CallOrder;

    /**
    * Caller custom data, maximum length 1024.
    */
    @SerializedName("UUI")
    @Expose
    private String UUI;

    /**
    * Task status 0 not started 1 running 2 completed 3 terminated.
    */
    @SerializedName("State")
    @Expose
    private Long State;

    /**
    * Total number of called parties.
    */
    @SerializedName("TotalCalleeCount")
    @Expose
    private Long TotalCalleeCount;

    /**
    * Number of calls made and received.
    */
    @SerializedName("CalledCalleeCount")
    @Expose
    private Long CalledCalleeCount;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Task name. 
     * @return Name Task name.
     */
    public String getName() {
        return this.Name;
    }

    /**
     * Set Task name.
     * @param Name Task name.
     */
    public void setName(String Name) {
        this.Name = Name;
    }

    /**
     * Get Agent account. 
     * @return Agent Agent account.
     */
    public String getAgent() {
        return this.Agent;
    }

    /**
     * Set Agent account.
     * @param Agent Agent account.
     */
    public void setAgent(String Agent) {
        this.Agent = Agent;
    }

    /**
     * Get Single-Round concurrent call volume 1-20. 
     * @return ConcurrencyNumber Single-Round concurrent call volume 1-20.
     */
    public Long getConcurrencyNumber() {
        return this.ConcurrencyNumber;
    }

    /**
     * Set Single-Round concurrent call volume 1-20.
     * @param ConcurrencyNumber Single-Round concurrent call volume 1-20.
     */
    public void setConcurrencyNumber(Long ConcurrencyNumber) {
        this.ConcurrencyNumber = ConcurrencyNumber;
    }

    /**
     * Get Task start time. unix timestamp. the task will automatically start after this time. 
     * @return StartTime Task start time. unix timestamp. the task will automatically start after this time.
     */
    public Long getStartTime() {
        return this.StartTime;
    }

    /**
     * Set Task start time. unix timestamp. the task will automatically start after this time.
     * @param StartTime Task start time. unix timestamp. the task will automatically start after this time.
     */
    public void setStartTime(Long StartTime) {
        this.StartTime = StartTime;
    }

    /**
     * Get Task termination time. unix timestamp. the task will automatically terminate after this time. 
     * @return EndTime Task termination time. unix timestamp. the task will automatically terminate after this time.
     */
    public Long getEndTime() {
        return this.EndTime;
    }

    /**
     * Set Task termination time. unix timestamp. the task will automatically terminate after this time.
     * @param EndTime Task termination time. unix timestamp. the task will automatically terminate after this time.
     */
    public void setEndTime(Long EndTime) {
        this.EndTime = EndTime;
    }

    /**
     * Get Being called sequence: 0 for random 1 for in order. 
     * @return CallOrder Being called sequence: 0 for random 1 for in order.
     */
    public Long getCallOrder() {
        return this.CallOrder;
    }

    /**
     * Set Being called sequence: 0 for random 1 for in order.
     * @param CallOrder Being called sequence: 0 for random 1 for in order.
     */
    public void setCallOrder(Long CallOrder) {
        this.CallOrder = CallOrder;
    }

    /**
     * Get Caller custom data, maximum length 1024. 
     * @return UUI Caller custom data, maximum length 1024.
     */
    public String getUUI() {
        return this.UUI;
    }

    /**
     * Set Caller custom data, maximum length 1024.
     * @param UUI Caller custom data, maximum length 1024.
     */
    public void setUUI(String UUI) {
        this.UUI = UUI;
    }

    /**
     * Get Task status 0 not started 1 running 2 completed 3 terminated. 
     * @return State Task status 0 not started 1 running 2 completed 3 terminated.
     */
    public Long getState() {
        return this.State;
    }

    /**
     * Set Task status 0 not started 1 running 2 completed 3 terminated.
     * @param State Task status 0 not started 1 running 2 completed 3 terminated.
     */
    public void setState(Long State) {
        this.State = State;
    }

    /**
     * Get Total number of called parties. 
     * @return TotalCalleeCount Total number of called parties.
     */
    public Long getTotalCalleeCount() {
        return this.TotalCalleeCount;
    }

    /**
     * Set Total number of called parties.
     * @param TotalCalleeCount Total number of called parties.
     */
    public void setTotalCalleeCount(Long TotalCalleeCount) {
        this.TotalCalleeCount = TotalCalleeCount;
    }

    /**
     * Get Number of calls made and received. 
     * @return CalledCalleeCount Number of calls made and received.
     */
    public Long getCalledCalleeCount() {
        return this.CalledCalleeCount;
    }

    /**
     * Set Number of calls made and received.
     * @param CalledCalleeCount Number of calls made and received.
     */
    public void setCalledCalleeCount(Long CalledCalleeCount) {
        this.CalledCalleeCount = CalledCalleeCount;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeAgentCruiseDialingCampaignResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeAgentCruiseDialingCampaignResponse(DescribeAgentCruiseDialingCampaignResponse source) {
        if (source.Name != null) {
            this.Name = new String(source.Name);
        }
        if (source.Agent != null) {
            this.Agent = new String(source.Agent);
        }
        if (source.ConcurrencyNumber != null) {
            this.ConcurrencyNumber = new Long(source.ConcurrencyNumber);
        }
        if (source.StartTime != null) {
            this.StartTime = new Long(source.StartTime);
        }
        if (source.EndTime != null) {
            this.EndTime = new Long(source.EndTime);
        }
        if (source.CallOrder != null) {
            this.CallOrder = new Long(source.CallOrder);
        }
        if (source.UUI != null) {
            this.UUI = new String(source.UUI);
        }
        if (source.State != null) {
            this.State = new Long(source.State);
        }
        if (source.TotalCalleeCount != null) {
            this.TotalCalleeCount = new Long(source.TotalCalleeCount);
        }
        if (source.CalledCalleeCount != null) {
            this.CalledCalleeCount = new Long(source.CalledCalleeCount);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Name", this.Name);
        this.setParamSimple(map, prefix + "Agent", this.Agent);
        this.setParamSimple(map, prefix + "ConcurrencyNumber", this.ConcurrencyNumber);
        this.setParamSimple(map, prefix + "StartTime", this.StartTime);
        this.setParamSimple(map, prefix + "EndTime", this.EndTime);
        this.setParamSimple(map, prefix + "CallOrder", this.CallOrder);
        this.setParamSimple(map, prefix + "UUI", this.UUI);
        this.setParamSimple(map, prefix + "State", this.State);
        this.setParamSimple(map, prefix + "TotalCalleeCount", this.TotalCalleeCount);
        this.setParamSimple(map, prefix + "CalledCalleeCount", this.CalledCalleeCount);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

