/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.ccc.v20200210.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeAutoCalloutTaskResponse extends AbstractModel {

    /**
    * Task name.
    */
    @SerializedName("Name")
    @Expose
    private String Name;

    /**
    * <Task description>.
    */
    @SerializedName("Description")
    @Expose
    private String Description;

    /**
    * Task start timestamp.
    */
    @SerializedName("NotBefore")
    @Expose
    private Long NotBefore;

    /**
    * Task end timestamp.
Note: this field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("NotAfter")
    @Expose
    private Long NotAfter;

    /**
    * Calling list.
    */
    @SerializedName("Callers")
    @Expose
    private String [] Callers;

    /**
    * Called information list.
    */
    @SerializedName("Callees")
    @Expose
    private AutoCalloutTaskCalleeInfo [] Callees;

    /**
    * IvrId used by the task.
    */
    @SerializedName("IvrId")
    @Expose
    private Long IvrId;

    /**
    * Task status: 0 - initial, 1 - running, 2 - completed, 3 - ending, 4 - terminated.
    */
    @SerializedName("State")
    @Expose
    private Long State;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Task name. 
     * @return Name Task name.
     */
    public String getName() {
        return this.Name;
    }

    /**
     * Set Task name.
     * @param Name Task name.
     */
    public void setName(String Name) {
        this.Name = Name;
    }

    /**
     * Get <Task description>. 
     * @return Description <Task description>.
     */
    public String getDescription() {
        return this.Description;
    }

    /**
     * Set <Task description>.
     * @param Description <Task description>.
     */
    public void setDescription(String Description) {
        this.Description = Description;
    }

    /**
     * Get Task start timestamp. 
     * @return NotBefore Task start timestamp.
     */
    public Long getNotBefore() {
        return this.NotBefore;
    }

    /**
     * Set Task start timestamp.
     * @param NotBefore Task start timestamp.
     */
    public void setNotBefore(Long NotBefore) {
        this.NotBefore = NotBefore;
    }

    /**
     * Get Task end timestamp.
Note: this field may return null, indicating that no valid values can be obtained. 
     * @return NotAfter Task end timestamp.
Note: this field may return null, indicating that no valid values can be obtained.
     */
    public Long getNotAfter() {
        return this.NotAfter;
    }

    /**
     * Set Task end timestamp.
Note: this field may return null, indicating that no valid values can be obtained.
     * @param NotAfter Task end timestamp.
Note: this field may return null, indicating that no valid values can be obtained.
     */
    public void setNotAfter(Long NotAfter) {
        this.NotAfter = NotAfter;
    }

    /**
     * Get Calling list. 
     * @return Callers Calling list.
     */
    public String [] getCallers() {
        return this.Callers;
    }

    /**
     * Set Calling list.
     * @param Callers Calling list.
     */
    public void setCallers(String [] Callers) {
        this.Callers = Callers;
    }

    /**
     * Get Called information list. 
     * @return Callees Called information list.
     */
    public AutoCalloutTaskCalleeInfo [] getCallees() {
        return this.Callees;
    }

    /**
     * Set Called information list.
     * @param Callees Called information list.
     */
    public void setCallees(AutoCalloutTaskCalleeInfo [] Callees) {
        this.Callees = Callees;
    }

    /**
     * Get IvrId used by the task. 
     * @return IvrId IvrId used by the task.
     */
    public Long getIvrId() {
        return this.IvrId;
    }

    /**
     * Set IvrId used by the task.
     * @param IvrId IvrId used by the task.
     */
    public void setIvrId(Long IvrId) {
        this.IvrId = IvrId;
    }

    /**
     * Get Task status: 0 - initial, 1 - running, 2 - completed, 3 - ending, 4 - terminated. 
     * @return State Task status: 0 - initial, 1 - running, 2 - completed, 3 - ending, 4 - terminated.
     */
    public Long getState() {
        return this.State;
    }

    /**
     * Set Task status: 0 - initial, 1 - running, 2 - completed, 3 - ending, 4 - terminated.
     * @param State Task status: 0 - initial, 1 - running, 2 - completed, 3 - ending, 4 - terminated.
     */
    public void setState(Long State) {
        this.State = State;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeAutoCalloutTaskResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeAutoCalloutTaskResponse(DescribeAutoCalloutTaskResponse source) {
        if (source.Name != null) {
            this.Name = new String(source.Name);
        }
        if (source.Description != null) {
            this.Description = new String(source.Description);
        }
        if (source.NotBefore != null) {
            this.NotBefore = new Long(source.NotBefore);
        }
        if (source.NotAfter != null) {
            this.NotAfter = new Long(source.NotAfter);
        }
        if (source.Callers != null) {
            this.Callers = new String[source.Callers.length];
            for (int i = 0; i < source.Callers.length; i++) {
                this.Callers[i] = new String(source.Callers[i]);
            }
        }
        if (source.Callees != null) {
            this.Callees = new AutoCalloutTaskCalleeInfo[source.Callees.length];
            for (int i = 0; i < source.Callees.length; i++) {
                this.Callees[i] = new AutoCalloutTaskCalleeInfo(source.Callees[i]);
            }
        }
        if (source.IvrId != null) {
            this.IvrId = new Long(source.IvrId);
        }
        if (source.State != null) {
            this.State = new Long(source.State);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Name", this.Name);
        this.setParamSimple(map, prefix + "Description", this.Description);
        this.setParamSimple(map, prefix + "NotBefore", this.NotBefore);
        this.setParamSimple(map, prefix + "NotAfter", this.NotAfter);
        this.setParamArraySimple(map, prefix + "Callers.", this.Callers);
        this.setParamArrayObj(map, prefix + "Callees.", this.Callees);
        this.setParamSimple(map, prefix + "IvrId", this.IvrId);
        this.setParamSimple(map, prefix + "State", this.State);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

