/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.ccc.v20200210.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeCCCBuyInfoListResponse extends AbstractModel {

    /**
    * Total number of applications.
    */
    @SerializedName("TotalCount")
    @Expose
    private Long TotalCount;

    /**
    * Application purchase information list.
    */
    @SerializedName("SdkAppIdBuyList")
    @Expose
    private SdkAppIdBuyInfo [] SdkAppIdBuyList;

    /**
    * Package purchase information list.
    */
    @SerializedName("PackageBuyList")
    @Expose
    private PackageBuyInfo [] PackageBuyList;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Total number of applications. 
     * @return TotalCount Total number of applications.
     */
    public Long getTotalCount() {
        return this.TotalCount;
    }

    /**
     * Set Total number of applications.
     * @param TotalCount Total number of applications.
     */
    public void setTotalCount(Long TotalCount) {
        this.TotalCount = TotalCount;
    }

    /**
     * Get Application purchase information list. 
     * @return SdkAppIdBuyList Application purchase information list.
     */
    public SdkAppIdBuyInfo [] getSdkAppIdBuyList() {
        return this.SdkAppIdBuyList;
    }

    /**
     * Set Application purchase information list.
     * @param SdkAppIdBuyList Application purchase information list.
     */
    public void setSdkAppIdBuyList(SdkAppIdBuyInfo [] SdkAppIdBuyList) {
        this.SdkAppIdBuyList = SdkAppIdBuyList;
    }

    /**
     * Get Package purchase information list. 
     * @return PackageBuyList Package purchase information list.
     */
    public PackageBuyInfo [] getPackageBuyList() {
        return this.PackageBuyList;
    }

    /**
     * Set Package purchase information list.
     * @param PackageBuyList Package purchase information list.
     */
    public void setPackageBuyList(PackageBuyInfo [] PackageBuyList) {
        this.PackageBuyList = PackageBuyList;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeCCCBuyInfoListResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeCCCBuyInfoListResponse(DescribeCCCBuyInfoListResponse source) {
        if (source.TotalCount != null) {
            this.TotalCount = new Long(source.TotalCount);
        }
        if (source.SdkAppIdBuyList != null) {
            this.SdkAppIdBuyList = new SdkAppIdBuyInfo[source.SdkAppIdBuyList.length];
            for (int i = 0; i < source.SdkAppIdBuyList.length; i++) {
                this.SdkAppIdBuyList[i] = new SdkAppIdBuyInfo(source.SdkAppIdBuyList[i]);
            }
        }
        if (source.PackageBuyList != null) {
            this.PackageBuyList = new PackageBuyInfo[source.PackageBuyList.length];
            for (int i = 0; i < source.PackageBuyList.length; i++) {
                this.PackageBuyList[i] = new PackageBuyInfo(source.PackageBuyList[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "TotalCount", this.TotalCount);
        this.setParamArrayObj(map, prefix + "SdkAppIdBuyList.", this.SdkAppIdBuyList);
        this.setParamArrayObj(map, prefix + "PackageBuyList.", this.PackageBuyList);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

