/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.ccc.v20200210.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeCallInMetricsResponse extends AbstractModel {

    /**
    * Timestamp.
    */
    @SerializedName("Timestamp")
    @Expose
    private Long Timestamp;

    /**
    * Overall metrics.
    */
    @SerializedName("TotalMetrics")
    @Expose
    private CallInMetrics TotalMetrics;

    /**
    * Circuit dimension metrics.
    */
    @SerializedName("NumberMetrics")
    @Expose
    private CallInNumberMetrics [] NumberMetrics;

    /**
    * Skill group dimension metrics.
    */
    @SerializedName("SkillGroupMetrics")
    @Expose
    private CallInSkillGroupMetrics [] SkillGroupMetrics;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Timestamp. 
     * @return Timestamp Timestamp.
     */
    public Long getTimestamp() {
        return this.Timestamp;
    }

    /**
     * Set Timestamp.
     * @param Timestamp Timestamp.
     */
    public void setTimestamp(Long Timestamp) {
        this.Timestamp = Timestamp;
    }

    /**
     * Get Overall metrics. 
     * @return TotalMetrics Overall metrics.
     */
    public CallInMetrics getTotalMetrics() {
        return this.TotalMetrics;
    }

    /**
     * Set Overall metrics.
     * @param TotalMetrics Overall metrics.
     */
    public void setTotalMetrics(CallInMetrics TotalMetrics) {
        this.TotalMetrics = TotalMetrics;
    }

    /**
     * Get Circuit dimension metrics. 
     * @return NumberMetrics Circuit dimension metrics.
     */
    public CallInNumberMetrics [] getNumberMetrics() {
        return this.NumberMetrics;
    }

    /**
     * Set Circuit dimension metrics.
     * @param NumberMetrics Circuit dimension metrics.
     */
    public void setNumberMetrics(CallInNumberMetrics [] NumberMetrics) {
        this.NumberMetrics = NumberMetrics;
    }

    /**
     * Get Skill group dimension metrics. 
     * @return SkillGroupMetrics Skill group dimension metrics.
     */
    public CallInSkillGroupMetrics [] getSkillGroupMetrics() {
        return this.SkillGroupMetrics;
    }

    /**
     * Set Skill group dimension metrics.
     * @param SkillGroupMetrics Skill group dimension metrics.
     */
    public void setSkillGroupMetrics(CallInSkillGroupMetrics [] SkillGroupMetrics) {
        this.SkillGroupMetrics = SkillGroupMetrics;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeCallInMetricsResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeCallInMetricsResponse(DescribeCallInMetricsResponse source) {
        if (source.Timestamp != null) {
            this.Timestamp = new Long(source.Timestamp);
        }
        if (source.TotalMetrics != null) {
            this.TotalMetrics = new CallInMetrics(source.TotalMetrics);
        }
        if (source.NumberMetrics != null) {
            this.NumberMetrics = new CallInNumberMetrics[source.NumberMetrics.length];
            for (int i = 0; i < source.NumberMetrics.length; i++) {
                this.NumberMetrics[i] = new CallInNumberMetrics(source.NumberMetrics[i]);
            }
        }
        if (source.SkillGroupMetrics != null) {
            this.SkillGroupMetrics = new CallInSkillGroupMetrics[source.SkillGroupMetrics.length];
            for (int i = 0; i < source.SkillGroupMetrics.length; i++) {
                this.SkillGroupMetrics[i] = new CallInSkillGroupMetrics(source.SkillGroupMetrics[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Timestamp", this.Timestamp);
        this.setParamObj(map, prefix + "TotalMetrics.", this.TotalMetrics);
        this.setParamArrayObj(map, prefix + "NumberMetrics.", this.NumberMetrics);
        this.setParamArrayObj(map, prefix + "SkillGroupMetrics.", this.SkillGroupMetrics);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

