/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.ccc.v20200210.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeExtensionResponse extends AbstractModel {

    /**
    * Extension.
    */
    @SerializedName("ExtensionId")
    @Expose
    private String ExtensionId;

    /**
    * Domain name.
    */
    @SerializedName("ExtensionDomain")
    @Expose
    private String ExtensionDomain;

    /**
    * Registered password.
    */
    @SerializedName("Password")
    @Expose
    private String Password;

    /**
    * Proxy server address.
    */
    @SerializedName("OutboundProxy")
    @Expose
    private String OutboundProxy;

    /**
    * Transfer protocol.
    */
    @SerializedName("Transport")
    @Expose
    private String Transport;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Extension. 
     * @return ExtensionId Extension.
     */
    public String getExtensionId() {
        return this.ExtensionId;
    }

    /**
     * Set Extension.
     * @param ExtensionId Extension.
     */
    public void setExtensionId(String ExtensionId) {
        this.ExtensionId = ExtensionId;
    }

    /**
     * Get Domain name. 
     * @return ExtensionDomain Domain name.
     */
    public String getExtensionDomain() {
        return this.ExtensionDomain;
    }

    /**
     * Set Domain name.
     * @param ExtensionDomain Domain name.
     */
    public void setExtensionDomain(String ExtensionDomain) {
        this.ExtensionDomain = ExtensionDomain;
    }

    /**
     * Get Registered password. 
     * @return Password Registered password.
     */
    public String getPassword() {
        return this.Password;
    }

    /**
     * Set Registered password.
     * @param Password Registered password.
     */
    public void setPassword(String Password) {
        this.Password = Password;
    }

    /**
     * Get Proxy server address. 
     * @return OutboundProxy Proxy server address.
     */
    public String getOutboundProxy() {
        return this.OutboundProxy;
    }

    /**
     * Set Proxy server address.
     * @param OutboundProxy Proxy server address.
     */
    public void setOutboundProxy(String OutboundProxy) {
        this.OutboundProxy = OutboundProxy;
    }

    /**
     * Get Transfer protocol. 
     * @return Transport Transfer protocol.
     */
    public String getTransport() {
        return this.Transport;
    }

    /**
     * Set Transfer protocol.
     * @param Transport Transfer protocol.
     */
    public void setTransport(String Transport) {
        this.Transport = Transport;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeExtensionResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeExtensionResponse(DescribeExtensionResponse source) {
        if (source.ExtensionId != null) {
            this.ExtensionId = new String(source.ExtensionId);
        }
        if (source.ExtensionDomain != null) {
            this.ExtensionDomain = new String(source.ExtensionDomain);
        }
        if (source.Password != null) {
            this.Password = new String(source.Password);
        }
        if (source.OutboundProxy != null) {
            this.OutboundProxy = new String(source.OutboundProxy);
        }
        if (source.Transport != null) {
            this.Transport = new String(source.Transport);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "ExtensionId", this.ExtensionId);
        this.setParamSimple(map, prefix + "ExtensionDomain", this.ExtensionDomain);
        this.setParamSimple(map, prefix + "Password", this.Password);
        this.setParamSimple(map, prefix + "OutboundProxy", this.OutboundProxy);
        this.setParamSimple(map, prefix + "Transport", this.Transport);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

