/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.ccc.v20200210.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeSessionDetailResponse extends AbstractModel {

    /**
    * Calling number.
    */
    @SerializedName("Caller")
    @Expose
    private String Caller;

    /**
    * Called number.
    */
    @SerializedName("Callee")
    @Expose
    private String Callee;

    /**
    * Call type. valid values: 1 (outgoing call), 2 (incoming call), 3 (audio dial-in), 5 (predictive outbound call), 6 (internal call).
    */
    @SerializedName("CallType")
    @Expose
    private Long CallType;

    /**
    * Start timestamp. Unix second-level timestamp.
    */
    @SerializedName("StartTimeStamp")
    @Expose
    private Long StartTimeStamp;

    /**
    * Ring timestamp. UNIX second-level timestamp.
    */
    @SerializedName("RingTimestamp")
    @Expose
    private Long RingTimestamp;

    /**
    * Answer timestamp. UNIX second-level timestamp.
    */
    @SerializedName("AcceptTimestamp")
    @Expose
    private Long AcceptTimestamp;

    /**
    * End timestamp, UNIX second-level timestamp.
    */
    @SerializedName("EndedTimestamp")
    @Expose
    private Long EndedTimestamp;

    /**
    * Queue entry time. Unix second-level timestamp.
    */
    @SerializedName("QueuedTimestamp")
    @Expose
    private Long QueuedTimestamp;

    /**
    * Agent account.
    */
    @SerializedName("StaffUserId")
    @Expose
    private String StaffUserId;

    /**
    * Refers to the EndStatus field in the DescribeTelCdr api.
    */
    @SerializedName("EndStatus")
    @Expose
    private Long EndStatus;

    /**
    * Queue skill group ID.
    */
    @SerializedName("QueuedSkillGroupId")
    @Expose
    private Long QueuedSkillGroupId;

    /**
    * Queue skill group name.
    */
    @SerializedName("QueuedSkillGroupName")
    @Expose
    private String QueuedSkillGroupName;

    /**
    * Recording url with authentication and valid period. obtain and pull within a short time frame. do not persist this link.
    */
    @SerializedName("RecordURL")
    @Expose
    private String RecordURL;

    /**
    * Specifies the COS link for recording transfer to a third party.
    */
    @SerializedName("CustomRecordURL")
    @Expose
    private String CustomRecordURL;

    /**
    * Recording text information link with authentication and valid period. retrieve it within a short time frame. do not persist this link.
    */
    @SerializedName("AsrURL")
    @Expose
    private String AsrURL;

    /**
    * Voicemail recording url.
    */
    @SerializedName("VoicemailRecordURL")
    @Expose
    private String [] VoicemailRecordURL;

    /**
    * Voicemail recording text information url. purchase the offline speech recognition package through the console and enable the offline speech recognition switch.
    */
    @SerializedName("VoicemailAsrURL")
    @Expose
    private String [] VoicemailAsrURL;

    /**
    * IVR key information.
    */
    @SerializedName("IVRKeyPressed")
    @Expose
    private IVRKeyPressedElement [] IVRKeyPressed;

    /**
    * Satisfaction rate keystroke information.
    */
    @SerializedName("PostIVRKeyPressed")
    @Expose
    private IVRKeyPressedElement [] PostIVRKeyPressed;

    /**
    * Hang-Up side. valid values: seat, user, system.
    */
    @SerializedName("HungUpSide")
    @Expose
    private String HungUpSide;

    /**
    * Customer custom data (User-to-User Interface).
    */
    @SerializedName("UUI")
    @Expose
    private String UUI;

    /**
    * List of events during a call.
    */
    @SerializedName("Events")
    @Expose
    private SessionEvent [] Events;

    /**
    * List of service participants.
    */
    @SerializedName("ServeParticipants")
    @Expose
    private ServeParticipant [] ServeParticipants;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Calling number. 
     * @return Caller Calling number.
     */
    public String getCaller() {
        return this.Caller;
    }

    /**
     * Set Calling number.
     * @param Caller Calling number.
     */
    public void setCaller(String Caller) {
        this.Caller = Caller;
    }

    /**
     * Get Called number. 
     * @return Callee Called number.
     */
    public String getCallee() {
        return this.Callee;
    }

    /**
     * Set Called number.
     * @param Callee Called number.
     */
    public void setCallee(String Callee) {
        this.Callee = Callee;
    }

    /**
     * Get Call type. valid values: 1 (outgoing call), 2 (incoming call), 3 (audio dial-in), 5 (predictive outbound call), 6 (internal call). 
     * @return CallType Call type. valid values: 1 (outgoing call), 2 (incoming call), 3 (audio dial-in), 5 (predictive outbound call), 6 (internal call).
     */
    public Long getCallType() {
        return this.CallType;
    }

    /**
     * Set Call type. valid values: 1 (outgoing call), 2 (incoming call), 3 (audio dial-in), 5 (predictive outbound call), 6 (internal call).
     * @param CallType Call type. valid values: 1 (outgoing call), 2 (incoming call), 3 (audio dial-in), 5 (predictive outbound call), 6 (internal call).
     */
    public void setCallType(Long CallType) {
        this.CallType = CallType;
    }

    /**
     * Get Start timestamp. Unix second-level timestamp. 
     * @return StartTimeStamp Start timestamp. Unix second-level timestamp.
     */
    public Long getStartTimeStamp() {
        return this.StartTimeStamp;
    }

    /**
     * Set Start timestamp. Unix second-level timestamp.
     * @param StartTimeStamp Start timestamp. Unix second-level timestamp.
     */
    public void setStartTimeStamp(Long StartTimeStamp) {
        this.StartTimeStamp = StartTimeStamp;
    }

    /**
     * Get Ring timestamp. UNIX second-level timestamp. 
     * @return RingTimestamp Ring timestamp. UNIX second-level timestamp.
     */
    public Long getRingTimestamp() {
        return this.RingTimestamp;
    }

    /**
     * Set Ring timestamp. UNIX second-level timestamp.
     * @param RingTimestamp Ring timestamp. UNIX second-level timestamp.
     */
    public void setRingTimestamp(Long RingTimestamp) {
        this.RingTimestamp = RingTimestamp;
    }

    /**
     * Get Answer timestamp. UNIX second-level timestamp. 
     * @return AcceptTimestamp Answer timestamp. UNIX second-level timestamp.
     */
    public Long getAcceptTimestamp() {
        return this.AcceptTimestamp;
    }

    /**
     * Set Answer timestamp. UNIX second-level timestamp.
     * @param AcceptTimestamp Answer timestamp. UNIX second-level timestamp.
     */
    public void setAcceptTimestamp(Long AcceptTimestamp) {
        this.AcceptTimestamp = AcceptTimestamp;
    }

    /**
     * Get End timestamp, UNIX second-level timestamp. 
     * @return EndedTimestamp End timestamp, UNIX second-level timestamp.
     */
    public Long getEndedTimestamp() {
        return this.EndedTimestamp;
    }

    /**
     * Set End timestamp, UNIX second-level timestamp.
     * @param EndedTimestamp End timestamp, UNIX second-level timestamp.
     */
    public void setEndedTimestamp(Long EndedTimestamp) {
        this.EndedTimestamp = EndedTimestamp;
    }

    /**
     * Get Queue entry time. Unix second-level timestamp. 
     * @return QueuedTimestamp Queue entry time. Unix second-level timestamp.
     */
    public Long getQueuedTimestamp() {
        return this.QueuedTimestamp;
    }

    /**
     * Set Queue entry time. Unix second-level timestamp.
     * @param QueuedTimestamp Queue entry time. Unix second-level timestamp.
     */
    public void setQueuedTimestamp(Long QueuedTimestamp) {
        this.QueuedTimestamp = QueuedTimestamp;
    }

    /**
     * Get Agent account. 
     * @return StaffUserId Agent account.
     */
    public String getStaffUserId() {
        return this.StaffUserId;
    }

    /**
     * Set Agent account.
     * @param StaffUserId Agent account.
     */
    public void setStaffUserId(String StaffUserId) {
        this.StaffUserId = StaffUserId;
    }

    /**
     * Get Refers to the EndStatus field in the DescribeTelCdr api. 
     * @return EndStatus Refers to the EndStatus field in the DescribeTelCdr api.
     */
    public Long getEndStatus() {
        return this.EndStatus;
    }

    /**
     * Set Refers to the EndStatus field in the DescribeTelCdr api.
     * @param EndStatus Refers to the EndStatus field in the DescribeTelCdr api.
     */
    public void setEndStatus(Long EndStatus) {
        this.EndStatus = EndStatus;
    }

    /**
     * Get Queue skill group ID. 
     * @return QueuedSkillGroupId Queue skill group ID.
     */
    public Long getQueuedSkillGroupId() {
        return this.QueuedSkillGroupId;
    }

    /**
     * Set Queue skill group ID.
     * @param QueuedSkillGroupId Queue skill group ID.
     */
    public void setQueuedSkillGroupId(Long QueuedSkillGroupId) {
        this.QueuedSkillGroupId = QueuedSkillGroupId;
    }

    /**
     * Get Queue skill group name. 
     * @return QueuedSkillGroupName Queue skill group name.
     */
    public String getQueuedSkillGroupName() {
        return this.QueuedSkillGroupName;
    }

    /**
     * Set Queue skill group name.
     * @param QueuedSkillGroupName Queue skill group name.
     */
    public void setQueuedSkillGroupName(String QueuedSkillGroupName) {
        this.QueuedSkillGroupName = QueuedSkillGroupName;
    }

    /**
     * Get Recording url with authentication and valid period. obtain and pull within a short time frame. do not persist this link. 
     * @return RecordURL Recording url with authentication and valid period. obtain and pull within a short time frame. do not persist this link.
     */
    public String getRecordURL() {
        return this.RecordURL;
    }

    /**
     * Set Recording url with authentication and valid period. obtain and pull within a short time frame. do not persist this link.
     * @param RecordURL Recording url with authentication and valid period. obtain and pull within a short time frame. do not persist this link.
     */
    public void setRecordURL(String RecordURL) {
        this.RecordURL = RecordURL;
    }

    /**
     * Get Specifies the COS link for recording transfer to a third party. 
     * @return CustomRecordURL Specifies the COS link for recording transfer to a third party.
     */
    public String getCustomRecordURL() {
        return this.CustomRecordURL;
    }

    /**
     * Set Specifies the COS link for recording transfer to a third party.
     * @param CustomRecordURL Specifies the COS link for recording transfer to a third party.
     */
    public void setCustomRecordURL(String CustomRecordURL) {
        this.CustomRecordURL = CustomRecordURL;
    }

    /**
     * Get Recording text information link with authentication and valid period. retrieve it within a short time frame. do not persist this link. 
     * @return AsrURL Recording text information link with authentication and valid period. retrieve it within a short time frame. do not persist this link.
     */
    public String getAsrURL() {
        return this.AsrURL;
    }

    /**
     * Set Recording text information link with authentication and valid period. retrieve it within a short time frame. do not persist this link.
     * @param AsrURL Recording text information link with authentication and valid period. retrieve it within a short time frame. do not persist this link.
     */
    public void setAsrURL(String AsrURL) {
        this.AsrURL = AsrURL;
    }

    /**
     * Get Voicemail recording url. 
     * @return VoicemailRecordURL Voicemail recording url.
     */
    public String [] getVoicemailRecordURL() {
        return this.VoicemailRecordURL;
    }

    /**
     * Set Voicemail recording url.
     * @param VoicemailRecordURL Voicemail recording url.
     */
    public void setVoicemailRecordURL(String [] VoicemailRecordURL) {
        this.VoicemailRecordURL = VoicemailRecordURL;
    }

    /**
     * Get Voicemail recording text information url. purchase the offline speech recognition package through the console and enable the offline speech recognition switch. 
     * @return VoicemailAsrURL Voicemail recording text information url. purchase the offline speech recognition package through the console and enable the offline speech recognition switch.
     */
    public String [] getVoicemailAsrURL() {
        return this.VoicemailAsrURL;
    }

    /**
     * Set Voicemail recording text information url. purchase the offline speech recognition package through the console and enable the offline speech recognition switch.
     * @param VoicemailAsrURL Voicemail recording text information url. purchase the offline speech recognition package through the console and enable the offline speech recognition switch.
     */
    public void setVoicemailAsrURL(String [] VoicemailAsrURL) {
        this.VoicemailAsrURL = VoicemailAsrURL;
    }

    /**
     * Get IVR key information. 
     * @return IVRKeyPressed IVR key information.
     */
    public IVRKeyPressedElement [] getIVRKeyPressed() {
        return this.IVRKeyPressed;
    }

    /**
     * Set IVR key information.
     * @param IVRKeyPressed IVR key information.
     */
    public void setIVRKeyPressed(IVRKeyPressedElement [] IVRKeyPressed) {
        this.IVRKeyPressed = IVRKeyPressed;
    }

    /**
     * Get Satisfaction rate keystroke information. 
     * @return PostIVRKeyPressed Satisfaction rate keystroke information.
     */
    public IVRKeyPressedElement [] getPostIVRKeyPressed() {
        return this.PostIVRKeyPressed;
    }

    /**
     * Set Satisfaction rate keystroke information.
     * @param PostIVRKeyPressed Satisfaction rate keystroke information.
     */
    public void setPostIVRKeyPressed(IVRKeyPressedElement [] PostIVRKeyPressed) {
        this.PostIVRKeyPressed = PostIVRKeyPressed;
    }

    /**
     * Get Hang-Up side. valid values: seat, user, system. 
     * @return HungUpSide Hang-Up side. valid values: seat, user, system.
     */
    public String getHungUpSide() {
        return this.HungUpSide;
    }

    /**
     * Set Hang-Up side. valid values: seat, user, system.
     * @param HungUpSide Hang-Up side. valid values: seat, user, system.
     */
    public void setHungUpSide(String HungUpSide) {
        this.HungUpSide = HungUpSide;
    }

    /**
     * Get Customer custom data (User-to-User Interface). 
     * @return UUI Customer custom data (User-to-User Interface).
     */
    public String getUUI() {
        return this.UUI;
    }

    /**
     * Set Customer custom data (User-to-User Interface).
     * @param UUI Customer custom data (User-to-User Interface).
     */
    public void setUUI(String UUI) {
        this.UUI = UUI;
    }

    /**
     * Get List of events during a call. 
     * @return Events List of events during a call.
     */
    public SessionEvent [] getEvents() {
        return this.Events;
    }

    /**
     * Set List of events during a call.
     * @param Events List of events during a call.
     */
    public void setEvents(SessionEvent [] Events) {
        this.Events = Events;
    }

    /**
     * Get List of service participants. 
     * @return ServeParticipants List of service participants.
     */
    public ServeParticipant [] getServeParticipants() {
        return this.ServeParticipants;
    }

    /**
     * Set List of service participants.
     * @param ServeParticipants List of service participants.
     */
    public void setServeParticipants(ServeParticipant [] ServeParticipants) {
        this.ServeParticipants = ServeParticipants;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeSessionDetailResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeSessionDetailResponse(DescribeSessionDetailResponse source) {
        if (source.Caller != null) {
            this.Caller = new String(source.Caller);
        }
        if (source.Callee != null) {
            this.Callee = new String(source.Callee);
        }
        if (source.CallType != null) {
            this.CallType = new Long(source.CallType);
        }
        if (source.StartTimeStamp != null) {
            this.StartTimeStamp = new Long(source.StartTimeStamp);
        }
        if (source.RingTimestamp != null) {
            this.RingTimestamp = new Long(source.RingTimestamp);
        }
        if (source.AcceptTimestamp != null) {
            this.AcceptTimestamp = new Long(source.AcceptTimestamp);
        }
        if (source.EndedTimestamp != null) {
            this.EndedTimestamp = new Long(source.EndedTimestamp);
        }
        if (source.QueuedTimestamp != null) {
            this.QueuedTimestamp = new Long(source.QueuedTimestamp);
        }
        if (source.StaffUserId != null) {
            this.StaffUserId = new String(source.StaffUserId);
        }
        if (source.EndStatus != null) {
            this.EndStatus = new Long(source.EndStatus);
        }
        if (source.QueuedSkillGroupId != null) {
            this.QueuedSkillGroupId = new Long(source.QueuedSkillGroupId);
        }
        if (source.QueuedSkillGroupName != null) {
            this.QueuedSkillGroupName = new String(source.QueuedSkillGroupName);
        }
        if (source.RecordURL != null) {
            this.RecordURL = new String(source.RecordURL);
        }
        if (source.CustomRecordURL != null) {
            this.CustomRecordURL = new String(source.CustomRecordURL);
        }
        if (source.AsrURL != null) {
            this.AsrURL = new String(source.AsrURL);
        }
        if (source.VoicemailRecordURL != null) {
            this.VoicemailRecordURL = new String[source.VoicemailRecordURL.length];
            for (int i = 0; i < source.VoicemailRecordURL.length; i++) {
                this.VoicemailRecordURL[i] = new String(source.VoicemailRecordURL[i]);
            }
        }
        if (source.VoicemailAsrURL != null) {
            this.VoicemailAsrURL = new String[source.VoicemailAsrURL.length];
            for (int i = 0; i < source.VoicemailAsrURL.length; i++) {
                this.VoicemailAsrURL[i] = new String(source.VoicemailAsrURL[i]);
            }
        }
        if (source.IVRKeyPressed != null) {
            this.IVRKeyPressed = new IVRKeyPressedElement[source.IVRKeyPressed.length];
            for (int i = 0; i < source.IVRKeyPressed.length; i++) {
                this.IVRKeyPressed[i] = new IVRKeyPressedElement(source.IVRKeyPressed[i]);
            }
        }
        if (source.PostIVRKeyPressed != null) {
            this.PostIVRKeyPressed = new IVRKeyPressedElement[source.PostIVRKeyPressed.length];
            for (int i = 0; i < source.PostIVRKeyPressed.length; i++) {
                this.PostIVRKeyPressed[i] = new IVRKeyPressedElement(source.PostIVRKeyPressed[i]);
            }
        }
        if (source.HungUpSide != null) {
            this.HungUpSide = new String(source.HungUpSide);
        }
        if (source.UUI != null) {
            this.UUI = new String(source.UUI);
        }
        if (source.Events != null) {
            this.Events = new SessionEvent[source.Events.length];
            for (int i = 0; i < source.Events.length; i++) {
                this.Events[i] = new SessionEvent(source.Events[i]);
            }
        }
        if (source.ServeParticipants != null) {
            this.ServeParticipants = new ServeParticipant[source.ServeParticipants.length];
            for (int i = 0; i < source.ServeParticipants.length; i++) {
                this.ServeParticipants[i] = new ServeParticipant(source.ServeParticipants[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Caller", this.Caller);
        this.setParamSimple(map, prefix + "Callee", this.Callee);
        this.setParamSimple(map, prefix + "CallType", this.CallType);
        this.setParamSimple(map, prefix + "StartTimeStamp", this.StartTimeStamp);
        this.setParamSimple(map, prefix + "RingTimestamp", this.RingTimestamp);
        this.setParamSimple(map, prefix + "AcceptTimestamp", this.AcceptTimestamp);
        this.setParamSimple(map, prefix + "EndedTimestamp", this.EndedTimestamp);
        this.setParamSimple(map, prefix + "QueuedTimestamp", this.QueuedTimestamp);
        this.setParamSimple(map, prefix + "StaffUserId", this.StaffUserId);
        this.setParamSimple(map, prefix + "EndStatus", this.EndStatus);
        this.setParamSimple(map, prefix + "QueuedSkillGroupId", this.QueuedSkillGroupId);
        this.setParamSimple(map, prefix + "QueuedSkillGroupName", this.QueuedSkillGroupName);
        this.setParamSimple(map, prefix + "RecordURL", this.RecordURL);
        this.setParamSimple(map, prefix + "CustomRecordURL", this.CustomRecordURL);
        this.setParamSimple(map, prefix + "AsrURL", this.AsrURL);
        this.setParamArraySimple(map, prefix + "VoicemailRecordURL.", this.VoicemailRecordURL);
        this.setParamArraySimple(map, prefix + "VoicemailAsrURL.", this.VoicemailAsrURL);
        this.setParamArrayObj(map, prefix + "IVRKeyPressed.", this.IVRKeyPressed);
        this.setParamArrayObj(map, prefix + "PostIVRKeyPressed.", this.PostIVRKeyPressed);
        this.setParamSimple(map, prefix + "HungUpSide", this.HungUpSide);
        this.setParamSimple(map, prefix + "UUI", this.UUI);
        this.setParamArrayObj(map, prefix + "Events.", this.Events);
        this.setParamArrayObj(map, prefix + "ServeParticipants.", this.ServeParticipants);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

