/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.ccc.v20200210.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeTelCallInfoResponse extends AbstractModel {

    /**
    * Number of minutes consumed by outbound package.
    */
    @SerializedName("TelCallOutCount")
    @Expose
    private Long TelCallOutCount;

    /**
    * Number of minutes consumed by inbound package.
    */
    @SerializedName("TelCallInCount")
    @Expose
    private Long TelCallInCount;

    /**
    * Number of agent usage statistics.
    */
    @SerializedName("SeatUsedCount")
    @Expose
    private Long SeatUsedCount;

    /**
    * Number of minutes consumed by audio package.
    */
    @SerializedName("VoipCallInCount")
    @Expose
    private Long VoipCallInCount;

    /**
    * Number of minutes consumed by audio package.
    */
    @SerializedName("VOIPCallInCount")
    @Expose
    private Long VOIPCallInCount;

    /**
    * Number of minutes consumed by offline speech-to-text package.
    */
    @SerializedName("AsrOfflineCount")
    @Expose
    private Long AsrOfflineCount;

    /**
    * Number of minutes consumed by real-time speech-to-text package.
    */
    @SerializedName("AsrRealtimeCount")
    @Expose
    private Long AsrRealtimeCount;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Number of minutes consumed by outbound package. 
     * @return TelCallOutCount Number of minutes consumed by outbound package.
     */
    public Long getTelCallOutCount() {
        return this.TelCallOutCount;
    }

    /**
     * Set Number of minutes consumed by outbound package.
     * @param TelCallOutCount Number of minutes consumed by outbound package.
     */
    public void setTelCallOutCount(Long TelCallOutCount) {
        this.TelCallOutCount = TelCallOutCount;
    }

    /**
     * Get Number of minutes consumed by inbound package. 
     * @return TelCallInCount Number of minutes consumed by inbound package.
     */
    public Long getTelCallInCount() {
        return this.TelCallInCount;
    }

    /**
     * Set Number of minutes consumed by inbound package.
     * @param TelCallInCount Number of minutes consumed by inbound package.
     */
    public void setTelCallInCount(Long TelCallInCount) {
        this.TelCallInCount = TelCallInCount;
    }

    /**
     * Get Number of agent usage statistics. 
     * @return SeatUsedCount Number of agent usage statistics.
     */
    public Long getSeatUsedCount() {
        return this.SeatUsedCount;
    }

    /**
     * Set Number of agent usage statistics.
     * @param SeatUsedCount Number of agent usage statistics.
     */
    public void setSeatUsedCount(Long SeatUsedCount) {
        this.SeatUsedCount = SeatUsedCount;
    }

    /**
     * Get Number of minutes consumed by audio package. 
     * @return VoipCallInCount Number of minutes consumed by audio package.
     * @deprecated
     */
    @Deprecated
    public Long getVoipCallInCount() {
        return this.VoipCallInCount;
    }

    /**
     * Set Number of minutes consumed by audio package.
     * @param VoipCallInCount Number of minutes consumed by audio package.
     * @deprecated
     */
    @Deprecated
    public void setVoipCallInCount(Long VoipCallInCount) {
        this.VoipCallInCount = VoipCallInCount;
    }

    /**
     * Get Number of minutes consumed by audio package. 
     * @return VOIPCallInCount Number of minutes consumed by audio package.
     */
    public Long getVOIPCallInCount() {
        return this.VOIPCallInCount;
    }

    /**
     * Set Number of minutes consumed by audio package.
     * @param VOIPCallInCount Number of minutes consumed by audio package.
     */
    public void setVOIPCallInCount(Long VOIPCallInCount) {
        this.VOIPCallInCount = VOIPCallInCount;
    }

    /**
     * Get Number of minutes consumed by offline speech-to-text package. 
     * @return AsrOfflineCount Number of minutes consumed by offline speech-to-text package.
     */
    public Long getAsrOfflineCount() {
        return this.AsrOfflineCount;
    }

    /**
     * Set Number of minutes consumed by offline speech-to-text package.
     * @param AsrOfflineCount Number of minutes consumed by offline speech-to-text package.
     */
    public void setAsrOfflineCount(Long AsrOfflineCount) {
        this.AsrOfflineCount = AsrOfflineCount;
    }

    /**
     * Get Number of minutes consumed by real-time speech-to-text package. 
     * @return AsrRealtimeCount Number of minutes consumed by real-time speech-to-text package.
     */
    public Long getAsrRealtimeCount() {
        return this.AsrRealtimeCount;
    }

    /**
     * Set Number of minutes consumed by real-time speech-to-text package.
     * @param AsrRealtimeCount Number of minutes consumed by real-time speech-to-text package.
     */
    public void setAsrRealtimeCount(Long AsrRealtimeCount) {
        this.AsrRealtimeCount = AsrRealtimeCount;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeTelCallInfoResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeTelCallInfoResponse(DescribeTelCallInfoResponse source) {
        if (source.TelCallOutCount != null) {
            this.TelCallOutCount = new Long(source.TelCallOutCount);
        }
        if (source.TelCallInCount != null) {
            this.TelCallInCount = new Long(source.TelCallInCount);
        }
        if (source.SeatUsedCount != null) {
            this.SeatUsedCount = new Long(source.SeatUsedCount);
        }
        if (source.VoipCallInCount != null) {
            this.VoipCallInCount = new Long(source.VoipCallInCount);
        }
        if (source.VOIPCallInCount != null) {
            this.VOIPCallInCount = new Long(source.VOIPCallInCount);
        }
        if (source.AsrOfflineCount != null) {
            this.AsrOfflineCount = new Long(source.AsrOfflineCount);
        }
        if (source.AsrRealtimeCount != null) {
            this.AsrRealtimeCount = new Long(source.AsrRealtimeCount);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "TelCallOutCount", this.TelCallOutCount);
        this.setParamSimple(map, prefix + "TelCallInCount", this.TelCallInCount);
        this.setParamSimple(map, prefix + "SeatUsedCount", this.SeatUsedCount);
        this.setParamSimple(map, prefix + "VoipCallInCount", this.VoipCallInCount);
        this.setParamSimple(map, prefix + "VOIPCallInCount", this.VOIPCallInCount);
        this.setParamSimple(map, prefix + "AsrOfflineCount", this.AsrOfflineCount);
        this.setParamSimple(map, prefix + "AsrRealtimeCount", this.AsrRealtimeCount);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

