/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cdc.v20201214.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeDedicatedClusterOverviewResponse extends AbstractModel {

    /**
    * Number of CVMs
    */
    @SerializedName("CvmCount")
    @Expose
    private Long CvmCount;

    /**
    * Number of hosts
    */
    @SerializedName("HostCount")
    @Expose
    private Long HostCount;

    /**
    * VPN channel status 
Note: The returned value of this field may be null, indicating that no valid value is obtained.
    */
    @SerializedName("VpnConnectionState")
    @Expose
    private String VpnConnectionState;

    /**
    * VPN gateway monitoring data 
Note: The returned value of this field may be null, indicating that no valid value is obtained.
    */
    @SerializedName("VpngwBandwidthData")
    @Expose
    private VpngwBandwidthData VpngwBandwidthData;

    /**
    * Local gateway information 
Note: The returned value of this field may be null, indicating that no valid value is obtained.
    */
    @SerializedName("LocalNetInfo")
    @Expose
    private LocalNetInfo LocalNetInfo;

    /**
    * VPN gateway channel monitoring data 
Note: The returned value of this field may be null, indicating that no valid value is obtained.
    */
    @SerializedName("VpnConnectionBandwidthData")
    @Expose
    private VpngwBandwidthData [] VpnConnectionBandwidthData;

    /**
    * 
    */
    @SerializedName("HostDetailInfo")
    @Expose
    private HostDetailInfo [] HostDetailInfo;

    /**
    * 
    */
    @SerializedName("HostStandbyCount")
    @Expose
    private Long HostStandbyCount;

    /**
    * 
    */
    @SerializedName("HostNormalCount")
    @Expose
    private Long HostNormalCount;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Number of CVMs 
     * @return CvmCount Number of CVMs
     */
    public Long getCvmCount() {
        return this.CvmCount;
    }

    /**
     * Set Number of CVMs
     * @param CvmCount Number of CVMs
     */
    public void setCvmCount(Long CvmCount) {
        this.CvmCount = CvmCount;
    }

    /**
     * Get Number of hosts 
     * @return HostCount Number of hosts
     */
    public Long getHostCount() {
        return this.HostCount;
    }

    /**
     * Set Number of hosts
     * @param HostCount Number of hosts
     */
    public void setHostCount(Long HostCount) {
        this.HostCount = HostCount;
    }

    /**
     * Get VPN channel status 
Note: The returned value of this field may be null, indicating that no valid value is obtained. 
     * @return VpnConnectionState VPN channel status 
Note: The returned value of this field may be null, indicating that no valid value is obtained.
     */
    public String getVpnConnectionState() {
        return this.VpnConnectionState;
    }

    /**
     * Set VPN channel status 
Note: The returned value of this field may be null, indicating that no valid value is obtained.
     * @param VpnConnectionState VPN channel status 
Note: The returned value of this field may be null, indicating that no valid value is obtained.
     */
    public void setVpnConnectionState(String VpnConnectionState) {
        this.VpnConnectionState = VpnConnectionState;
    }

    /**
     * Get VPN gateway monitoring data 
Note: The returned value of this field may be null, indicating that no valid value is obtained. 
     * @return VpngwBandwidthData VPN gateway monitoring data 
Note: The returned value of this field may be null, indicating that no valid value is obtained.
     */
    public VpngwBandwidthData getVpngwBandwidthData() {
        return this.VpngwBandwidthData;
    }

    /**
     * Set VPN gateway monitoring data 
Note: The returned value of this field may be null, indicating that no valid value is obtained.
     * @param VpngwBandwidthData VPN gateway monitoring data 
Note: The returned value of this field may be null, indicating that no valid value is obtained.
     */
    public void setVpngwBandwidthData(VpngwBandwidthData VpngwBandwidthData) {
        this.VpngwBandwidthData = VpngwBandwidthData;
    }

    /**
     * Get Local gateway information 
Note: The returned value of this field may be null, indicating that no valid value is obtained. 
     * @return LocalNetInfo Local gateway information 
Note: The returned value of this field may be null, indicating that no valid value is obtained.
     */
    public LocalNetInfo getLocalNetInfo() {
        return this.LocalNetInfo;
    }

    /**
     * Set Local gateway information 
Note: The returned value of this field may be null, indicating that no valid value is obtained.
     * @param LocalNetInfo Local gateway information 
Note: The returned value of this field may be null, indicating that no valid value is obtained.
     */
    public void setLocalNetInfo(LocalNetInfo LocalNetInfo) {
        this.LocalNetInfo = LocalNetInfo;
    }

    /**
     * Get VPN gateway channel monitoring data 
Note: The returned value of this field may be null, indicating that no valid value is obtained. 
     * @return VpnConnectionBandwidthData VPN gateway channel monitoring data 
Note: The returned value of this field may be null, indicating that no valid value is obtained.
     */
    public VpngwBandwidthData [] getVpnConnectionBandwidthData() {
        return this.VpnConnectionBandwidthData;
    }

    /**
     * Set VPN gateway channel monitoring data 
Note: The returned value of this field may be null, indicating that no valid value is obtained.
     * @param VpnConnectionBandwidthData VPN gateway channel monitoring data 
Note: The returned value of this field may be null, indicating that no valid value is obtained.
     */
    public void setVpnConnectionBandwidthData(VpngwBandwidthData [] VpnConnectionBandwidthData) {
        this.VpnConnectionBandwidthData = VpnConnectionBandwidthData;
    }

    /**
     * Get  
     * @return HostDetailInfo 
     */
    public HostDetailInfo [] getHostDetailInfo() {
        return this.HostDetailInfo;
    }

    /**
     * Set 
     * @param HostDetailInfo 
     */
    public void setHostDetailInfo(HostDetailInfo [] HostDetailInfo) {
        this.HostDetailInfo = HostDetailInfo;
    }

    /**
     * Get  
     * @return HostStandbyCount 
     */
    public Long getHostStandbyCount() {
        return this.HostStandbyCount;
    }

    /**
     * Set 
     * @param HostStandbyCount 
     */
    public void setHostStandbyCount(Long HostStandbyCount) {
        this.HostStandbyCount = HostStandbyCount;
    }

    /**
     * Get  
     * @return HostNormalCount 
     */
    public Long getHostNormalCount() {
        return this.HostNormalCount;
    }

    /**
     * Set 
     * @param HostNormalCount 
     */
    public void setHostNormalCount(Long HostNormalCount) {
        this.HostNormalCount = HostNormalCount;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeDedicatedClusterOverviewResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeDedicatedClusterOverviewResponse(DescribeDedicatedClusterOverviewResponse source) {
        if (source.CvmCount != null) {
            this.CvmCount = new Long(source.CvmCount);
        }
        if (source.HostCount != null) {
            this.HostCount = new Long(source.HostCount);
        }
        if (source.VpnConnectionState != null) {
            this.VpnConnectionState = new String(source.VpnConnectionState);
        }
        if (source.VpngwBandwidthData != null) {
            this.VpngwBandwidthData = new VpngwBandwidthData(source.VpngwBandwidthData);
        }
        if (source.LocalNetInfo != null) {
            this.LocalNetInfo = new LocalNetInfo(source.LocalNetInfo);
        }
        if (source.VpnConnectionBandwidthData != null) {
            this.VpnConnectionBandwidthData = new VpngwBandwidthData[source.VpnConnectionBandwidthData.length];
            for (int i = 0; i < source.VpnConnectionBandwidthData.length; i++) {
                this.VpnConnectionBandwidthData[i] = new VpngwBandwidthData(source.VpnConnectionBandwidthData[i]);
            }
        }
        if (source.HostDetailInfo != null) {
            this.HostDetailInfo = new HostDetailInfo[source.HostDetailInfo.length];
            for (int i = 0; i < source.HostDetailInfo.length; i++) {
                this.HostDetailInfo[i] = new HostDetailInfo(source.HostDetailInfo[i]);
            }
        }
        if (source.HostStandbyCount != null) {
            this.HostStandbyCount = new Long(source.HostStandbyCount);
        }
        if (source.HostNormalCount != null) {
            this.HostNormalCount = new Long(source.HostNormalCount);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "CvmCount", this.CvmCount);
        this.setParamSimple(map, prefix + "HostCount", this.HostCount);
        this.setParamSimple(map, prefix + "VpnConnectionState", this.VpnConnectionState);
        this.setParamObj(map, prefix + "VpngwBandwidthData.", this.VpngwBandwidthData);
        this.setParamObj(map, prefix + "LocalNetInfo.", this.LocalNetInfo);
        this.setParamArrayObj(map, prefix + "VpnConnectionBandwidthData.", this.VpnConnectionBandwidthData);
        this.setParamArrayObj(map, prefix + "HostDetailInfo.", this.HostDetailInfo);
        this.setParamSimple(map, prefix + "HostStandbyCount", this.HostStandbyCount);
        this.setParamSimple(map, prefix + "HostNormalCount", this.HostNormalCount);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

