/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cdc.v20201214.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeDedicatedClusterTypesResponse extends AbstractModel {

    /**
    * List of CDC configurations
    */
    @SerializedName("DedicatedClusterTypeSet")
    @Expose
    private DedicatedClusterType [] DedicatedClusterTypeSet;

    /**
    * Number of records that meet the conditions
    */
    @SerializedName("TotalCount")
    @Expose
    private Long TotalCount;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get List of CDC configurations 
     * @return DedicatedClusterTypeSet List of CDC configurations
     */
    public DedicatedClusterType [] getDedicatedClusterTypeSet() {
        return this.DedicatedClusterTypeSet;
    }

    /**
     * Set List of CDC configurations
     * @param DedicatedClusterTypeSet List of CDC configurations
     */
    public void setDedicatedClusterTypeSet(DedicatedClusterType [] DedicatedClusterTypeSet) {
        this.DedicatedClusterTypeSet = DedicatedClusterTypeSet;
    }

    /**
     * Get Number of records that meet the conditions 
     * @return TotalCount Number of records that meet the conditions
     */
    public Long getTotalCount() {
        return this.TotalCount;
    }

    /**
     * Set Number of records that meet the conditions
     * @param TotalCount Number of records that meet the conditions
     */
    public void setTotalCount(Long TotalCount) {
        this.TotalCount = TotalCount;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeDedicatedClusterTypesResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeDedicatedClusterTypesResponse(DescribeDedicatedClusterTypesResponse source) {
        if (source.DedicatedClusterTypeSet != null) {
            this.DedicatedClusterTypeSet = new DedicatedClusterType[source.DedicatedClusterTypeSet.length];
            for (int i = 0; i < source.DedicatedClusterTypeSet.length; i++) {
                this.DedicatedClusterTypeSet[i] = new DedicatedClusterType(source.DedicatedClusterTypeSet[i]);
            }
        }
        if (source.TotalCount != null) {
            this.TotalCount = new Long(source.TotalCount);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "DedicatedClusterTypeSet.", this.DedicatedClusterTypeSet);
        this.setParamSimple(map, prefix + "TotalCount", this.TotalCount);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

