/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cdn.v20180606.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeCdnDataResponse extends AbstractModel {

    /**
    * Time granularity of the returned data. 
`min`: 1 minute
`5min`: 5 minutes
`hour`: 1 hour
`day`: 1 day
    */
    @SerializedName("Interval")
    @Expose
    private String Interval;

    /**
    * Returned data details of the specified conditional query
    */
    @SerializedName("Data")
    @Expose
    private ResourceData [] Data;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Time granularity of the returned data. 
`min`: 1 minute
`5min`: 5 minutes
`hour`: 1 hour
`day`: 1 day 
     * @return Interval Time granularity of the returned data. 
`min`: 1 minute
`5min`: 5 minutes
`hour`: 1 hour
`day`: 1 day
     */
    public String getInterval() {
        return this.Interval;
    }

    /**
     * Set Time granularity of the returned data. 
`min`: 1 minute
`5min`: 5 minutes
`hour`: 1 hour
`day`: 1 day
     * @param Interval Time granularity of the returned data. 
`min`: 1 minute
`5min`: 5 minutes
`hour`: 1 hour
`day`: 1 day
     */
    public void setInterval(String Interval) {
        this.Interval = Interval;
    }

    /**
     * Get Returned data details of the specified conditional query 
     * @return Data Returned data details of the specified conditional query
     */
    public ResourceData [] getData() {
        return this.Data;
    }

    /**
     * Set Returned data details of the specified conditional query
     * @param Data Returned data details of the specified conditional query
     */
    public void setData(ResourceData [] Data) {
        this.Data = Data;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeCdnDataResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeCdnDataResponse(DescribeCdnDataResponse source) {
        if (source.Interval != null) {
            this.Interval = new String(source.Interval);
        }
        if (source.Data != null) {
            this.Data = new ResourceData[source.Data.length];
            for (int i = 0; i < source.Data.length; i++) {
                this.Data[i] = new ResourceData(source.Data[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Interval", this.Interval);
        this.setParamArrayObj(map, prefix + "Data.", this.Data);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

