/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cdn.v20180606.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class Https extends AbstractModel {

    /**
    * Whether to enable HTTPS. Values:
`on`: Enable
`off`: Disable
Note: This field may return `null`, indicating that no valid values can be obtained.
    */
    @SerializedName("Switch")
    @Expose
    private String Switch;

    /**
    * Whether to enable HTTP2
`on`: Enable
`off`: Disable
Note: this field may return `null`, indicating that no valid values can be obtained.
    */
    @SerializedName("Http2")
    @Expose
    private String Http2;

    /**
    * OCSP configuration switch
`on`: Enable
`off`: Disable
It is disabled by default.
Note: This field may return `null`, indicating that no valid value can be obtained.
    */
    @SerializedName("OcspStapling")
    @Expose
    private String OcspStapling;

    /**
    * Client certificate authentication feature
`on`: Enable
`off`: Disable
This is disabled by default. The client certificate information is needed when enabled. This is still in beta and not generally available yet.
Note: This field may return `null`, indicating that no valid value can be obtained.
    */
    @SerializedName("VerifyClient")
    @Expose
    private String VerifyClient;

    /**
    * Server certificate configuration information
Note: This field may return `null`, indicating that no valid value can be obtained.
    */
    @SerializedName("CertInfo")
    @Expose
    private ServerCert CertInfo;

    /**
    * Client certificate configuration information
Note: This field may return `null`, indicating that no valid value can be obtained.
    */
    @SerializedName("ClientCertInfo")
    @Expose
    private ClientCert ClientCertInfo;

    /**
    * Spdy configuration switch
`on`: Enable
`off`: Disable
It is disabled by default.
Note: This field may return `null`, indicating that no valid value can be obtained.
    */
    @SerializedName("Spdy")
    @Expose
    private String Spdy;

    /**
    * HTTPS certificate deployment status
closed: already closed
deploying: in deployment
deployed: successfully deployed
failed: deployment failed
Note: This field may return `null`, indicating that no valid value can be obtained.
    */
    @SerializedName("SslStatus")
    @Expose
    private String SslStatus;

    /**
    * HSTS configuration
Note: This field may return `null`, indicating that no valid value can be obtained.
    */
    @SerializedName("Hsts")
    @Expose
    private Hsts Hsts;

    /**
    * TLS version settings, which only support certain advanced domain names. Valid values: `TLSv1`, `TLSV1.1`, `TLSV1.2`, and `TLSv1.3`. Only consecutive versions can be enabled at the same time.
Note: This field may return `null`, indicating that no valid value can be obtained.
    */
    @SerializedName("TlsVersion")
    @Expose
    private String [] TlsVersion;

    /**
     * Get Whether to enable HTTPS. Values:
`on`: Enable
`off`: Disable
Note: This field may return `null`, indicating that no valid values can be obtained. 
     * @return Switch Whether to enable HTTPS. Values:
`on`: Enable
`off`: Disable
Note: This field may return `null`, indicating that no valid values can be obtained.
     */
    public String getSwitch() {
        return this.Switch;
    }

    /**
     * Set Whether to enable HTTPS. Values:
`on`: Enable
`off`: Disable
Note: This field may return `null`, indicating that no valid values can be obtained.
     * @param Switch Whether to enable HTTPS. Values:
`on`: Enable
`off`: Disable
Note: This field may return `null`, indicating that no valid values can be obtained.
     */
    public void setSwitch(String Switch) {
        this.Switch = Switch;
    }

    /**
     * Get Whether to enable HTTP2
`on`: Enable
`off`: Disable
Note: this field may return `null`, indicating that no valid values can be obtained. 
     * @return Http2 Whether to enable HTTP2
`on`: Enable
`off`: Disable
Note: this field may return `null`, indicating that no valid values can be obtained.
     */
    public String getHttp2() {
        return this.Http2;
    }

    /**
     * Set Whether to enable HTTP2
`on`: Enable
`off`: Disable
Note: this field may return `null`, indicating that no valid values can be obtained.
     * @param Http2 Whether to enable HTTP2
`on`: Enable
`off`: Disable
Note: this field may return `null`, indicating that no valid values can be obtained.
     */
    public void setHttp2(String Http2) {
        this.Http2 = Http2;
    }

    /**
     * Get OCSP configuration switch
`on`: Enable
`off`: Disable
It is disabled by default.
Note: This field may return `null`, indicating that no valid value can be obtained. 
     * @return OcspStapling OCSP configuration switch
`on`: Enable
`off`: Disable
It is disabled by default.
Note: This field may return `null`, indicating that no valid value can be obtained.
     */
    public String getOcspStapling() {
        return this.OcspStapling;
    }

    /**
     * Set OCSP configuration switch
`on`: Enable
`off`: Disable
It is disabled by default.
Note: This field may return `null`, indicating that no valid value can be obtained.
     * @param OcspStapling OCSP configuration switch
`on`: Enable
`off`: Disable
It is disabled by default.
Note: This field may return `null`, indicating that no valid value can be obtained.
     */
    public void setOcspStapling(String OcspStapling) {
        this.OcspStapling = OcspStapling;
    }

    /**
     * Get Client certificate authentication feature
`on`: Enable
`off`: Disable
This is disabled by default. The client certificate information is needed when enabled. This is still in beta and not generally available yet.
Note: This field may return `null`, indicating that no valid value can be obtained. 
     * @return VerifyClient Client certificate authentication feature
`on`: Enable
`off`: Disable
This is disabled by default. The client certificate information is needed when enabled. This is still in beta and not generally available yet.
Note: This field may return `null`, indicating that no valid value can be obtained.
     */
    public String getVerifyClient() {
        return this.VerifyClient;
    }

    /**
     * Set Client certificate authentication feature
`on`: Enable
`off`: Disable
This is disabled by default. The client certificate information is needed when enabled. This is still in beta and not generally available yet.
Note: This field may return `null`, indicating that no valid value can be obtained.
     * @param VerifyClient Client certificate authentication feature
`on`: Enable
`off`: Disable
This is disabled by default. The client certificate information is needed when enabled. This is still in beta and not generally available yet.
Note: This field may return `null`, indicating that no valid value can be obtained.
     */
    public void setVerifyClient(String VerifyClient) {
        this.VerifyClient = VerifyClient;
    }

    /**
     * Get Server certificate configuration information
Note: This field may return `null`, indicating that no valid value can be obtained. 
     * @return CertInfo Server certificate configuration information
Note: This field may return `null`, indicating that no valid value can be obtained.
     */
    public ServerCert getCertInfo() {
        return this.CertInfo;
    }

    /**
     * Set Server certificate configuration information
Note: This field may return `null`, indicating that no valid value can be obtained.
     * @param CertInfo Server certificate configuration information
Note: This field may return `null`, indicating that no valid value can be obtained.
     */
    public void setCertInfo(ServerCert CertInfo) {
        this.CertInfo = CertInfo;
    }

    /**
     * Get Client certificate configuration information
Note: This field may return `null`, indicating that no valid value can be obtained. 
     * @return ClientCertInfo Client certificate configuration information
Note: This field may return `null`, indicating that no valid value can be obtained.
     */
    public ClientCert getClientCertInfo() {
        return this.ClientCertInfo;
    }

    /**
     * Set Client certificate configuration information
Note: This field may return `null`, indicating that no valid value can be obtained.
     * @param ClientCertInfo Client certificate configuration information
Note: This field may return `null`, indicating that no valid value can be obtained.
     */
    public void setClientCertInfo(ClientCert ClientCertInfo) {
        this.ClientCertInfo = ClientCertInfo;
    }

    /**
     * Get Spdy configuration switch
`on`: Enable
`off`: Disable
It is disabled by default.
Note: This field may return `null`, indicating that no valid value can be obtained. 
     * @return Spdy Spdy configuration switch
`on`: Enable
`off`: Disable
It is disabled by default.
Note: This field may return `null`, indicating that no valid value can be obtained.
     */
    public String getSpdy() {
        return this.Spdy;
    }

    /**
     * Set Spdy configuration switch
`on`: Enable
`off`: Disable
It is disabled by default.
Note: This field may return `null`, indicating that no valid value can be obtained.
     * @param Spdy Spdy configuration switch
`on`: Enable
`off`: Disable
It is disabled by default.
Note: This field may return `null`, indicating that no valid value can be obtained.
     */
    public void setSpdy(String Spdy) {
        this.Spdy = Spdy;
    }

    /**
     * Get HTTPS certificate deployment status
closed: already closed
deploying: in deployment
deployed: successfully deployed
failed: deployment failed
Note: This field may return `null`, indicating that no valid value can be obtained. 
     * @return SslStatus HTTPS certificate deployment status
closed: already closed
deploying: in deployment
deployed: successfully deployed
failed: deployment failed
Note: This field may return `null`, indicating that no valid value can be obtained.
     */
    public String getSslStatus() {
        return this.SslStatus;
    }

    /**
     * Set HTTPS certificate deployment status
closed: already closed
deploying: in deployment
deployed: successfully deployed
failed: deployment failed
Note: This field may return `null`, indicating that no valid value can be obtained.
     * @param SslStatus HTTPS certificate deployment status
closed: already closed
deploying: in deployment
deployed: successfully deployed
failed: deployment failed
Note: This field may return `null`, indicating that no valid value can be obtained.
     */
    public void setSslStatus(String SslStatus) {
        this.SslStatus = SslStatus;
    }

    /**
     * Get HSTS configuration
Note: This field may return `null`, indicating that no valid value can be obtained. 
     * @return Hsts HSTS configuration
Note: This field may return `null`, indicating that no valid value can be obtained.
     */
    public Hsts getHsts() {
        return this.Hsts;
    }

    /**
     * Set HSTS configuration
Note: This field may return `null`, indicating that no valid value can be obtained.
     * @param Hsts HSTS configuration
Note: This field may return `null`, indicating that no valid value can be obtained.
     */
    public void setHsts(Hsts Hsts) {
        this.Hsts = Hsts;
    }

    /**
     * Get TLS version settings, which only support certain advanced domain names. Valid values: `TLSv1`, `TLSV1.1`, `TLSV1.2`, and `TLSv1.3`. Only consecutive versions can be enabled at the same time.
Note: This field may return `null`, indicating that no valid value can be obtained. 
     * @return TlsVersion TLS version settings, which only support certain advanced domain names. Valid values: `TLSv1`, `TLSV1.1`, `TLSV1.2`, and `TLSv1.3`. Only consecutive versions can be enabled at the same time.
Note: This field may return `null`, indicating that no valid value can be obtained.
     */
    public String [] getTlsVersion() {
        return this.TlsVersion;
    }

    /**
     * Set TLS version settings, which only support certain advanced domain names. Valid values: `TLSv1`, `TLSV1.1`, `TLSV1.2`, and `TLSv1.3`. Only consecutive versions can be enabled at the same time.
Note: This field may return `null`, indicating that no valid value can be obtained.
     * @param TlsVersion TLS version settings, which only support certain advanced domain names. Valid values: `TLSv1`, `TLSV1.1`, `TLSV1.2`, and `TLSv1.3`. Only consecutive versions can be enabled at the same time.
Note: This field may return `null`, indicating that no valid value can be obtained.
     */
    public void setTlsVersion(String [] TlsVersion) {
        this.TlsVersion = TlsVersion;
    }

    public Https() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public Https(Https source) {
        if (source.Switch != null) {
            this.Switch = new String(source.Switch);
        }
        if (source.Http2 != null) {
            this.Http2 = new String(source.Http2);
        }
        if (source.OcspStapling != null) {
            this.OcspStapling = new String(source.OcspStapling);
        }
        if (source.VerifyClient != null) {
            this.VerifyClient = new String(source.VerifyClient);
        }
        if (source.CertInfo != null) {
            this.CertInfo = new ServerCert(source.CertInfo);
        }
        if (source.ClientCertInfo != null) {
            this.ClientCertInfo = new ClientCert(source.ClientCertInfo);
        }
        if (source.Spdy != null) {
            this.Spdy = new String(source.Spdy);
        }
        if (source.SslStatus != null) {
            this.SslStatus = new String(source.SslStatus);
        }
        if (source.Hsts != null) {
            this.Hsts = new Hsts(source.Hsts);
        }
        if (source.TlsVersion != null) {
            this.TlsVersion = new String[source.TlsVersion.length];
            for (int i = 0; i < source.TlsVersion.length; i++) {
                this.TlsVersion[i] = new String(source.TlsVersion[i]);
            }
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Switch", this.Switch);
        this.setParamSimple(map, prefix + "Http2", this.Http2);
        this.setParamSimple(map, prefix + "OcspStapling", this.OcspStapling);
        this.setParamSimple(map, prefix + "VerifyClient", this.VerifyClient);
        this.setParamObj(map, prefix + "CertInfo.", this.CertInfo);
        this.setParamObj(map, prefix + "ClientCertInfo.", this.ClientCertInfo);
        this.setParamSimple(map, prefix + "Spdy", this.Spdy);
        this.setParamSimple(map, prefix + "SslStatus", this.SslStatus);
        this.setParamObj(map, prefix + "Hsts.", this.Hsts);
        this.setParamArraySimple(map, prefix + "TlsVersion.", this.TlsVersion);

    }
}

