/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cdwdoris.v20211228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeAreaRegionResponse extends AbstractModel {

    /**
    * Region list
    */
    @SerializedName("Items")
    @Expose
    private RegionAreaInfo [] Items;

    /**
    * Front-end rule description
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("FrontEndRules")
    @Expose
    private FrontEndRule [] FrontEndRules;

    /**
    * Return available allowlist names
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("AvailableWhiteListNames")
    @Expose
    private String [] AvailableWhiteListNames;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Region list 
     * @return Items Region list
     */
    public RegionAreaInfo [] getItems() {
        return this.Items;
    }

    /**
     * Set Region list
     * @param Items Region list
     */
    public void setItems(RegionAreaInfo [] Items) {
        this.Items = Items;
    }

    /**
     * Get Front-end rule description
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return FrontEndRules Front-end rule description
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public FrontEndRule [] getFrontEndRules() {
        return this.FrontEndRules;
    }

    /**
     * Set Front-end rule description
Note: This field may return null, indicating that no valid values can be obtained.
     * @param FrontEndRules Front-end rule description
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setFrontEndRules(FrontEndRule [] FrontEndRules) {
        this.FrontEndRules = FrontEndRules;
    }

    /**
     * Get Return available allowlist names
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return AvailableWhiteListNames Return available allowlist names
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String [] getAvailableWhiteListNames() {
        return this.AvailableWhiteListNames;
    }

    /**
     * Set Return available allowlist names
Note: This field may return null, indicating that no valid values can be obtained.
     * @param AvailableWhiteListNames Return available allowlist names
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setAvailableWhiteListNames(String [] AvailableWhiteListNames) {
        this.AvailableWhiteListNames = AvailableWhiteListNames;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeAreaRegionResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeAreaRegionResponse(DescribeAreaRegionResponse source) {
        if (source.Items != null) {
            this.Items = new RegionAreaInfo[source.Items.length];
            for (int i = 0; i < source.Items.length; i++) {
                this.Items[i] = new RegionAreaInfo(source.Items[i]);
            }
        }
        if (source.FrontEndRules != null) {
            this.FrontEndRules = new FrontEndRule[source.FrontEndRules.length];
            for (int i = 0; i < source.FrontEndRules.length; i++) {
                this.FrontEndRules[i] = new FrontEndRule(source.FrontEndRules[i]);
            }
        }
        if (source.AvailableWhiteListNames != null) {
            this.AvailableWhiteListNames = new String[source.AvailableWhiteListNames.length];
            for (int i = 0; i < source.AvailableWhiteListNames.length; i++) {
                this.AvailableWhiteListNames[i] = new String(source.AvailableWhiteListNames[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "Items.", this.Items);
        this.setParamArrayObj(map, prefix + "FrontEndRules.", this.FrontEndRules);
        this.setParamArraySimple(map, prefix + "AvailableWhiteListNames.", this.AvailableWhiteListNames);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

