/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cdwdoris.v20211228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeClusterConfigsResponse extends AbstractModel {

    /**
    * Return information about the instance's configuration file.
    */
    @SerializedName("ClusterConfList")
    @Expose
    private ClusterConfigsInfoFromEMR [] ClusterConfList;

    /**
    * Return the current kernel version. If it does not exist, a null character string is returned.
    */
    @SerializedName("BuildVersion")
    @Expose
    private String BuildVersion;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Return information about the instance's configuration file. 
     * @return ClusterConfList Return information about the instance's configuration file.
     */
    public ClusterConfigsInfoFromEMR [] getClusterConfList() {
        return this.ClusterConfList;
    }

    /**
     * Set Return information about the instance's configuration file.
     * @param ClusterConfList Return information about the instance's configuration file.
     */
    public void setClusterConfList(ClusterConfigsInfoFromEMR [] ClusterConfList) {
        this.ClusterConfList = ClusterConfList;
    }

    /**
     * Get Return the current kernel version. If it does not exist, a null character string is returned. 
     * @return BuildVersion Return the current kernel version. If it does not exist, a null character string is returned.
     */
    public String getBuildVersion() {
        return this.BuildVersion;
    }

    /**
     * Set Return the current kernel version. If it does not exist, a null character string is returned.
     * @param BuildVersion Return the current kernel version. If it does not exist, a null character string is returned.
     */
    public void setBuildVersion(String BuildVersion) {
        this.BuildVersion = BuildVersion;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeClusterConfigsResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeClusterConfigsResponse(DescribeClusterConfigsResponse source) {
        if (source.ClusterConfList != null) {
            this.ClusterConfList = new ClusterConfigsInfoFromEMR[source.ClusterConfList.length];
            for (int i = 0; i < source.ClusterConfList.length; i++) {
                this.ClusterConfList[i] = new ClusterConfigsInfoFromEMR(source.ClusterConfList[i]);
            }
        }
        if (source.BuildVersion != null) {
            this.BuildVersion = new String(source.BuildVersion);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "ClusterConfList.", this.ClusterConfList);
        this.setParamSimple(map, prefix + "BuildVersion", this.BuildVersion);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

