/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cdwdoris.v20211228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeInstanceNodesInfoResponse extends AbstractModel {

    /**
    * Be node
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("BeNodes")
    @Expose
    private String [] BeNodes;

    /**
    * Fe node
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("FeNodes")
    @Expose
    private String [] FeNodes;

    /**
    * Fe master node
    */
    @SerializedName("FeMaster")
    @Expose
    private String FeMaster;

    /**
    * Be node information
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("BeNodeInfos")
    @Expose
    private NodeInfo [] BeNodeInfos;

    /**
    * Fe node information
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("FeNodeInfos")
    @Expose
    private NodeInfo [] FeNodeInfos;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Be node
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return BeNodes Be node
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String [] getBeNodes() {
        return this.BeNodes;
    }

    /**
     * Set Be node
Note: This field may return null, indicating that no valid values can be obtained.
     * @param BeNodes Be node
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setBeNodes(String [] BeNodes) {
        this.BeNodes = BeNodes;
    }

    /**
     * Get Fe node
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return FeNodes Fe node
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String [] getFeNodes() {
        return this.FeNodes;
    }

    /**
     * Set Fe node
Note: This field may return null, indicating that no valid values can be obtained.
     * @param FeNodes Fe node
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setFeNodes(String [] FeNodes) {
        this.FeNodes = FeNodes;
    }

    /**
     * Get Fe master node 
     * @return FeMaster Fe master node
     */
    public String getFeMaster() {
        return this.FeMaster;
    }

    /**
     * Set Fe master node
     * @param FeMaster Fe master node
     */
    public void setFeMaster(String FeMaster) {
        this.FeMaster = FeMaster;
    }

    /**
     * Get Be node information
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return BeNodeInfos Be node information
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public NodeInfo [] getBeNodeInfos() {
        return this.BeNodeInfos;
    }

    /**
     * Set Be node information
Note: This field may return null, indicating that no valid values can be obtained.
     * @param BeNodeInfos Be node information
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setBeNodeInfos(NodeInfo [] BeNodeInfos) {
        this.BeNodeInfos = BeNodeInfos;
    }

    /**
     * Get Fe node information
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return FeNodeInfos Fe node information
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public NodeInfo [] getFeNodeInfos() {
        return this.FeNodeInfos;
    }

    /**
     * Set Fe node information
Note: This field may return null, indicating that no valid values can be obtained.
     * @param FeNodeInfos Fe node information
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setFeNodeInfos(NodeInfo [] FeNodeInfos) {
        this.FeNodeInfos = FeNodeInfos;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeInstanceNodesInfoResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeInstanceNodesInfoResponse(DescribeInstanceNodesInfoResponse source) {
        if (source.BeNodes != null) {
            this.BeNodes = new String[source.BeNodes.length];
            for (int i = 0; i < source.BeNodes.length; i++) {
                this.BeNodes[i] = new String(source.BeNodes[i]);
            }
        }
        if (source.FeNodes != null) {
            this.FeNodes = new String[source.FeNodes.length];
            for (int i = 0; i < source.FeNodes.length; i++) {
                this.FeNodes[i] = new String(source.FeNodes[i]);
            }
        }
        if (source.FeMaster != null) {
            this.FeMaster = new String(source.FeMaster);
        }
        if (source.BeNodeInfos != null) {
            this.BeNodeInfos = new NodeInfo[source.BeNodeInfos.length];
            for (int i = 0; i < source.BeNodeInfos.length; i++) {
                this.BeNodeInfos[i] = new NodeInfo(source.BeNodeInfos[i]);
            }
        }
        if (source.FeNodeInfos != null) {
            this.FeNodeInfos = new NodeInfo[source.FeNodeInfos.length];
            for (int i = 0; i < source.FeNodeInfos.length; i++) {
                this.FeNodeInfos[i] = new NodeInfo(source.FeNodeInfos[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArraySimple(map, prefix + "BeNodes.", this.BeNodes);
        this.setParamArraySimple(map, prefix + "FeNodes.", this.FeNodes);
        this.setParamSimple(map, prefix + "FeMaster", this.FeMaster);
        this.setParamArrayObj(map, prefix + "BeNodeInfos.", this.BeNodeInfos);
        this.setParamArrayObj(map, prefix + "FeNodeInfos.", this.FeNodeInfos);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

