/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cdwdoris.v20211228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeSpecResponse extends AbstractModel {

    /**
    * Zookeeper node specification description
    */
    @SerializedName("MasterSpec")
    @Expose
    private ResourceSpec [] MasterSpec;

    /**
    * Data node specification description
    */
    @SerializedName("CoreSpec")
    @Expose
    private ResourceSpec [] CoreSpec;

    /**
    * Cloud disk list
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("AttachCBSSpec")
    @Expose
    private DiskSpec [] AttachCBSSpec;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Zookeeper node specification description 
     * @return MasterSpec Zookeeper node specification description
     */
    public ResourceSpec [] getMasterSpec() {
        return this.MasterSpec;
    }

    /**
     * Set Zookeeper node specification description
     * @param MasterSpec Zookeeper node specification description
     */
    public void setMasterSpec(ResourceSpec [] MasterSpec) {
        this.MasterSpec = MasterSpec;
    }

    /**
     * Get Data node specification description 
     * @return CoreSpec Data node specification description
     */
    public ResourceSpec [] getCoreSpec() {
        return this.CoreSpec;
    }

    /**
     * Set Data node specification description
     * @param CoreSpec Data node specification description
     */
    public void setCoreSpec(ResourceSpec [] CoreSpec) {
        this.CoreSpec = CoreSpec;
    }

    /**
     * Get Cloud disk list
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return AttachCBSSpec Cloud disk list
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public DiskSpec [] getAttachCBSSpec() {
        return this.AttachCBSSpec;
    }

    /**
     * Set Cloud disk list
Note: This field may return null, indicating that no valid values can be obtained.
     * @param AttachCBSSpec Cloud disk list
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setAttachCBSSpec(DiskSpec [] AttachCBSSpec) {
        this.AttachCBSSpec = AttachCBSSpec;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeSpecResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeSpecResponse(DescribeSpecResponse source) {
        if (source.MasterSpec != null) {
            this.MasterSpec = new ResourceSpec[source.MasterSpec.length];
            for (int i = 0; i < source.MasterSpec.length; i++) {
                this.MasterSpec[i] = new ResourceSpec(source.MasterSpec[i]);
            }
        }
        if (source.CoreSpec != null) {
            this.CoreSpec = new ResourceSpec[source.CoreSpec.length];
            for (int i = 0; i < source.CoreSpec.length; i++) {
                this.CoreSpec[i] = new ResourceSpec(source.CoreSpec[i]);
            }
        }
        if (source.AttachCBSSpec != null) {
            this.AttachCBSSpec = new DiskSpec[source.AttachCBSSpec.length];
            for (int i = 0; i < source.AttachCBSSpec.length; i++) {
                this.AttachCBSSpec[i] = new DiskSpec(source.AttachCBSSpec[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "MasterSpec.", this.MasterSpec);
        this.setParamArrayObj(map, prefix + "CoreSpec.", this.CoreSpec);
        this.setParamArrayObj(map, prefix + "AttachCBSSpec.", this.AttachCBSSpec);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

