/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cdwpg.v20201230.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeInstanceNodesResponse extends AbstractModel {

    /**
    * error msg
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("ErrorMsg")
    @Expose
    private String ErrorMsg;

    /**
    * Node list.

Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("InstanceNodes")
    @Expose
    private InstanceNode [] InstanceNodes;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get error msg
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return ErrorMsg error msg
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String getErrorMsg() {
        return this.ErrorMsg;
    }

    /**
     * Set error msg
Note: This field may return null, indicating that no valid values can be obtained.
     * @param ErrorMsg error msg
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setErrorMsg(String ErrorMsg) {
        this.ErrorMsg = ErrorMsg;
    }

    /**
     * Get Node list.

Note: This field may return null, indicating that no valid values can be obtained. 
     * @return InstanceNodes Node list.

Note: This field may return null, indicating that no valid values can be obtained.
     */
    public InstanceNode [] getInstanceNodes() {
        return this.InstanceNodes;
    }

    /**
     * Set Node list.

Note: This field may return null, indicating that no valid values can be obtained.
     * @param InstanceNodes Node list.

Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setInstanceNodes(InstanceNode [] InstanceNodes) {
        this.InstanceNodes = InstanceNodes;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeInstanceNodesResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeInstanceNodesResponse(DescribeInstanceNodesResponse source) {
        if (source.ErrorMsg != null) {
            this.ErrorMsg = new String(source.ErrorMsg);
        }
        if (source.InstanceNodes != null) {
            this.InstanceNodes = new InstanceNode[source.InstanceNodes.length];
            for (int i = 0; i < source.InstanceNodes.length; i++) {
                this.InstanceNodes[i] = new InstanceNode(source.InstanceNodes[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "ErrorMsg", this.ErrorMsg);
        this.setParamArrayObj(map, prefix + "InstanceNodes.", this.InstanceNodes);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

