/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cdz.v20221123.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeCloudDedicatedZoneResourceSummaryResponse extends AbstractModel {

    /**
    * Resource utilization.
    */
    @SerializedName("ResourceSummarySet")
    @Expose
    private CloudDedicatedZoneResourceSummaryInfo [] ResourceSummarySet;

    /**
    * Extended information of resource utilization.
    */
    @SerializedName("ExtraInfo")
    @Expose
    private ExtraInfo ExtraInfo;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Resource utilization. 
     * @return ResourceSummarySet Resource utilization.
     */
    public CloudDedicatedZoneResourceSummaryInfo [] getResourceSummarySet() {
        return this.ResourceSummarySet;
    }

    /**
     * Set Resource utilization.
     * @param ResourceSummarySet Resource utilization.
     */
    public void setResourceSummarySet(CloudDedicatedZoneResourceSummaryInfo [] ResourceSummarySet) {
        this.ResourceSummarySet = ResourceSummarySet;
    }

    /**
     * Get Extended information of resource utilization. 
     * @return ExtraInfo Extended information of resource utilization.
     */
    public ExtraInfo getExtraInfo() {
        return this.ExtraInfo;
    }

    /**
     * Set Extended information of resource utilization.
     * @param ExtraInfo Extended information of resource utilization.
     */
    public void setExtraInfo(ExtraInfo ExtraInfo) {
        this.ExtraInfo = ExtraInfo;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeCloudDedicatedZoneResourceSummaryResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeCloudDedicatedZoneResourceSummaryResponse(DescribeCloudDedicatedZoneResourceSummaryResponse source) {
        if (source.ResourceSummarySet != null) {
            this.ResourceSummarySet = new CloudDedicatedZoneResourceSummaryInfo[source.ResourceSummarySet.length];
            for (int i = 0; i < source.ResourceSummarySet.length; i++) {
                this.ResourceSummarySet[i] = new CloudDedicatedZoneResourceSummaryInfo(source.ResourceSummarySet[i]);
            }
        }
        if (source.ExtraInfo != null) {
            this.ExtraInfo = new ExtraInfo(source.ExtraInfo);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "ResourceSummarySet.", this.ResourceSummarySet);
        this.setParamObj(map, prefix + "ExtraInfo.", this.ExtraInfo);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

