/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cfg.v20210820.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeActionFieldConfigListResponse extends AbstractModel {

    /**
    * List of general filed configuration parameters
    */
    @SerializedName("Common")
    @Expose
    private ActionFieldConfigResult [] Common;

    /**
    * List of action filed configuration parameters
    */
    @SerializedName("Results")
    @Expose
    private ActionFieldConfigResult [] Results;

    /**
    * Information on the decommissioned resource
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("ResourceOffline")
    @Expose
    private ResourceOffline [] ResourceOffline;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get List of general filed configuration parameters 
     * @return Common List of general filed configuration parameters
     */
    public ActionFieldConfigResult [] getCommon() {
        return this.Common;
    }

    /**
     * Set List of general filed configuration parameters
     * @param Common List of general filed configuration parameters
     */
    public void setCommon(ActionFieldConfigResult [] Common) {
        this.Common = Common;
    }

    /**
     * Get List of action filed configuration parameters 
     * @return Results List of action filed configuration parameters
     */
    public ActionFieldConfigResult [] getResults() {
        return this.Results;
    }

    /**
     * Set List of action filed configuration parameters
     * @param Results List of action filed configuration parameters
     */
    public void setResults(ActionFieldConfigResult [] Results) {
        this.Results = Results;
    }

    /**
     * Get Information on the decommissioned resource
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return ResourceOffline Information on the decommissioned resource
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public ResourceOffline [] getResourceOffline() {
        return this.ResourceOffline;
    }

    /**
     * Set Information on the decommissioned resource
Note: This field may return null, indicating that no valid values can be obtained.
     * @param ResourceOffline Information on the decommissioned resource
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setResourceOffline(ResourceOffline [] ResourceOffline) {
        this.ResourceOffline = ResourceOffline;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeActionFieldConfigListResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeActionFieldConfigListResponse(DescribeActionFieldConfigListResponse source) {
        if (source.Common != null) {
            this.Common = new ActionFieldConfigResult[source.Common.length];
            for (int i = 0; i < source.Common.length; i++) {
                this.Common[i] = new ActionFieldConfigResult(source.Common[i]);
            }
        }
        if (source.Results != null) {
            this.Results = new ActionFieldConfigResult[source.Results.length];
            for (int i = 0; i < source.Results.length; i++) {
                this.Results[i] = new ActionFieldConfigResult(source.Results[i]);
            }
        }
        if (source.ResourceOffline != null) {
            this.ResourceOffline = new ResourceOffline[source.ResourceOffline.length];
            for (int i = 0; i < source.ResourceOffline.length; i++) {
                this.ResourceOffline[i] = new ResourceOffline(source.ResourceOffline[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "Common.", this.Common);
        this.setParamArrayObj(map, prefix + "Results.", this.Results);
        this.setParamArrayObj(map, prefix + "ResourceOffline.", this.ResourceOffline);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

