/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cfg.v20210820.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeTaskResponse extends AbstractModel {

    /**
    * Task information
    */
    @SerializedName("Task")
    @Expose
    private Task Task;

    /**
    * Experiment report information corresponding to the task. The value null indicates that no report is exported.
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("ReportInfo")
    @Expose
    private TaskReportInfo ReportInfo;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Task information 
     * @return Task Task information
     */
    public Task getTask() {
        return this.Task;
    }

    /**
     * Set Task information
     * @param Task Task information
     */
    public void setTask(Task Task) {
        this.Task = Task;
    }

    /**
     * Get Experiment report information corresponding to the task. The value null indicates that no report is exported.
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return ReportInfo Experiment report information corresponding to the task. The value null indicates that no report is exported.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public TaskReportInfo getReportInfo() {
        return this.ReportInfo;
    }

    /**
     * Set Experiment report information corresponding to the task. The value null indicates that no report is exported.
Note: This field may return null, indicating that no valid values can be obtained.
     * @param ReportInfo Experiment report information corresponding to the task. The value null indicates that no report is exported.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setReportInfo(TaskReportInfo ReportInfo) {
        this.ReportInfo = ReportInfo;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeTaskResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeTaskResponse(DescribeTaskResponse source) {
        if (source.Task != null) {
            this.Task = new Task(source.Task);
        }
        if (source.ReportInfo != null) {
            this.ReportInfo = new TaskReportInfo(source.ReportInfo);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamObj(map, prefix + "Task.", this.Task);
        this.setParamObj(map, prefix + "ReportInfo.", this.ReportInfo);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

