/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cfw.v20190904.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class AddEnterpriseSecurityGroupRulesRequest extends AbstractModel {

    /**
    * Creates rule data
    */
    @SerializedName("Data")
    @Expose
    private SecurityGroupRule [] Data;

    /**
    * Adding type. 0: add to the end; 1: add to the front; 2: insert. Default: 0
    */
    @SerializedName("Type")
    @Expose
    private Long Type;

    /**
    * An identifier to ensure the idempotency of the request. The value of the ClientToken parameter is a unique string that is generated by your client and can contain up to 64 ASCII characters in length.
    */
    @SerializedName("ClientToken")
    @Expose
    private String ClientToken;

    /**
    * Indicates whether to delay publishing. 1: delay; other values: do not delay
    */
    @SerializedName("IsDelay")
    @Expose
    private Long IsDelay;

    /**
     * Get Creates rule data 
     * @return Data Creates rule data
     */
    public SecurityGroupRule [] getData() {
        return this.Data;
    }

    /**
     * Set Creates rule data
     * @param Data Creates rule data
     */
    public void setData(SecurityGroupRule [] Data) {
        this.Data = Data;
    }

    /**
     * Get Adding type. 0: add to the end; 1: add to the front; 2: insert. Default: 0 
     * @return Type Adding type. 0: add to the end; 1: add to the front; 2: insert. Default: 0
     */
    public Long getType() {
        return this.Type;
    }

    /**
     * Set Adding type. 0: add to the end; 1: add to the front; 2: insert. Default: 0
     * @param Type Adding type. 0: add to the end; 1: add to the front; 2: insert. Default: 0
     */
    public void setType(Long Type) {
        this.Type = Type;
    }

    /**
     * Get An identifier to ensure the idempotency of the request. The value of the ClientToken parameter is a unique string that is generated by your client and can contain up to 64 ASCII characters in length. 
     * @return ClientToken An identifier to ensure the idempotency of the request. The value of the ClientToken parameter is a unique string that is generated by your client and can contain up to 64 ASCII characters in length.
     */
    public String getClientToken() {
        return this.ClientToken;
    }

    /**
     * Set An identifier to ensure the idempotency of the request. The value of the ClientToken parameter is a unique string that is generated by your client and can contain up to 64 ASCII characters in length.
     * @param ClientToken An identifier to ensure the idempotency of the request. The value of the ClientToken parameter is a unique string that is generated by your client and can contain up to 64 ASCII characters in length.
     */
    public void setClientToken(String ClientToken) {
        this.ClientToken = ClientToken;
    }

    /**
     * Get Indicates whether to delay publishing. 1: delay; other values: do not delay 
     * @return IsDelay Indicates whether to delay publishing. 1: delay; other values: do not delay
     */
    public Long getIsDelay() {
        return this.IsDelay;
    }

    /**
     * Set Indicates whether to delay publishing. 1: delay; other values: do not delay
     * @param IsDelay Indicates whether to delay publishing. 1: delay; other values: do not delay
     */
    public void setIsDelay(Long IsDelay) {
        this.IsDelay = IsDelay;
    }

    public AddEnterpriseSecurityGroupRulesRequest() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public AddEnterpriseSecurityGroupRulesRequest(AddEnterpriseSecurityGroupRulesRequest source) {
        if (source.Data != null) {
            this.Data = new SecurityGroupRule[source.Data.length];
            for (int i = 0; i < source.Data.length; i++) {
                this.Data[i] = new SecurityGroupRule(source.Data[i]);
            }
        }
        if (source.Type != null) {
            this.Type = new Long(source.Type);
        }
        if (source.ClientToken != null) {
            this.ClientToken = new String(source.ClientToken);
        }
        if (source.IsDelay != null) {
            this.IsDelay = new Long(source.IsDelay);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "Data.", this.Data);
        this.setParamSimple(map, prefix + "Type", this.Type);
        this.setParamSimple(map, prefix + "ClientToken", this.ClientToken);
        this.setParamSimple(map, prefix + "IsDelay", this.IsDelay);

    }
}

