/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cls.v20201016.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class CreateMachineGroupRequest extends AbstractModel {

    /**
    * Machine group name, which must be unique
    */
    @SerializedName("GroupName")
    @Expose
    private String GroupName;

    /**
    * Type of the machine group to be created. Valid values: `ip`: use the IP string list in `Values` to create a machine group; `label`: use the tag string list in `Values` to create a machine group
    */
    @SerializedName("MachineGroupType")
    @Expose
    private MachineGroupTypeInfo MachineGroupType;

    /**
    * Tag description list. This parameter is used to bind a tag to a machine group. Up to 10 tag key-value pairs are supported, and a resource can be bound to only one tag key.
    */
    @SerializedName("Tags")
    @Expose
    private Tag [] Tags;

    /**
    * Whether to enable automatic update for the machine group
    */
    @SerializedName("AutoUpdate")
    @Expose
    private Boolean AutoUpdate;

    /**
    * Update start time. We recommend you update LogListener during off-peak hours.
    */
    @SerializedName("UpdateStartTime")
    @Expose
    private String UpdateStartTime;

    /**
    * Update end time. We recommend you update LogListener during off-peak hours.
    */
    @SerializedName("UpdateEndTime")
    @Expose
    private String UpdateEndTime;

    /**
    * Whether to enable the service log to record the logs generated by the LogListener service itself. After it is enabled, the internal logset `cls_service_logging` and the `loglistener_status`, `loglistener_alarm`, and `loglistener_business` log topics will be created, which will not incur fees
    */
    @SerializedName("ServiceLogging")
    @Expose
    private Boolean ServiceLogging;

    /**
    * Offline cleaning time for machines in machine group
    */
    @SerializedName("DelayCleanupTime")
    @Expose
    private Long DelayCleanupTime;

    /**
    * Metadata information list of a machine group
    */
    @SerializedName("MetaTags")
    @Expose
    private MetaTagInfo [] MetaTags;

    /**
    * System type, default 0, 0: Linux, 1: Windows
    */
    @SerializedName("OSType")
    @Expose
    private Long OSType;

    /**
     * Get Machine group name, which must be unique 
     * @return GroupName Machine group name, which must be unique
     */
    public String getGroupName() {
        return this.GroupName;
    }

    /**
     * Set Machine group name, which must be unique
     * @param GroupName Machine group name, which must be unique
     */
    public void setGroupName(String GroupName) {
        this.GroupName = GroupName;
    }

    /**
     * Get Type of the machine group to be created. Valid values: `ip`: use the IP string list in `Values` to create a machine group; `label`: use the tag string list in `Values` to create a machine group 
     * @return MachineGroupType Type of the machine group to be created. Valid values: `ip`: use the IP string list in `Values` to create a machine group; `label`: use the tag string list in `Values` to create a machine group
     */
    public MachineGroupTypeInfo getMachineGroupType() {
        return this.MachineGroupType;
    }

    /**
     * Set Type of the machine group to be created. Valid values: `ip`: use the IP string list in `Values` to create a machine group; `label`: use the tag string list in `Values` to create a machine group
     * @param MachineGroupType Type of the machine group to be created. Valid values: `ip`: use the IP string list in `Values` to create a machine group; `label`: use the tag string list in `Values` to create a machine group
     */
    public void setMachineGroupType(MachineGroupTypeInfo MachineGroupType) {
        this.MachineGroupType = MachineGroupType;
    }

    /**
     * Get Tag description list. This parameter is used to bind a tag to a machine group. Up to 10 tag key-value pairs are supported, and a resource can be bound to only one tag key. 
     * @return Tags Tag description list. This parameter is used to bind a tag to a machine group. Up to 10 tag key-value pairs are supported, and a resource can be bound to only one tag key.
     */
    public Tag [] getTags() {
        return this.Tags;
    }

    /**
     * Set Tag description list. This parameter is used to bind a tag to a machine group. Up to 10 tag key-value pairs are supported, and a resource can be bound to only one tag key.
     * @param Tags Tag description list. This parameter is used to bind a tag to a machine group. Up to 10 tag key-value pairs are supported, and a resource can be bound to only one tag key.
     */
    public void setTags(Tag [] Tags) {
        this.Tags = Tags;
    }

    /**
     * Get Whether to enable automatic update for the machine group 
     * @return AutoUpdate Whether to enable automatic update for the machine group
     */
    public Boolean getAutoUpdate() {
        return this.AutoUpdate;
    }

    /**
     * Set Whether to enable automatic update for the machine group
     * @param AutoUpdate Whether to enable automatic update for the machine group
     */
    public void setAutoUpdate(Boolean AutoUpdate) {
        this.AutoUpdate = AutoUpdate;
    }

    /**
     * Get Update start time. We recommend you update LogListener during off-peak hours. 
     * @return UpdateStartTime Update start time. We recommend you update LogListener during off-peak hours.
     */
    public String getUpdateStartTime() {
        return this.UpdateStartTime;
    }

    /**
     * Set Update start time. We recommend you update LogListener during off-peak hours.
     * @param UpdateStartTime Update start time. We recommend you update LogListener during off-peak hours.
     */
    public void setUpdateStartTime(String UpdateStartTime) {
        this.UpdateStartTime = UpdateStartTime;
    }

    /**
     * Get Update end time. We recommend you update LogListener during off-peak hours. 
     * @return UpdateEndTime Update end time. We recommend you update LogListener during off-peak hours.
     */
    public String getUpdateEndTime() {
        return this.UpdateEndTime;
    }

    /**
     * Set Update end time. We recommend you update LogListener during off-peak hours.
     * @param UpdateEndTime Update end time. We recommend you update LogListener during off-peak hours.
     */
    public void setUpdateEndTime(String UpdateEndTime) {
        this.UpdateEndTime = UpdateEndTime;
    }

    /**
     * Get Whether to enable the service log to record the logs generated by the LogListener service itself. After it is enabled, the internal logset `cls_service_logging` and the `loglistener_status`, `loglistener_alarm`, and `loglistener_business` log topics will be created, which will not incur fees 
     * @return ServiceLogging Whether to enable the service log to record the logs generated by the LogListener service itself. After it is enabled, the internal logset `cls_service_logging` and the `loglistener_status`, `loglistener_alarm`, and `loglistener_business` log topics will be created, which will not incur fees
     */
    public Boolean getServiceLogging() {
        return this.ServiceLogging;
    }

    /**
     * Set Whether to enable the service log to record the logs generated by the LogListener service itself. After it is enabled, the internal logset `cls_service_logging` and the `loglistener_status`, `loglistener_alarm`, and `loglistener_business` log topics will be created, which will not incur fees
     * @param ServiceLogging Whether to enable the service log to record the logs generated by the LogListener service itself. After it is enabled, the internal logset `cls_service_logging` and the `loglistener_status`, `loglistener_alarm`, and `loglistener_business` log topics will be created, which will not incur fees
     */
    public void setServiceLogging(Boolean ServiceLogging) {
        this.ServiceLogging = ServiceLogging;
    }

    /**
     * Get Offline cleaning time for machines in machine group 
     * @return DelayCleanupTime Offline cleaning time for machines in machine group
     */
    public Long getDelayCleanupTime() {
        return this.DelayCleanupTime;
    }

    /**
     * Set Offline cleaning time for machines in machine group
     * @param DelayCleanupTime Offline cleaning time for machines in machine group
     */
    public void setDelayCleanupTime(Long DelayCleanupTime) {
        this.DelayCleanupTime = DelayCleanupTime;
    }

    /**
     * Get Metadata information list of a machine group 
     * @return MetaTags Metadata information list of a machine group
     */
    public MetaTagInfo [] getMetaTags() {
        return this.MetaTags;
    }

    /**
     * Set Metadata information list of a machine group
     * @param MetaTags Metadata information list of a machine group
     */
    public void setMetaTags(MetaTagInfo [] MetaTags) {
        this.MetaTags = MetaTags;
    }

    /**
     * Get System type, default 0, 0: Linux, 1: Windows 
     * @return OSType System type, default 0, 0: Linux, 1: Windows
     */
    public Long getOSType() {
        return this.OSType;
    }

    /**
     * Set System type, default 0, 0: Linux, 1: Windows
     * @param OSType System type, default 0, 0: Linux, 1: Windows
     */
    public void setOSType(Long OSType) {
        this.OSType = OSType;
    }

    public CreateMachineGroupRequest() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public CreateMachineGroupRequest(CreateMachineGroupRequest source) {
        if (source.GroupName != null) {
            this.GroupName = new String(source.GroupName);
        }
        if (source.MachineGroupType != null) {
            this.MachineGroupType = new MachineGroupTypeInfo(source.MachineGroupType);
        }
        if (source.Tags != null) {
            this.Tags = new Tag[source.Tags.length];
            for (int i = 0; i < source.Tags.length; i++) {
                this.Tags[i] = new Tag(source.Tags[i]);
            }
        }
        if (source.AutoUpdate != null) {
            this.AutoUpdate = new Boolean(source.AutoUpdate);
        }
        if (source.UpdateStartTime != null) {
            this.UpdateStartTime = new String(source.UpdateStartTime);
        }
        if (source.UpdateEndTime != null) {
            this.UpdateEndTime = new String(source.UpdateEndTime);
        }
        if (source.ServiceLogging != null) {
            this.ServiceLogging = new Boolean(source.ServiceLogging);
        }
        if (source.DelayCleanupTime != null) {
            this.DelayCleanupTime = new Long(source.DelayCleanupTime);
        }
        if (source.MetaTags != null) {
            this.MetaTags = new MetaTagInfo[source.MetaTags.length];
            for (int i = 0; i < source.MetaTags.length; i++) {
                this.MetaTags[i] = new MetaTagInfo(source.MetaTags[i]);
            }
        }
        if (source.OSType != null) {
            this.OSType = new Long(source.OSType);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "GroupName", this.GroupName);
        this.setParamObj(map, prefix + "MachineGroupType.", this.MachineGroupType);
        this.setParamArrayObj(map, prefix + "Tags.", this.Tags);
        this.setParamSimple(map, prefix + "AutoUpdate", this.AutoUpdate);
        this.setParamSimple(map, prefix + "UpdateStartTime", this.UpdateStartTime);
        this.setParamSimple(map, prefix + "UpdateEndTime", this.UpdateEndTime);
        this.setParamSimple(map, prefix + "ServiceLogging", this.ServiceLogging);
        this.setParamSimple(map, prefix + "DelayCleanupTime", this.DelayCleanupTime);
        this.setParamArrayObj(map, prefix + "MetaTags.", this.MetaTags);
        this.setParamSimple(map, prefix + "OSType", this.OSType);

    }
}

