/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cls.v20201016.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeKafkaConsumerResponse extends AbstractModel {

    /**
    * Whether Kafka Protocol Consumption is enabled
    */
    @SerializedName("Status")
    @Expose
    private Boolean Status;

    /**
    * Topic Parameter used by KafkaConsumer during consumption
    */
    @SerializedName("TopicID")
    @Expose
    private String TopicID;

    /**
    * Compression mode [0: NONE; 2: SNAPPY; 3: LZ4]
    */
    @SerializedName("Compression")
    @Expose
    private Long Compression;

    /**
    * Kafka protocol consumer data format
    */
    @SerializedName("ConsumerContent")
    @Expose
    private KafkaConsumerContent ConsumerContent;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Whether Kafka Protocol Consumption is enabled 
     * @return Status Whether Kafka Protocol Consumption is enabled
     */
    public Boolean getStatus() {
        return this.Status;
    }

    /**
     * Set Whether Kafka Protocol Consumption is enabled
     * @param Status Whether Kafka Protocol Consumption is enabled
     */
    public void setStatus(Boolean Status) {
        this.Status = Status;
    }

    /**
     * Get Topic Parameter used by KafkaConsumer during consumption 
     * @return TopicID Topic Parameter used by KafkaConsumer during consumption
     */
    public String getTopicID() {
        return this.TopicID;
    }

    /**
     * Set Topic Parameter used by KafkaConsumer during consumption
     * @param TopicID Topic Parameter used by KafkaConsumer during consumption
     */
    public void setTopicID(String TopicID) {
        this.TopicID = TopicID;
    }

    /**
     * Get Compression mode [0: NONE; 2: SNAPPY; 3: LZ4] 
     * @return Compression Compression mode [0: NONE; 2: SNAPPY; 3: LZ4]
     */
    public Long getCompression() {
        return this.Compression;
    }

    /**
     * Set Compression mode [0: NONE; 2: SNAPPY; 3: LZ4]
     * @param Compression Compression mode [0: NONE; 2: SNAPPY; 3: LZ4]
     */
    public void setCompression(Long Compression) {
        this.Compression = Compression;
    }

    /**
     * Get Kafka protocol consumer data format 
     * @return ConsumerContent Kafka protocol consumer data format
     */
    public KafkaConsumerContent getConsumerContent() {
        return this.ConsumerContent;
    }

    /**
     * Set Kafka protocol consumer data format
     * @param ConsumerContent Kafka protocol consumer data format
     */
    public void setConsumerContent(KafkaConsumerContent ConsumerContent) {
        this.ConsumerContent = ConsumerContent;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeKafkaConsumerResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeKafkaConsumerResponse(DescribeKafkaConsumerResponse source) {
        if (source.Status != null) {
            this.Status = new Boolean(source.Status);
        }
        if (source.TopicID != null) {
            this.TopicID = new String(source.TopicID);
        }
        if (source.Compression != null) {
            this.Compression = new Long(source.Compression);
        }
        if (source.ConsumerContent != null) {
            this.ConsumerContent = new KafkaConsumerContent(source.ConsumerContent);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Status", this.Status);
        this.setParamSimple(map, prefix + "TopicID", this.TopicID);
        this.setParamSimple(map, prefix + "Compression", this.Compression);
        this.setParamObj(map, prefix + "ConsumerContent.", this.ConsumerContent);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

