/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cls.v20201016.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeLogContextResponse extends AbstractModel {

    /**
    * Log context information set
    */
    @SerializedName("LogContextInfos")
    @Expose
    private LogContextInfo [] LogContextInfos;

    /**
    * Whether the previous logs have been fully returned (PrevOver is false indicates that some previous logs are yet to be returned).
    */
    @SerializedName("PrevOver")
    @Expose
    private Boolean PrevOver;

    /**
    * Whether the subsequent logs have been fully returned (NextOver is false indicates that some subsequent logs are yet to be returned).
    */
    @SerializedName("NextOver")
    @Expose
    private Boolean NextOver;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Log context information set 
     * @return LogContextInfos Log context information set
     */
    public LogContextInfo [] getLogContextInfos() {
        return this.LogContextInfos;
    }

    /**
     * Set Log context information set
     * @param LogContextInfos Log context information set
     */
    public void setLogContextInfos(LogContextInfo [] LogContextInfos) {
        this.LogContextInfos = LogContextInfos;
    }

    /**
     * Get Whether the previous logs have been fully returned (PrevOver is false indicates that some previous logs are yet to be returned). 
     * @return PrevOver Whether the previous logs have been fully returned (PrevOver is false indicates that some previous logs are yet to be returned).
     */
    public Boolean getPrevOver() {
        return this.PrevOver;
    }

    /**
     * Set Whether the previous logs have been fully returned (PrevOver is false indicates that some previous logs are yet to be returned).
     * @param PrevOver Whether the previous logs have been fully returned (PrevOver is false indicates that some previous logs are yet to be returned).
     */
    public void setPrevOver(Boolean PrevOver) {
        this.PrevOver = PrevOver;
    }

    /**
     * Get Whether the subsequent logs have been fully returned (NextOver is false indicates that some subsequent logs are yet to be returned). 
     * @return NextOver Whether the subsequent logs have been fully returned (NextOver is false indicates that some subsequent logs are yet to be returned).
     */
    public Boolean getNextOver() {
        return this.NextOver;
    }

    /**
     * Set Whether the subsequent logs have been fully returned (NextOver is false indicates that some subsequent logs are yet to be returned).
     * @param NextOver Whether the subsequent logs have been fully returned (NextOver is false indicates that some subsequent logs are yet to be returned).
     */
    public void setNextOver(Boolean NextOver) {
        this.NextOver = NextOver;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeLogContextResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeLogContextResponse(DescribeLogContextResponse source) {
        if (source.LogContextInfos != null) {
            this.LogContextInfos = new LogContextInfo[source.LogContextInfos.length];
            for (int i = 0; i < source.LogContextInfos.length; i++) {
                this.LogContextInfos[i] = new LogContextInfo(source.LogContextInfos[i]);
            }
        }
        if (source.PrevOver != null) {
            this.PrevOver = new Boolean(source.PrevOver);
        }
        if (source.NextOver != null) {
            this.NextOver = new Boolean(source.NextOver);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "LogContextInfos.", this.LogContextInfos);
        this.setParamSimple(map, prefix + "PrevOver", this.PrevOver);
        this.setParamSimple(map, prefix + "NextOver", this.NextOver);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

