/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cls.v20201016.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class GetAlarmLogResponse extends AbstractModel {

    /**
    * Context for loading subsequent details
    */
    @SerializedName("Context")
    @Expose
    private String Context;

    /**
    * Whether alarm execution details within a specified time range are fully returned
    */
    @SerializedName("ListOver")
    @Expose
    private Boolean ListOver;

    /**
    * Whether return value is SQL analysis result or not
    */
    @SerializedName("Analysis")
    @Expose
    private Boolean Analysis;

    /**
    * Column names of analysis results. If the Query statement contains an SQL query, then column names of the queried fields will be returned;Otherwise, it will be empty.
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("ColNames")
    @Expose
    private String [] ColNames;

    /**
    * Execution details query results.
When there is no SQL statement in the Query field, it returns query results.
When there is an SQL statement in the Query field, it may return null.
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("Results")
    @Expose
    private LogInfo [] Results;

    /**
    * Execution details statistical analysis results. When there is an SQL statement in the Query field, it returns SQL statistical results; otherwise, it may return null.

Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("AnalysisResults")
    @Expose
    private LogItems [] AnalysisResults;

    /**
    * Execution details statistical analysis results; only valid if UseNewAnalysis is true.Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("AnalysisRecords")
    @Expose
    private String [] AnalysisRecords;

    /**
    * Column names of analysis results, valid only if UseNewAnalysis is trueNote: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("Columns")
    @Expose
    private Column [] Columns;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Context for loading subsequent details 
     * @return Context Context for loading subsequent details
     */
    public String getContext() {
        return this.Context;
    }

    /**
     * Set Context for loading subsequent details
     * @param Context Context for loading subsequent details
     */
    public void setContext(String Context) {
        this.Context = Context;
    }

    /**
     * Get Whether alarm execution details within a specified time range are fully returned 
     * @return ListOver Whether alarm execution details within a specified time range are fully returned
     */
    public Boolean getListOver() {
        return this.ListOver;
    }

    /**
     * Set Whether alarm execution details within a specified time range are fully returned
     * @param ListOver Whether alarm execution details within a specified time range are fully returned
     */
    public void setListOver(Boolean ListOver) {
        this.ListOver = ListOver;
    }

    /**
     * Get Whether return value is SQL analysis result or not 
     * @return Analysis Whether return value is SQL analysis result or not
     */
    public Boolean getAnalysis() {
        return this.Analysis;
    }

    /**
     * Set Whether return value is SQL analysis result or not
     * @param Analysis Whether return value is SQL analysis result or not
     */
    public void setAnalysis(Boolean Analysis) {
        this.Analysis = Analysis;
    }

    /**
     * Get Column names of analysis results. If the Query statement contains an SQL query, then column names of the queried fields will be returned;Otherwise, it will be empty.
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return ColNames Column names of analysis results. If the Query statement contains an SQL query, then column names of the queried fields will be returned;Otherwise, it will be empty.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String [] getColNames() {
        return this.ColNames;
    }

    /**
     * Set Column names of analysis results. If the Query statement contains an SQL query, then column names of the queried fields will be returned;Otherwise, it will be empty.
Note: This field may return null, indicating that no valid values can be obtained.
     * @param ColNames Column names of analysis results. If the Query statement contains an SQL query, then column names of the queried fields will be returned;Otherwise, it will be empty.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setColNames(String [] ColNames) {
        this.ColNames = ColNames;
    }

    /**
     * Get Execution details query results.
When there is no SQL statement in the Query field, it returns query results.
When there is an SQL statement in the Query field, it may return null.
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return Results Execution details query results.
When there is no SQL statement in the Query field, it returns query results.
When there is an SQL statement in the Query field, it may return null.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public LogInfo [] getResults() {
        return this.Results;
    }

    /**
     * Set Execution details query results.
When there is no SQL statement in the Query field, it returns query results.
When there is an SQL statement in the Query field, it may return null.
Note: This field may return null, indicating that no valid values can be obtained.
     * @param Results Execution details query results.
When there is no SQL statement in the Query field, it returns query results.
When there is an SQL statement in the Query field, it may return null.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setResults(LogInfo [] Results) {
        this.Results = Results;
    }

    /**
     * Get Execution details statistical analysis results. When there is an SQL statement in the Query field, it returns SQL statistical results; otherwise, it may return null.

Note: This field may return null, indicating that no valid values can be obtained. 
     * @return AnalysisResults Execution details statistical analysis results. When there is an SQL statement in the Query field, it returns SQL statistical results; otherwise, it may return null.

Note: This field may return null, indicating that no valid values can be obtained.
     */
    public LogItems [] getAnalysisResults() {
        return this.AnalysisResults;
    }

    /**
     * Set Execution details statistical analysis results. When there is an SQL statement in the Query field, it returns SQL statistical results; otherwise, it may return null.

Note: This field may return null, indicating that no valid values can be obtained.
     * @param AnalysisResults Execution details statistical analysis results. When there is an SQL statement in the Query field, it returns SQL statistical results; otherwise, it may return null.

Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setAnalysisResults(LogItems [] AnalysisResults) {
        this.AnalysisResults = AnalysisResults;
    }

    /**
     * Get Execution details statistical analysis results; only valid if UseNewAnalysis is true.Note: This field may return null, indicating that no valid values can be obtained. 
     * @return AnalysisRecords Execution details statistical analysis results; only valid if UseNewAnalysis is true.Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String [] getAnalysisRecords() {
        return this.AnalysisRecords;
    }

    /**
     * Set Execution details statistical analysis results; only valid if UseNewAnalysis is true.Note: This field may return null, indicating that no valid values can be obtained.
     * @param AnalysisRecords Execution details statistical analysis results; only valid if UseNewAnalysis is true.Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setAnalysisRecords(String [] AnalysisRecords) {
        this.AnalysisRecords = AnalysisRecords;
    }

    /**
     * Get Column names of analysis results, valid only if UseNewAnalysis is trueNote: This field may return null, indicating that no valid values can be obtained. 
     * @return Columns Column names of analysis results, valid only if UseNewAnalysis is trueNote: This field may return null, indicating that no valid values can be obtained.
     */
    public Column [] getColumns() {
        return this.Columns;
    }

    /**
     * Set Column names of analysis results, valid only if UseNewAnalysis is trueNote: This field may return null, indicating that no valid values can be obtained.
     * @param Columns Column names of analysis results, valid only if UseNewAnalysis is trueNote: This field may return null, indicating that no valid values can be obtained.
     */
    public void setColumns(Column [] Columns) {
        this.Columns = Columns;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public GetAlarmLogResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public GetAlarmLogResponse(GetAlarmLogResponse source) {
        if (source.Context != null) {
            this.Context = new String(source.Context);
        }
        if (source.ListOver != null) {
            this.ListOver = new Boolean(source.ListOver);
        }
        if (source.Analysis != null) {
            this.Analysis = new Boolean(source.Analysis);
        }
        if (source.ColNames != null) {
            this.ColNames = new String[source.ColNames.length];
            for (int i = 0; i < source.ColNames.length; i++) {
                this.ColNames[i] = new String(source.ColNames[i]);
            }
        }
        if (source.Results != null) {
            this.Results = new LogInfo[source.Results.length];
            for (int i = 0; i < source.Results.length; i++) {
                this.Results[i] = new LogInfo(source.Results[i]);
            }
        }
        if (source.AnalysisResults != null) {
            this.AnalysisResults = new LogItems[source.AnalysisResults.length];
            for (int i = 0; i < source.AnalysisResults.length; i++) {
                this.AnalysisResults[i] = new LogItems(source.AnalysisResults[i]);
            }
        }
        if (source.AnalysisRecords != null) {
            this.AnalysisRecords = new String[source.AnalysisRecords.length];
            for (int i = 0; i < source.AnalysisRecords.length; i++) {
                this.AnalysisRecords[i] = new String(source.AnalysisRecords[i]);
            }
        }
        if (source.Columns != null) {
            this.Columns = new Column[source.Columns.length];
            for (int i = 0; i < source.Columns.length; i++) {
                this.Columns[i] = new Column(source.Columns[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Context", this.Context);
        this.setParamSimple(map, prefix + "ListOver", this.ListOver);
        this.setParamSimple(map, prefix + "Analysis", this.Analysis);
        this.setParamArraySimple(map, prefix + "ColNames.", this.ColNames);
        this.setParamArrayObj(map, prefix + "Results.", this.Results);
        this.setParamArrayObj(map, prefix + "AnalysisResults.", this.AnalysisResults);
        this.setParamArraySimple(map, prefix + "AnalysisRecords.", this.AnalysisRecords);
        this.setParamArrayObj(map, prefix + "Columns.", this.Columns);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

