/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cls.v20201016.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class SearchCosRechargeInfoResponse extends AbstractModel {

    /**
    * The first few lines of a file under a matched bucketNote: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("Data")
    @Expose
    private String [] Data;

    /**
    * Number of files under the matched bucket
    */
    @SerializedName("Sum")
    @Expose
    private Long Sum;

    /**
    * Current preview file path
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("Path")
    @Expose
    private String Path;

    /**
    * Reason for preview data retrieval failureNote: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("Msg")
    @Expose
    private String Msg;

    /**
    * Status
    */
    @SerializedName("Status")
    @Expose
    private Long Status;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get The first few lines of a file under a matched bucketNote: This field may return null, indicating that no valid values can be obtained. 
     * @return Data The first few lines of a file under a matched bucketNote: This field may return null, indicating that no valid values can be obtained.
     */
    public String [] getData() {
        return this.Data;
    }

    /**
     * Set The first few lines of a file under a matched bucketNote: This field may return null, indicating that no valid values can be obtained.
     * @param Data The first few lines of a file under a matched bucketNote: This field may return null, indicating that no valid values can be obtained.
     */
    public void setData(String [] Data) {
        this.Data = Data;
    }

    /**
     * Get Number of files under the matched bucket 
     * @return Sum Number of files under the matched bucket
     */
    public Long getSum() {
        return this.Sum;
    }

    /**
     * Set Number of files under the matched bucket
     * @param Sum Number of files under the matched bucket
     */
    public void setSum(Long Sum) {
        this.Sum = Sum;
    }

    /**
     * Get Current preview file path
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return Path Current preview file path
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String getPath() {
        return this.Path;
    }

    /**
     * Set Current preview file path
Note: This field may return null, indicating that no valid values can be obtained.
     * @param Path Current preview file path
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setPath(String Path) {
        this.Path = Path;
    }

    /**
     * Get Reason for preview data retrieval failureNote: This field may return null, indicating that no valid values can be obtained. 
     * @return Msg Reason for preview data retrieval failureNote: This field may return null, indicating that no valid values can be obtained.
     */
    public String getMsg() {
        return this.Msg;
    }

    /**
     * Set Reason for preview data retrieval failureNote: This field may return null, indicating that no valid values can be obtained.
     * @param Msg Reason for preview data retrieval failureNote: This field may return null, indicating that no valid values can be obtained.
     */
    public void setMsg(String Msg) {
        this.Msg = Msg;
    }

    /**
     * Get Status 
     * @return Status Status
     */
    public Long getStatus() {
        return this.Status;
    }

    /**
     * Set Status
     * @param Status Status
     */
    public void setStatus(Long Status) {
        this.Status = Status;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public SearchCosRechargeInfoResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public SearchCosRechargeInfoResponse(SearchCosRechargeInfoResponse source) {
        if (source.Data != null) {
            this.Data = new String[source.Data.length];
            for (int i = 0; i < source.Data.length; i++) {
                this.Data[i] = new String(source.Data[i]);
            }
        }
        if (source.Sum != null) {
            this.Sum = new Long(source.Sum);
        }
        if (source.Path != null) {
            this.Path = new String(source.Path);
        }
        if (source.Msg != null) {
            this.Msg = new String(source.Msg);
        }
        if (source.Status != null) {
            this.Status = new Long(source.Status);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArraySimple(map, prefix + "Data.", this.Data);
        this.setParamSimple(map, prefix + "Sum", this.Sum);
        this.setParamSimple(map, prefix + "Path", this.Path);
        this.setParamSimple(map, prefix + "Msg", this.Msg);
        this.setParamSimple(map, prefix + "Status", this.Status);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

