/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.config.v20220802.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeDiscoveredResourceResponse extends AbstractModel {

    /**
    * Resource ID

Note: This field may return null, indicating that no valid value is found.
    */
    @SerializedName("ResourceId")
    @Expose
    private String ResourceId;

    /**
    * Resource type

Note: This field may return null, indicating that no valid value is found.
    */
    @SerializedName("ResourceType")
    @Expose
    private String ResourceType;

    /**
    * Resource Name

Note: This field may return null, indicating that no valid value is found.
    */
    @SerializedName("ResourceName")
    @Expose
    private String ResourceName;

    /**
    * Resource region

Note: This field may return null, indicating that no valid value is found.
    */
    @SerializedName("ResourceRegion")
    @Expose
    private String ResourceRegion;

    /**
    * Resource availability zone
Note: This field may return null, indicating that no valid value is found.
    */
    @SerializedName("ResourceZone")
    @Expose
    private String ResourceZone;

    /**
    * Resource configuration

Note: This field may return null, indicating that no valid value is found.
    */
    @SerializedName("Configuration")
    @Expose
    private String Configuration;

    /**
    * Resource creation time

Note: This field may return null, indicating that no valid value is found.
    */
    @SerializedName("ResourceCreateTime")
    @Expose
    private String ResourceCreateTime;

    /**
    * Resource tag

Note: This field may return null, indicating that no valid value is found.
    */
    @SerializedName("Tags")
    @Expose
    private Tag [] Tags;

    /**
    * Resource update time
Note: This field may return null, indicating that no valid value is found.
    */
    @SerializedName("UpdateTime")
    @Expose
    private String UpdateTime;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Resource ID

Note: This field may return null, indicating that no valid value is found. 
     * @return ResourceId Resource ID

Note: This field may return null, indicating that no valid value is found.
     */
    public String getResourceId() {
        return this.ResourceId;
    }

    /**
     * Set Resource ID

Note: This field may return null, indicating that no valid value is found.
     * @param ResourceId Resource ID

Note: This field may return null, indicating that no valid value is found.
     */
    public void setResourceId(String ResourceId) {
        this.ResourceId = ResourceId;
    }

    /**
     * Get Resource type

Note: This field may return null, indicating that no valid value is found. 
     * @return ResourceType Resource type

Note: This field may return null, indicating that no valid value is found.
     */
    public String getResourceType() {
        return this.ResourceType;
    }

    /**
     * Set Resource type

Note: This field may return null, indicating that no valid value is found.
     * @param ResourceType Resource type

Note: This field may return null, indicating that no valid value is found.
     */
    public void setResourceType(String ResourceType) {
        this.ResourceType = ResourceType;
    }

    /**
     * Get Resource Name

Note: This field may return null, indicating that no valid value is found. 
     * @return ResourceName Resource Name

Note: This field may return null, indicating that no valid value is found.
     */
    public String getResourceName() {
        return this.ResourceName;
    }

    /**
     * Set Resource Name

Note: This field may return null, indicating that no valid value is found.
     * @param ResourceName Resource Name

Note: This field may return null, indicating that no valid value is found.
     */
    public void setResourceName(String ResourceName) {
        this.ResourceName = ResourceName;
    }

    /**
     * Get Resource region

Note: This field may return null, indicating that no valid value is found. 
     * @return ResourceRegion Resource region

Note: This field may return null, indicating that no valid value is found.
     */
    public String getResourceRegion() {
        return this.ResourceRegion;
    }

    /**
     * Set Resource region

Note: This field may return null, indicating that no valid value is found.
     * @param ResourceRegion Resource region

Note: This field may return null, indicating that no valid value is found.
     */
    public void setResourceRegion(String ResourceRegion) {
        this.ResourceRegion = ResourceRegion;
    }

    /**
     * Get Resource availability zone
Note: This field may return null, indicating that no valid value is found. 
     * @return ResourceZone Resource availability zone
Note: This field may return null, indicating that no valid value is found.
     */
    public String getResourceZone() {
        return this.ResourceZone;
    }

    /**
     * Set Resource availability zone
Note: This field may return null, indicating that no valid value is found.
     * @param ResourceZone Resource availability zone
Note: This field may return null, indicating that no valid value is found.
     */
    public void setResourceZone(String ResourceZone) {
        this.ResourceZone = ResourceZone;
    }

    /**
     * Get Resource configuration

Note: This field may return null, indicating that no valid value is found. 
     * @return Configuration Resource configuration

Note: This field may return null, indicating that no valid value is found.
     */
    public String getConfiguration() {
        return this.Configuration;
    }

    /**
     * Set Resource configuration

Note: This field may return null, indicating that no valid value is found.
     * @param Configuration Resource configuration

Note: This field may return null, indicating that no valid value is found.
     */
    public void setConfiguration(String Configuration) {
        this.Configuration = Configuration;
    }

    /**
     * Get Resource creation time

Note: This field may return null, indicating that no valid value is found. 
     * @return ResourceCreateTime Resource creation time

Note: This field may return null, indicating that no valid value is found.
     */
    public String getResourceCreateTime() {
        return this.ResourceCreateTime;
    }

    /**
     * Set Resource creation time

Note: This field may return null, indicating that no valid value is found.
     * @param ResourceCreateTime Resource creation time

Note: This field may return null, indicating that no valid value is found.
     */
    public void setResourceCreateTime(String ResourceCreateTime) {
        this.ResourceCreateTime = ResourceCreateTime;
    }

    /**
     * Get Resource tag

Note: This field may return null, indicating that no valid value is found. 
     * @return Tags Resource tag

Note: This field may return null, indicating that no valid value is found.
     */
    public Tag [] getTags() {
        return this.Tags;
    }

    /**
     * Set Resource tag

Note: This field may return null, indicating that no valid value is found.
     * @param Tags Resource tag

Note: This field may return null, indicating that no valid value is found.
     */
    public void setTags(Tag [] Tags) {
        this.Tags = Tags;
    }

    /**
     * Get Resource update time
Note: This field may return null, indicating that no valid value is found. 
     * @return UpdateTime Resource update time
Note: This field may return null, indicating that no valid value is found.
     */
    public String getUpdateTime() {
        return this.UpdateTime;
    }

    /**
     * Set Resource update time
Note: This field may return null, indicating that no valid value is found.
     * @param UpdateTime Resource update time
Note: This field may return null, indicating that no valid value is found.
     */
    public void setUpdateTime(String UpdateTime) {
        this.UpdateTime = UpdateTime;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeDiscoveredResourceResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeDiscoveredResourceResponse(DescribeDiscoveredResourceResponse source) {
        if (source.ResourceId != null) {
            this.ResourceId = new String(source.ResourceId);
        }
        if (source.ResourceType != null) {
            this.ResourceType = new String(source.ResourceType);
        }
        if (source.ResourceName != null) {
            this.ResourceName = new String(source.ResourceName);
        }
        if (source.ResourceRegion != null) {
            this.ResourceRegion = new String(source.ResourceRegion);
        }
        if (source.ResourceZone != null) {
            this.ResourceZone = new String(source.ResourceZone);
        }
        if (source.Configuration != null) {
            this.Configuration = new String(source.Configuration);
        }
        if (source.ResourceCreateTime != null) {
            this.ResourceCreateTime = new String(source.ResourceCreateTime);
        }
        if (source.Tags != null) {
            this.Tags = new Tag[source.Tags.length];
            for (int i = 0; i < source.Tags.length; i++) {
                this.Tags[i] = new Tag(source.Tags[i]);
            }
        }
        if (source.UpdateTime != null) {
            this.UpdateTime = new String(source.UpdateTime);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "ResourceId", this.ResourceId);
        this.setParamSimple(map, prefix + "ResourceType", this.ResourceType);
        this.setParamSimple(map, prefix + "ResourceName", this.ResourceName);
        this.setParamSimple(map, prefix + "ResourceRegion", this.ResourceRegion);
        this.setParamSimple(map, prefix + "ResourceZone", this.ResourceZone);
        this.setParamSimple(map, prefix + "Configuration", this.Configuration);
        this.setParamSimple(map, prefix + "ResourceCreateTime", this.ResourceCreateTime);
        this.setParamArrayObj(map, prefix + "Tags.", this.Tags);
        this.setParamSimple(map, prefix + "UpdateTime", this.UpdateTime);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

