/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.csip.v20221121.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeOrganizationUserInfoResponse extends AbstractModel {

    /**
    * Total number of items
    */
    @SerializedName("TotalCount")
    @Expose
    private Long TotalCount;

    /**
    * Group User List
    */
    @SerializedName("Data")
    @Expose
    private OrganizationUserInfo [] Data;

    /**
    * Join method enumeration
    */
    @SerializedName("JoinTypeLst")
    @Expose
    private FilterDataObject [] JoinTypeLst;

    /**
    * Cloud vendor enumeration
    */
    @SerializedName("CloudTypeLst")
    @Expose
    private FilterDataObject [] CloudTypeLst;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Total number of items 
     * @return TotalCount Total number of items
     */
    public Long getTotalCount() {
        return this.TotalCount;
    }

    /**
     * Set Total number of items
     * @param TotalCount Total number of items
     */
    public void setTotalCount(Long TotalCount) {
        this.TotalCount = TotalCount;
    }

    /**
     * Get Group User List 
     * @return Data Group User List
     */
    public OrganizationUserInfo [] getData() {
        return this.Data;
    }

    /**
     * Set Group User List
     * @param Data Group User List
     */
    public void setData(OrganizationUserInfo [] Data) {
        this.Data = Data;
    }

    /**
     * Get Join method enumeration 
     * @return JoinTypeLst Join method enumeration
     */
    public FilterDataObject [] getJoinTypeLst() {
        return this.JoinTypeLst;
    }

    /**
     * Set Join method enumeration
     * @param JoinTypeLst Join method enumeration
     */
    public void setJoinTypeLst(FilterDataObject [] JoinTypeLst) {
        this.JoinTypeLst = JoinTypeLst;
    }

    /**
     * Get Cloud vendor enumeration 
     * @return CloudTypeLst Cloud vendor enumeration
     */
    public FilterDataObject [] getCloudTypeLst() {
        return this.CloudTypeLst;
    }

    /**
     * Set Cloud vendor enumeration
     * @param CloudTypeLst Cloud vendor enumeration
     */
    public void setCloudTypeLst(FilterDataObject [] CloudTypeLst) {
        this.CloudTypeLst = CloudTypeLst;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeOrganizationUserInfoResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeOrganizationUserInfoResponse(DescribeOrganizationUserInfoResponse source) {
        if (source.TotalCount != null) {
            this.TotalCount = new Long(source.TotalCount);
        }
        if (source.Data != null) {
            this.Data = new OrganizationUserInfo[source.Data.length];
            for (int i = 0; i < source.Data.length; i++) {
                this.Data[i] = new OrganizationUserInfo(source.Data[i]);
            }
        }
        if (source.JoinTypeLst != null) {
            this.JoinTypeLst = new FilterDataObject[source.JoinTypeLst.length];
            for (int i = 0; i < source.JoinTypeLst.length; i++) {
                this.JoinTypeLst[i] = new FilterDataObject(source.JoinTypeLst[i]);
            }
        }
        if (source.CloudTypeLst != null) {
            this.CloudTypeLst = new FilterDataObject[source.CloudTypeLst.length];
            for (int i = 0; i < source.CloudTypeLst.length; i++) {
                this.CloudTypeLst[i] = new FilterDataObject(source.CloudTypeLst[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "TotalCount", this.TotalCount);
        this.setParamArrayObj(map, prefix + "Data.", this.Data);
        this.setParamArrayObj(map, prefix + "JoinTypeLst.", this.JoinTypeLst);
        this.setParamArrayObj(map, prefix + "CloudTypeLst.", this.CloudTypeLst);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

